/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.disjunctive;

import choco.cp.solver.constraints.global.scheduling.disjunctive.AbstractDisjRules;
import choco.cp.solver.constraints.global.scheduling.disjunctive.IBipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.trees.AltDisjTreeTL;
import choco.cp.solver.constraints.global.scheduling.trees.AltDisjTreeTLTO;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.util.comparator.TaskComparators;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntProcedure;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.scheduling.IRMakespan;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class AltDisjRules
extends AbstractDisjRules
implements Iterable<IRTask>,
IStateIntProcedure {
    private final IStateInt size;
    private AltBipartiteQueue<IRTask> rqueue;
    protected AltDisjTreeTL altDisjTreeTL;
    protected AltDisjTreeTLTO altDisjTreeTLTO;

    public AltDisjRules(IRTask[] rtasks, IRMakespan makespan, IEnvironment environment) {
        super(rtasks, makespan, true);
        this.size = environment.makeIntProcedure(this, rtasks.length);
        this.rqueue = new AltBipartiteQueue<IRTask>(rtasks);
        ITask[] tasks = this.getTaskArray();
        this.altDisjTreeTL = new AltDisjTreeTL(Arrays.asList(tasks));
        this.altDisjTreeTLTO = new AltDisjTreeTLTO(Arrays.asList(tasks));
    }

    @Override
    protected void sortRTasks(Comparator<IRTask> cmp) {
        Arrays.sort(this.rtasks, 0, this.size.get(), cmp);
    }

    @Override
    public void apply(int oldVal, int newVal) {
        for (int i = oldVal; i < newVal; ++i) {
            this.altDisjTreeTL.insert(this.rtasks[i].getHTask());
            this.altDisjTreeTLTO.insert(this.rtasks[i].getHTask());
        }
    }

    private void setupListsAndTreeTL(Comparator<IRTask> taskComp, Comparator<IRTask> queueComp, IVilimTree.TreeMode mode) {
        this.sortRTasks(taskComp);
        AltDisjRules.sortQueue(this.rqueue, queueComp);
        this.setupMasterTree(this.altDisjTreeTL, mode);
    }

    @Override
    public boolean isActive() {
        return this.size.get() > 0;
    }

    private void makeRemovalSwap(IRTask[] rtasks, IRTask rtask) {
        for (int i = 0; i < this.size.get(); ++i) {
            if (rtasks[i] != rtask) continue;
            int newIndex = this.size.get() - 1;
            IRTask tmp = rtasks[i];
            rtasks[i] = rtasks[newIndex];
            rtasks[newIndex] = tmp;
            return;
        }
        throw new NoSuchElementException("cant remove task from the constraint .");
    }

    private void insertInTree(IRTask rtask) {
        if (rtask.isOptional()) {
            this.altDisjTreeTL.insertInLambda(rtask);
        } else if (rtask.isRegular()) {
            this.altDisjTreeTL.insertInTheta(rtask);
        }
    }

    private void setAsRemoval(IRTask respTask, boolean omega) throws ContradictionException {
        if (!omega) {
            this.updateManager.storeLambdaRemoval(respTask, this.altDisjTreeTLTO);
        } else {
            this.updateManager.storeOmegaRemoval(respTask, this.altDisjTreeTLTO);
        }
    }

    @Override
    public void remove(IRTask rtask) {
        this.makeRemovalSwap(this.rtasks, rtask);
        this.makeRemovalSwap((IRTask[])this.rqueue.elementData, rtask);
        this.altDisjTreeTL.remove(rtask.getHTask());
        this.altDisjTreeTLTO.remove(rtask.getHTask());
        this.size.add(-1);
    }

    @Override
    public boolean detectablePrecedenceEST() throws ContradictionException {
        this.setupListsAndTreeTL(TaskComparators.makeREarliestCompletionTimeCmp(), TaskComparators.makeRLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        for (IRTask rti : this) {
            ITask i = rti.getHTask();
            if (rti.isEliminated()) continue;
            while (!this.rqueue.isEmpty() && i.getECT() > this.rqueue.peek().getHTask().getLST()) {
                this.insertInTree(this.rqueue.poll());
            }
            boolean rm = false;
            if (rti.isRegular()) {
                rm = this.altDisjTreeTL.removeFromTheta(i);
            }
            if (this.altDisjTreeTL.getTime() > i.getEST()) {
                if (this.altDisjTreeTL.getTime() > i.getLST()) {
                    if (rti.isRegular()) {
                        rti.fail();
                    }
                    if (rti.isOptional()) {
                        if (this.altDisjTreeTL.getTaskType(rti) == 2) {
                            this.updateManager.storeLambdaRemoval(rti, this.altDisjTreeTL);
                        } else {
                            this.updateManager.storeRemoval(rti);
                        }
                    }
                } else {
                    this.updateManager.storeUpdate(rti, this.altDisjTreeTL.getTime());
                }
            }
            if (!rti.isRegular()) continue;
            while (this.altDisjTreeTL.getGrayTime() > i.getLST()) {
                this.updateManager.storeLambdaRemoval(this.altDisjTreeTL);
            }
            if (rm) assert (this.altDisjTreeTL.insertInTheta(i));
        }
        this.setMakespanLB(this.altDisjTreeTL);
        return this.updateManager.fireAndUpdateEST();
    }

    @Override
    public boolean detectablePrecedenceLCT() throws ContradictionException {
        this.setupListsAndTreeTL(TaskComparators.makeReverseRLatestStartingTimeCmp(), TaskComparators.makeReverseREarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        for (IRTask rti : this) {
            if (rti.isEliminated()) continue;
            ITask i = rti.getHTask();
            while (!this.rqueue.isEmpty() && i.getLST() < this.rqueue.peek().getHTask().getECT()) {
                this.insertInTree(this.rqueue.poll());
            }
            boolean rm = false;
            if (rti.isRegular()) {
                rm = this.altDisjTreeTL.removeFromTheta(i);
            }
            if (this.altDisjTreeTL.getTime() < i.getLCT()) {
                if (this.altDisjTreeTL.getTime() < i.getECT()) {
                    if (rti.isRegular()) {
                        rti.fail();
                    }
                    if (rti.isOptional()) {
                        if (this.altDisjTreeTL.getTaskType(rti) == 2) {
                            this.updateManager.storeLambdaRemoval(rti, this.altDisjTreeTL);
                        } else {
                            this.updateManager.storeRemoval(rti);
                        }
                    }
                } else {
                    this.updateManager.storeUpdate(rti, this.altDisjTreeTL.getTime());
                }
            }
            if (!rti.isRegular()) continue;
            while (this.altDisjTreeTL.getGrayTime() < i.getECT()) {
                this.updateManager.storeLambdaRemoval(this.altDisjTreeTL);
            }
            if (!rm) continue;
            this.altDisjTreeTL.insertInTheta(i);
        }
        return this.updateManager.fireAndUpdateLCT();
    }

    @Override
    public boolean notFirst() throws ContradictionException {
        this.setupListsAndTreeTL(TaskComparators.makeReverseREarliestStartingTimeCmp(), TaskComparators.makeReverseREarliestCompletionTimeCmp(), IVilimTree.TreeMode.LST);
        ITask j = null;
        ITask ja = null;
        for (IRTask rti : this) {
            ITask i = rti.getHTask();
            if (rti.isEliminated()) continue;
            while (!this.rqueue.isEmpty() && i.getEST() < this.rqueue.peek().getHTask().getECT()) {
                IRTask tmp = this.rqueue.poll();
                ja = tmp.getHTask();
                if (tmp.isRegular()) {
                    j = ja;
                }
                this.insertInTree(tmp);
            }
            boolean rm = false;
            if (rti.isRegular()) {
                rm = this.altDisjTreeTL.removeFromTheta(i);
            }
            if (this.altDisjTreeTL.getTime() < i.getECT() && j.getECT() > i.getEST()) {
                if (j.getECT() > i.getLST()) {
                    if (rti.isRegular()) {
                        rti.fail();
                    }
                    if (rti.isOptional()) {
                        assert (this.altDisjTreeTL.getTaskType(rti) == 2);
                        this.updateManager.storeLambdaRemoval(rti, this.altDisjTreeTL);
                    }
                } else {
                    this.updateManager.storeUpdate(rti, j.getECT());
                }
            }
            if (rti.isRegular() && i.getLST() < ja.getECT()) {
                while (this.altDisjTreeTL.getGrayTime() < i.getECT()) {
                    this.updateManager.storeLambdaRemoval(this.altDisjTreeTL);
                }
            }
            if (!rm) continue;
            this.altDisjTreeTL.insertInTheta(i);
        }
        return this.updateManager.fireAndUpdateEST();
    }

    @Override
    public boolean notLast() throws ContradictionException {
        this.setupListsAndTreeTL(TaskComparators.makeRLatestCompletionTimeCmp(), TaskComparators.makeRLatestStartingTimeCmp(), IVilimTree.TreeMode.ECT);
        ITask j = null;
        ITask ja = null;
        for (IRTask rti : this) {
            ITask i = rti.getHTask();
            if (rti.isEliminated()) continue;
            while (!this.rqueue.isEmpty() && i.getLCT() > this.rqueue.peek().getHTask().getLST()) {
                IRTask tmp = this.rqueue.poll();
                ja = tmp.getHTask();
                if (tmp.isRegular()) {
                    j = ja;
                }
                this.insertInTree(tmp);
            }
            boolean rm = false;
            if (rti.isRegular()) {
                rm = this.altDisjTreeTL.removeFromTheta(i);
            }
            if (this.altDisjTreeTL.getTime() > i.getLST() && j.getLST() < i.getLCT()) {
                if (j.getLST() < i.getECT()) {
                    if (rti.isRegular()) {
                        rti.fail();
                    }
                    if (rti.isOptional()) {
                        assert (this.altDisjTreeTL.getTaskType(rti) == 2);
                        this.updateManager.storeLambdaRemoval(rti, this.altDisjTreeTL);
                    }
                } else {
                    this.updateManager.storeUpdate(rti, j.getLST());
                }
            }
            if (rti.isRegular() && ja.getLST() < i.getECT()) {
                while (this.altDisjTreeTL.getGrayTime() > i.getLST()) {
                    this.updateManager.storeLambdaRemoval(this.altDisjTreeTL);
                }
            }
            if (rm) assert (this.altDisjTreeTL.insertInTheta(i));
        }
        this.setMakespanLB(this.altDisjTreeTL);
        return this.updateManager.fireAndUpdateLCT();
    }

    @Override
    public void overloadChecking() throws ContradictionException {
        this.sortRTasks(TaskComparators.makeRLatestCompletionTimeCmp());
        this.setupMasterTree(this.altDisjTreeTL, IVilimTree.TreeMode.ECT);
        for (IRTask t : this) {
            ITask i = t.getHTask();
            this.insertInTree(t);
            if (!t.isRegular()) continue;
            if (this.altDisjTreeTL.getTime() > i.getLCT()) {
                t.fail();
            }
            while (this.altDisjTreeTL.getGrayTime() > i.getLCT()) {
                this.updateManager.storeLambdaRemoval(this.altDisjTreeTL);
            }
        }
        this.setMakespanLB(this.altDisjTreeTL);
    }

    @Override
    public boolean edgeFindingEST() throws ContradictionException {
        this.setupEF(IVilimTree.TreeMode.ECT, TaskComparators.makeReverseRLatestCompletionTimeCmp());
        this.setMakespanLB(this.altDisjTreeTLTO);
        IRTask rtj = this.rqueue.peek();
        ITask j = rtj.getHTask();
        if (rtj.isRegular() && this.altDisjTreeTLTO.getTime() > j.getLCT()) {
            rtj.fail();
        }
        do {
            if (rtj.isOptional()) {
                this.altDisjTreeTLTO.removeFromOmegaAndInsertInLambda(rtj);
            } else if (rtj.isRegular()) {
                this.altDisjTreeTLTO.removeFromThetaAndInsertInLambda(rtj);
            }
            this.rqueue.poll();
            if (this.rqueue.isEmpty()) break;
            rtj = this.rqueue.peek();
            j = rtj.getHTask();
            if (rtj.isRegular()) {
                if (this.altDisjTreeTLTO.getTime() > j.getLCT()) {
                    rtj.fail();
                }
                this.checkTL(j, IVilimTree.TreeMode.ECT);
                this.checkTO(j, IVilimTree.TreeMode.ECT);
                this.checkFTLO(j, IVilimTree.TreeMode.ECT);
                continue;
            }
            if (!rtj.isOptional()) continue;
            this.checkSTLOEST(rtj);
        } while (!this.rqueue.isEmpty());
        return this.updateManager.fireAndUpdateEST();
    }

    private int[] calculateECTTOL(int[] ectTUnionOArr) {
        int[] results = new int[2];
        int ectT = Integer.MIN_VALUE;
        int ectTL = Integer.MIN_VALUE;
        int ectTO = Integer.MIN_VALUE;
        int ectTOL = Integer.MIN_VALUE;
        int respTOLIdx = -1;
        int respTOIdx = -1;
        int respEnabledIdx = -1;
        for (int j = 0; j < this.size.get(); ++j) {
            int newEctTOL;
            int newEctTL;
            IRTask rtaskAtj = this.rtasks[j];
            ITask taskAtj = rtaskAtj.getHTask();
            int taskType = this.altDisjTreeTLTO.getTaskType(rtaskAtj);
            if (taskType == 1) {
                assert (rtaskAtj.isRegular());
                int newEctT = ectT + taskAtj.getMinDuration();
                ectT = Math.max(newEctT, taskAtj.getECT());
                newEctTL = ectTL + taskAtj.getMinDuration();
                ectTL = Math.max(newEctTL, taskAtj.getECT());
                int newEctTO = ectTO + taskAtj.getMinDuration();
                ectTO = respTOIdx == -1 ? Math.max(newEctTO, taskAtj.getECT()) : newEctTO;
                int newEctTOL2 = ectTOL + taskAtj.getMinDuration();
                if (respTOLIdx == -1) {
                    ectTOL = Math.max(newEctTOL2, taskAtj.getECT());
                    continue;
                }
                ectTOL = newEctTOL2;
                continue;
            }
            if (taskType == 2) {
                assert (rtaskAtj.isOptional());
                newEctTOL = ectTOL;
                if (respTOLIdx == -1 || newEctTOL < taskAtj.getECT()) {
                    newEctTOL = taskAtj.getECT();
                    respTOLIdx = j;
                }
                if (newEctTOL < ectT + taskAtj.getMinDuration()) {
                    newEctTOL = ectT + taskAtj.getMinDuration();
                    respTOLIdx = j;
                }
                if (newEctTOL < ectTL + taskAtj.getMinDuration() && respEnabledIdx != -1 && this.rtasks[respEnabledIdx].getHTask().getLST() < ectTUnionOArr[j]) {
                    newEctTOL = ectTL + taskAtj.getMinDuration();
                    respTOLIdx = j;
                }
                ectTOL = newEctTOL;
                int newEctTO = ectTO;
                if (respTOIdx == -1 || newEctTO < taskAtj.getECT()) {
                    newEctTO = taskAtj.getECT();
                    respTOIdx = j;
                }
                if (newEctTO < ectT + taskAtj.getMinDuration()) {
                    newEctTO = ectT + taskAtj.getMinDuration();
                    respTOIdx = j;
                }
                ectTO = newEctTO;
                continue;
            }
            if (!rtaskAtj.isRegular()) continue;
            newEctTOL = ectTOL;
            if (newEctTOL < ectTO + taskAtj.getMinDuration()) {
                if (respTOLIdx == -1) {
                    assert (respTOIdx == -1);
                    newEctTOL = ectTO + taskAtj.getMinDuration();
                } else if (taskAtj.getLST() < ectTUnionOArr[respTOIdx]) {
                    newEctTOL = ectTO + taskAtj.getMinDuration();
                    respTOLIdx = respTOIdx;
                }
            }
            if (newEctTOL < taskAtj.getECT() && respTOLIdx == -1) {
                newEctTOL = taskAtj.getECT();
            }
            ectTOL = newEctTOL;
            newEctTL = Math.max(taskAtj.getECT(), ectT + taskAtj.getMinDuration());
            if (newEctTL <= ectTL) continue;
            ectTL = newEctTL;
            respEnabledIdx = j;
        }
        assert (this.altDisjTreeTLTO.getTime() == ectT);
        results[0] = ectTOL;
        results[1] = respTOLIdx;
        return results;
    }

    private void checkFTLO(ITask j, IVilimTree.TreeMode mode) throws ContradictionException {
        switch (mode) {
            case ECT: {
                this.sortRTasks(TaskComparators.makeREarliestStartingTimeCmp());
                break;
            }
            case LST: {
                this.sortRTasks(TaskComparators.makeRLatestCompletionTimeCmp());
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown tree mode.");
            }
        }
        block4 : switch (mode) {
            case ECT: {
                int[] ectTUnionOArr = this.calculateECT();
                while (this.altDisjTreeTLTO.getNbOmegaTasks() != 0) {
                    assert (this.altDisjTreeTLTO.getNbOmegaTasks() >= 0);
                    int[] results = this.calculateECTTOL(ectTUnionOArr);
                    assert (results[0] >= 0);
                    if (results[0] <= j.getLCT()) break block4;
                    assert (results[1] != -1);
                    IRTask resprTask = this.rtasks[results[1]];
                    this.setAsRemoval(resprTask, true);
                }
                break;
            }
            case LST: {
                int[] lctTUnionOArr = this.calculateLST();
                while (this.altDisjTreeTLTO.getNbOmegaTasks() != 0) {
                    assert (this.altDisjTreeTLTO.getNbOmegaTasks() >= 0);
                    int[] results = this.calculateLSTTOL(lctTUnionOArr);
                    if (results[0] >= j.getEST()) break block4;
                    assert (results[1] != -1);
                    IRTask resprTask = this.rtasks[results[1]];
                    this.setAsRemoval(resprTask, true);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown tree mode.");
            }
        }
    }

    private int[] calculateLSTTOL(int[] lstTUnionOArr) {
        int[] results = new int[2];
        int lstT = Integer.MAX_VALUE;
        int lstTL = Integer.MAX_VALUE;
        int lstTO = Integer.MAX_VALUE;
        int lstTOL = Integer.MAX_VALUE;
        int pTOL = 0;
        int pTL = 0;
        int pTO = 0;
        int pT = 0;
        int respTOLIdx = -1;
        int respTOIdx = -1;
        int respEnabledIdx = -1;
        for (int j = 0; j < this.size.get(); ++j) {
            int newLSTTOL;
            IRTask rtaskAtj = this.rtasks[j];
            ITask taskAtj = rtaskAtj.getHTask();
            int taskType = this.altDisjTreeTLTO.getTaskType(rtaskAtj);
            if (taskType == 1) {
                assert (rtaskAtj.isRegular());
                lstTOL = Math.min(lstTOL, taskAtj.getLST() - pTOL);
                lstTO = Math.min(lstTO, taskAtj.getLST() - pTO);
                lstTL = Math.min(lstTL, taskAtj.getLST() - pTL);
                lstT = Math.min(lstT, taskAtj.getLST() - pT);
                pT += taskAtj.getMinDuration();
                continue;
            }
            if (taskType == 2) {
                newLSTTOL = lstTOL;
                if (respTOLIdx == -1 || newLSTTOL > taskAtj.getLST() - pT) {
                    newLSTTOL = taskAtj.getLST() - pT;
                    pTOL = pT + taskAtj.getMinDuration();
                    respTOLIdx = j;
                }
                if (newLSTTOL > taskAtj.getLST() - pTL && respEnabledIdx != -1 && this.rtasks[respEnabledIdx].getHTask().getECT() > lstTUnionOArr[j]) {
                    newLSTTOL = taskAtj.getLST() - pTL;
                    pTOL = pTL + taskAtj.getMinDuration();
                    respTOLIdx = j;
                }
                lstTOL = newLSTTOL;
                int newLSTTO = lstTO;
                if (respTOIdx == -1 || newLSTTO > taskAtj.getLST() - pT) {
                    newLSTTO = taskAtj.getLST() - pT;
                    pTO = pT + taskAtj.getMinDuration();
                    respTOIdx = j;
                }
                lstTO = newLSTTO;
                continue;
            }
            if (!rtaskAtj.isRegular()) continue;
            newLSTTOL = lstTOL;
            if (newLSTTOL > taskAtj.getLST() - pTO) {
                if (respTOLIdx == -1) {
                    assert (respTOIdx == -1);
                    newLSTTOL = taskAtj.getLST() - pTO;
                    assert (pTO == pT);
                    pTOL = pTO + taskAtj.getMinDuration();
                } else if (taskAtj.getECT() > lstTUnionOArr[respTOIdx]) {
                    newLSTTOL = taskAtj.getLST() - pTO;
                    pTOL = pTO + taskAtj.getMinDuration();
                    respTOLIdx = respTOIdx;
                }
            }
            lstTOL = newLSTTOL;
            int newLSTTL = lstTL;
            if (newLSTTL > taskAtj.getLST() - pT) {
                newLSTTL = taskAtj.getLST() - pT;
                pTL = pT + taskAtj.getMinDuration();
                respEnabledIdx = j;
            }
            lstTL = newLSTTL;
        }
        assert (lstT == this.altDisjTreeTLTO.getTime());
        results[0] = lstTOL;
        results[1] = respTOLIdx;
        return results;
    }

    private int[] calculateLST() {
        ITask tAtI;
        IRTask taskAtI;
        int i;
        int[] lstAfter = new int[this.size.get()];
        int[] lstBefore = new int[this.size.get()];
        int[] pBefore = new int[this.size.get()];
        int[] lstWith = new int[this.size.get()];
        boolean first = false;
        int last = this.size.get() - 1;
        lstBefore[0] = Integer.MAX_VALUE;
        lstAfter[last] = Integer.MAX_VALUE;
        pBefore[0] = 0;
        for (i = 0; i < this.size.get() - 1; ++i) {
            taskAtI = this.rtasks[i];
            tAtI = taskAtI.getHTask();
            if (this.altDisjTreeTLTO.getTaskType(taskAtI) == 1) {
                lstBefore[i + 1] = Math.min(lstBefore[i], tAtI.getLST() - pBefore[i]);
                pBefore[i + 1] = pBefore[i] + tAtI.getMinDuration();
                continue;
            }
            lstBefore[i + 1] = lstBefore[i];
            pBefore[i + 1] = pBefore[i];
        }
        for (i = this.size.get() - 1; i >= 1; --i) {
            int totalP;
            taskAtI = this.rtasks[i];
            tAtI = taskAtI.getHTask();
            IRTask trBeforeI = this.rtasks[i - 1];
            ITask tBeforeI = trBeforeI.getHTask();
            lstAfter[i - 1] = this.altDisjTreeTLTO.getTaskType(taskAtI) == 1 ? Math.min(tAtI.getLST(), lstAfter[i] - tAtI.getMinDuration()) : lstAfter[i];
            int newLST = lstBefore[i - 1];
            if (newLST > tBeforeI.getLST() - pBefore[i - 1]) {
                newLST = tBeforeI.getLST() - pBefore[i - 1];
            }
            if (newLST > lstAfter[i - 1] - (totalP = pBefore[i - 1] + tBeforeI.getMinDuration())) {
                newLST = lstAfter[i - 1] - totalP;
            }
            lstWith[i - 1] = newLST;
        }
        lstWith[last] = Math.min(lstBefore[last], this.rtasks[last].getHTask().getLST() - pBefore[last]);
        return lstWith;
    }

    private int[] calculateECT() {
        ITask tAtI;
        IRTask taskAtI;
        int i;
        int[] ectAfter = new int[this.size.get()];
        int[] ectBefore = new int[this.size.get()];
        int[] pAfter = new int[this.size.get()];
        int[] ectWith = new int[this.size.get()];
        ectBefore[0] = Integer.MIN_VALUE;
        ectAfter[this.size.get() - 1] = Integer.MIN_VALUE;
        pAfter[this.size.get() - 1] = 0;
        for (i = this.size.get() - 1; i >= 1; --i) {
            taskAtI = this.rtasks[i];
            tAtI = taskAtI.getHTask();
            if (this.altDisjTreeTLTO.getTaskType(taskAtI) == 1) {
                pAfter[i - 1] = pAfter[i] + tAtI.getMinDuration();
                ectAfter[i - 1] = Math.max(ectAfter[i], tAtI.getECT() + pAfter[i]);
                continue;
            }
            pAfter[i - 1] = pAfter[i];
            ectAfter[i - 1] = ectAfter[i];
        }
        for (i = 0; i < this.size.get() - 1; ++i) {
            taskAtI = this.rtasks[i];
            tAtI = taskAtI.getHTask();
            ITask taskAfterI = this.rtasks[i + 1].getHTask();
            ectBefore[i + 1] = this.altDisjTreeTLTO.getTaskType(taskAtI) == 1 ? Math.max(tAtI.getECT(), ectBefore[i] + tAtI.getMinDuration()) : ectBefore[i];
            int newEctWith = ectAfter[i + 1];
            if (newEctWith < taskAfterI.getECT() + pAfter[i + 1]) {
                newEctWith = taskAfterI.getECT() + pAfter[i + 1];
            }
            if (newEctWith < ectBefore[i + 1] + taskAfterI.getMinDuration() + pAfter[i + 1]) {
                newEctWith = ectBefore[i + 1] + taskAfterI.getMinDuration() + pAfter[i + 1];
            }
            ectWith[i + 1] = newEctWith;
        }
        ITask first = this.rtasks[0].getHTask();
        ectWith[0] = Math.max(ectAfter[0], first.getECT() + pAfter[0]);
        return ectWith;
    }

    private void checkSTLOEST(IRTask j) throws ContradictionException {
        this.sortRTasks(TaskComparators.makeREarliestStartingTimeCmp());
        this.altDisjTreeTLTO.removeFromOmega(j);
        this.altDisjTreeTLTO.insertInTheta(j);
        int ectTUO = this.altDisjTreeTLTO.getTime();
        int ectT = Integer.MIN_VALUE;
        int ectTL = Integer.MIN_VALUE;
        for (IRTask rtask : this) {
            ITask i = rtask.getHTask();
            int taskType = this.altDisjTreeTLTO.getTaskType(rtask);
            if (taskType == 1) {
                ectTL = Math.max(ectTL + i.getMinDuration(), i.getECT());
                ectT = Math.max(ectT + i.getMinDuration(), i.getECT());
                continue;
            }
            if (!rtask.isRegular() || i.getLST() >= ectTUO) continue;
            int l = ectT + i.getMinDuration();
            int r = i.getECT();
            ectTL = Math.max(ectTL, Math.max(l, r));
        }
        this.altDisjTreeTLTO.removeFromTheta(j.getHTask());
        this.altDisjTreeTLTO.insertInOmega(j);
        int lct = j.getHTask().getLCT();
        if (ectTUO > lct || ectTL > lct) {
            this.setAsRemoval(j, true);
        }
    }

    private void checkSTLOLCT(IRTask j) throws ContradictionException {
        this.sortRTasks(TaskComparators.makeRLatestCompletionTimeCmp());
        this.altDisjTreeTLTO.removeFromOmega(j);
        this.altDisjTreeTLTO.insertInTheta(j);
        int lstTUO = this.altDisjTreeTLTO.getTime();
        int lstT = Integer.MAX_VALUE;
        int lstTL = Integer.MAX_VALUE;
        int pT = 0;
        int pTL = 0;
        for (int tIdx = 0; tIdx < this.size.get(); ++tIdx) {
            IRTask ir = this.rtasks[tIdx];
            ITask i = ir.getHTask();
            int taskType = this.altDisjTreeTLTO.getTaskType(this.rtasks[tIdx]);
            if (taskType == 1) {
                lstTL = Math.min(lstTL, i.getLST() - pTL);
                lstT = Math.min(lstT, i.getLST() - pT);
                pT += i.getMinDuration();
                continue;
            }
            if (!ir.isRegular() || i.getECT() <= lstTUO || lstTL <= i.getLST() - pT) continue;
            lstTL = i.getLST() - pT;
            pTL = pT + i.getMinDuration();
        }
        this.altDisjTreeTLTO.removeFromTheta(j.getHTask());
        this.altDisjTreeTLTO.insertInOmega(j);
        int est = j.getHTask().getEST();
        if (lstTL < est || lstTUO < est) {
            this.setAsRemoval(j, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkTL(ITask j, IVilimTree.TreeMode mode) throws ContradictionException {
        block20: {
            switch (mode) {
                case ECT: {
                    break;
                }
                case LST: {
                    break block20;
                }
                default: {
                    throw new UnsupportedOperationException("unknown tree mode.");
                }
            }
            while (this.altDisjTreeTLTO.getGrayTime() > j.getLCT()) {
                ITask i;
                block18: {
                    IRTask rti = (IRTask)this.altDisjTreeTLTO.getResponsibleTask();
                    i = rti.getHTask();
                    if (this.altDisjTreeTLTO.getTime() > i.getEST()) {
                        if (this.altDisjTreeTLTO.getTime() > i.getLST()) {
                            if (rti.isRegular()) {
                                rti.fail();
                                break block18;
                            } else {
                                if (!rti.isOptional()) {
                                    throw new SolverException("Eliminated tasks should not exist in a TL tree");
                                }
                                this.setAsRemoval(rti, false);
                                continue;
                            }
                        }
                        assert (!rti.isEliminated());
                        this.updateManager.storeUpdate(rti, this.altDisjTreeTLTO.getTime());
                    }
                }
                this.altDisjTreeTLTO.removeFromLambda(i);
            }
            return;
        }
        while (this.altDisjTreeTLTO.getGrayTime() < j.getEST()) {
            ITask i;
            block19: {
                IRTask rti = (IRTask)this.altDisjTreeTLTO.getResponsibleTask();
                i = rti.getHTask();
                if (this.altDisjTreeTLTO.getTime() < i.getLCT()) {
                    if (this.altDisjTreeTLTO.getTime() < i.getECT()) {
                        if (rti.isRegular()) {
                            rti.fail();
                            break block19;
                        } else {
                            if (!rti.isOptional()) {
                                throw new SolverException("Eliminated tasks should not exist in a TL tree");
                            }
                            this.setAsRemoval(rti, false);
                            continue;
                        }
                    }
                    assert (!rti.isEliminated());
                    this.updateManager.storeUpdate(rti, this.altDisjTreeTLTO.getTime());
                }
            }
            this.altDisjTreeTLTO.removeFromLambda(i);
        }
    }

    private void checkTO(ITask j, IVilimTree.TreeMode mode) throws ContradictionException {
        switch (mode) {
            case ECT: {
                while (this.altDisjTreeTLTO.getTOTime() > j.getLCT()) {
                    IRTask rti = (IRTask)this.altDisjTreeTLTO.getResponsibleTOTask();
                    assert (rti != null);
                    this.setAsRemoval(rti, true);
                }
                break;
            }
            case LST: {
                while (this.altDisjTreeTLTO.getTOTime() < j.getEST()) {
                    IRTask rti = (IRTask)this.altDisjTreeTLTO.getResponsibleTOTask();
                    assert (rti != null);
                    this.setAsRemoval(rti, true);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown tree mode.");
            }
        }
    }

    private void setupEF(IVilimTree.TreeMode mode, Comparator<IRTask> queueComp) {
        this.altDisjTreeTLTO.initializeEdgeFinding(mode, this);
        this.rqueue.reset();
        this.rqueue.sort(queueComp);
    }

    @Override
    public boolean edgeFindingLCT() throws ContradictionException {
        this.setupEF(IVilimTree.TreeMode.LST, TaskComparators.makeREarliestStartingTimeCmp());
        IRTask rtj = this.rqueue.peek();
        ITask j = rtj.getHTask();
        if (rtj.isRegular() && this.altDisjTreeTLTO.getTime() < j.getEST()) {
            rtj.fail();
        }
        do {
            if (rtj.isOptional()) {
                this.altDisjTreeTLTO.removeFromOmegaAndInsertInLambda(rtj);
            } else if (rtj.isRegular()) {
                this.altDisjTreeTLTO.removeFromThetaAndInsertInLambda(rtj);
            }
            this.rqueue.poll();
            if (this.rqueue.isEmpty()) break;
            rtj = this.rqueue.peek();
            j = rtj.getHTask();
            if (rtj.isRegular()) {
                if (this.altDisjTreeTLTO.getTime() < j.getEST()) {
                    rtj.fail();
                }
                this.checkTL(j, IVilimTree.TreeMode.LST);
                this.checkTO(j, IVilimTree.TreeMode.LST);
                this.checkFTLO(j, IVilimTree.TreeMode.LST);
                continue;
            }
            if (!rtj.isOptional()) continue;
            this.checkSTLOLCT(rtj);
        } while (!this.rqueue.isEmpty());
        return this.updateManager.fireAndUpdateLCT();
    }

    @Override
    public Iterator<IRTask> iterator() {
        return new Itr();
    }

    final class AltBipartiteQueue<E>
    implements IBipartiteQueue<E> {
        public final E[] elementData;
        private int level;

        public AltBipartiteQueue(E[] elementData) {
            this.elementData = Arrays.copyOf(elementData, elementData.length);
            this.reset();
        }

        @Override
        public void reset() {
            this.level = 0;
        }

        @Override
        public boolean isEmpty() {
            return this.level == AltDisjRules.this.size.get();
        }

        @Override
        public E poll() {
            return this.elementData[this.level++];
        }

        @Override
        public E peek() {
            return this.elementData[this.level];
        }

        @Override
        public void sort(Comparator<? super E> cmp) {
            Arrays.sort(this.elementData, this.level, AltDisjRules.this.size.get(), cmp);
        }
    }

    final class Itr
    implements Iterator<IRTask> {
        private int level = 0;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.level < AltDisjRules.this.size.get();
        }

        @Override
        public IRTask next() {
            return AltDisjRules.this.rtasks[this.level++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not available");
        }
    }
}

