/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.DesktopPaneBG;
import org.af.commons.widgets.buttons.HorizontalButtonPane;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.PowerOptionsPanel;
import org.af.gMCP.gui.power.CVPanel;
import org.af.gMCP.gui.power.PDialog;
import org.af.gMCP.gui.power.PowerReqPanel;
import org.af.gMCP.gui.power.PowerResultDialog;
import org.af.gMCP.gui.power.RandomizationPanel;
import org.af.gMCP.gui.power.SampSizeResultTableModel;
import org.af.gMCP.gui.power.ScenarioPanel2;
import org.af.gMCP.gui.power.SettingsToXML;
import org.af.jhlir.call.RDataFrame;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleSizeDialog
extends PDialog
implements ActionListener {
    RandomizationPanel randomizationPanel = new RandomizationPanel(this);
    PowerReqPanel prPanel;
    JButton jbHelp;

    public SampleSizeDialog(CreateGraphGUI parent) {
        super(parent, "Sample Size Calculations", true);
        this.tPanel.addTab("Randomization", this.randomizationPanel);
        this.pNCP = new ScenarioPanel2(this);
        this.tPanel.addTab("Effect Size", (Component)((Object)this.pNCP));
        this.prPanel = new PowerReqPanel(this);
        this.tPanel.addTab("Power Requirements", this.prPanel);
        this.cvPanel = new CVPanel(this);
        this.tPanel.addTab("Correlation Matrix", this.cvPanel);
        this.oPanel = new PowerOptionsPanel(parent);
        this.tPanel.addTab("Options", this.oPanel);
        Set<String> variables = parent.getGraphView().getNL().getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        this.getContentPane().add((Component)this.tPanel, this.c);
        this.c.weighty = 0.0;
        ++this.c.gridy;
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.anchor = 13;
        try {
            this.jbHelp = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/questionmark32.png"))));
        }
        catch (IOException e) {
            ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e);
            this.jbHelp = new JButton("Help!");
        }
        this.jbHelp.addActionListener(this);
        HorizontalButtonPane bp = new HorizontalButtonPane(new String[]{"Help", "Ok", "Cancel"}, new String[]{"help", "OK", "CANCEL"});
        this.getContentPane().add((Component)bp, this.c);
        bp.addActionListener((ActionListener)this);
        this.config = new File(this.path, "gMCP-samplesize-settings.xml");
        if (this.config.exists()) {
            SettingsToXML.loadConfigFromXML(this.config, this);
        }
        this.prPanel.setActionListener();
        this.pack();
        Dimension d = this.getSize();
        this.setSize(d.width, d.height + 100);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    @Override
    public void loadConfig(Element root) {
        super.loadConfig(root);
        this.randomizationPanel.loadConfig((Element)root.getElementsByTagName("randomization").item(0));
        this.prPanel.loadConfig((Element)root.getElementsByTagName("powerreq").item(0));
    }

    @Override
    public List<Element> getConfigurationNodes(Document document) {
        List<Element> v = super.getConfigurationNodes(document);
        v.add(this.randomizationPanel.getConfigNode(document));
        v.add(this.prPanel.getConfigNode(document));
        return v;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double alpha;
        String weights = this.parent.getGraphView().getNL().getGraphName() + "@weights";
        try {
            alpha = this.parent.getPView().getTotalAlpha();
        }
        catch (Exception e1) {
            return;
        }
        String graph = this.parent.getGraphView().getNL().getGraphName();
        if (e.getActionCommand().equals("OK")) {
            SettingsToXML.saveSettingsToXML(this.config, this);
            try {
                this.rCommand = "sampSize(graph=" + graph + ", effSize=" + this.pNCP.getEffSizeString() + ", esf=" + this.randomizationPanel.getESF() + ", powerReqFunc=" + this.prPanel.getPowerFunctions() + ", target=" + this.prPanel.getPowerTargets() + ", corr.sim = " + this.cvPanel.getSigma() + ", alpha=" + alpha + this.cvPanel.getMatrixForParametricTest() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ", upscale = " + (Configuration.getInstance().getGeneralConfig().getUpscale() ? "TRUE" : "FALSE") + ", n.sim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ")";
            }
            catch (ValidationException e1) {
                JOptionPane.showMessageDialog(this, "An error was detected in the input:\n" + e1.getMessage(), "Error detected in input", 0);
                return;
            }
            System.out.println("The following R will be executed:\n\n" + this.rCommand);
            this.parent.glassPane.start();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground() throws Exception {
                    try {
                        RControl.setSeed();
                        RDataFrame result = RControl.getR().eval(SampleSizeDialog.this.rCommand).asRDataFrame();
                        String[] colnames = new String[]{"Scenario", "PowerFunc", "target", "sampSize"};
                        new PowerResultDialog(SampleSizeDialog.this.parent, "SampleSize Results", result, colnames, SampleSizeDialog.this.rCommand, SampSizeResultTableModel.class);
                    }
                    catch (Exception e) {
                        ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e, false);
                    }
                    finally {
                        SampleSizeDialog.this.parent.glassPane.stop();
                    }
                    return null;
                }
            };
            worker.execute();
        }
        if (e.getActionCommand().equals("help")) {
            if (this.tPanel.getSelectedComponent() == this.randomizationPanel) {
                this.parent.openHelp("randomization");
            } else if (this.tPanel.getSelectedComponent() == this.pNCP) {
                this.parent.openHelp("ses");
            } else if (this.tPanel.getSelectedComponent() == this.prPanel) {
                this.parent.openHelp("powerreq");
            } else if (this.tPanel.getSelectedComponent() == this.cvPanel) {
                this.parent.openHelp("cormat2");
            } else if (this.tPanel.getSelectedComponent() == this.oPanel) {
                this.parent.openHelp("options");
            } else {
                this.parent.openHelp("power");
            }
        } else {
            this.dispose();
        }
    }
}

