*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 34574
*       MONITORING THE FUTURE: A CONTINUING STUDY OF AMERICAN YOUTH
*                   (8TH- AND 10TH-GRADE SURVEYS), 2012
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\34574-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  VARIABLE LEVEL: assigns measurement level to each variable (scale,
*  nominal, or ordinal).
*
*  NOTE:  Users should modify this setup file to suit their specific
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da34574-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=1121.
DATA LIST FILE=DATA /
              CASEID 1-5                  V1 6-9                   V3 10
                V4 11-15           V5 16-30 (13)              V501 31-32
                 V507 33                 V508 34                 V509 35
             V7101 36-37             V7104 38-39             V7105 40-41
             V7112 42-43             V7115 44-45             V7118 46-47
             V7127 48-49             V7097 50-51             V7133 52-53
             V7139 54-55             V7142 56-57             V8451 58-59
             V7426 60-61             V7121 62-63             V7124 64-65
             V7164 66-67             V7145 68-69             V7109 70-71
             V7152 72-73             V7155 74-75             V7158 76-77
             V7161 78-79             V7601 80-81             V8480 82-83
             V7106 84-85             V7113 86-87             V7116 88-89
             V7119 90-91             V7128 92-93             V7098 94-95
             V7134 96-97             V7140 98-99           V7143 100-101
           V8452 102-103           V7122 104-105           V7125 106-107
           V7165 108-109           V7146 110-111           V7110 112-113
           V7153 114-115           V7156 116-117           V7159 118-119
           V7162 120-121           V7602 122-123           V7487 124-125
           V7488 126-127           V7489 128-129           V7491 130-131
           V7492 132-133           V8481 134-135           V7495 136-137
           V7554 138-139           V7561 140-141           V7564 142-143
           V7566 144-145           V7568 146-147           V7569 148-149
           V7567 150-151           V7102 152-153           V7107 154-155
           V7114 156-157           V7117 158-159           V7120 160-161
           V7129 162-163           V7099 164-165           V7135 166-167
           V7141 168-169           V7144 170-171           V8453 172-173
           V7427 174-175           V7123 176-177           V7126 178-179
           V7166 180-181           V7147 182-183           V7111 184-185
           V7154 186-187           V7157 188-189           V7160 190-191
           V7163 192-193           V7603 194-195           V8482 196-197
           V7108 198-199           V8454 200-201           V7442 202-203
           V7441 204-205           V8413 206-207           V7443 208-209
           V7444 210-211           V7445 212-213           V8417 214-215
           V8418 216-217           V8419 218-219           V8483 220-221
           V8421 222-223           V7446 224-225           V7447 226-227
           V8424 228-229           V8425 230-231           V7448 232-233
           V7449 234-235           V8564 236-237           V7548 238-239
           V7103 240-241           V7180 242-243           V7181 244-245
           V7475 246-247           V7476 248-249           V7477 250-251
           V7478 252-253           V7479 254-255           V7480 256-257
           V7547 258-259           V7549 260-261           V7550 262-263
           V7176 264-265           V7587 266-267           V7557 268-269
           V7558 270-271           V7559 272-273           V7560 274-275
           V7428 276-277           V7432 278-279           V7433 280-281
           V7435 282-283           V7430 284-285           V7431 286-287
           V7434 288-289           V7429 290-291           V7436 292-293
           V8473 294-295           V8474 296-297           V8475 298-299
           V7437 300-301           V7438 302-303           V7439 304-305
           V7440 306-307           V7414 308-309           V7415 310-311
           V7416 312-313           V7417 314-315           V7494 316-317
           V7419 318-319           V7420 320-321           V7421 322-323
           V7422 324-325           V7423 326-327           V7412 328-329
           V7413 330-331           V7490 332-333           V7425 334-335
           V7424 336-337           V8544 338-339           V8477 340-341
           V7167 342-343           V7168 344-345           V7169 346-347
           V7170 348-349           V7171 350-351           V7172 352-353
           V7173 354-355           V7174 356-357           V7175 358-359
           V7177 360-361           V7178 362-363           V7179 364-365
           V7199 366-367           V7200 368-369           V7185 370-371
           V7458 372-373           V7186 374-375           V7187 376-377
           V7188 378-379           V7184 380-381           V7451 382-383
           V7452 384-385           V7453 386-387           V7454 388-389
           V7455 390-391           V7456 392-393           V7457 394-395
           V8441 396-397           V8442 398-399           V8443 400-401
           V8444 402-403           V8445 404-405           V8446 406-407
           V8447 408-409           V8476 410-411           V8540 412-413
           V8541 414-415           V8542 416-417           V7481 418-419
           V7183 420-421           V7459 422-423           V7460 424-425
           V7461 426-427           V7462 428-429           V7463 430-431
           V7464 432-433           V7465 434-435           V7466 436-437
           V7467 438-439           V7468 440-441           V7469 442-443
           V7470 444-445           V7471 446-447           V7472 448-449
           V7473 450-451           V7474 452-453           V7182 454-455
           V7403 456-457           V7404 458-459           V8455 460-461
           V7405 462-463           V7406 464-465           V7407 466-467
           V7408 468-469           V7409 470-471           V7410 472-473
           V7411 474-475           V7482 476-477           V8401 478-479
           V8402 480-481           V8403 482-483           V8404 484-485
           V7701 486-487           V7702 488-489           V7703 490-491
           V7704 492-493           V7705 494-495           V7714 496-497
           V7715 498-499           V8478 500-501           V7570 502-503
           V7344 504-505           V7345 506-507           V7346 508-509
           V7347 510-511           V7348 512-513           V7349 514-515
           V7350 516-517           V7351 518-519           V7352 520-521
           V7353 522-523           V7354 524-525           V7355 526-527
           V7356 528-529           V7357 530-531           V8547 532-533
           V8548 534-535           V7540 536-537           V7541 538-539
           V8562 540-541           V8563 542-543           V8456 544-545
           V8457 546-547           V8458 548-549           V8459 550-551
           V8460 552-553           V8461 554-555           V8462 556-557
           V7718 558-559           V7716 560-561           V7717 562-563
           V7719 564-565           V7720 566-567           V7721 568-569
           V7359 570-571           V7360 572-573           V7361 574-575
           V7362 576-577           V7363 578-579           V8545 580-581
           V8546 582-583           V7364 584-585           V7365 586-587
           V7366 588-589           V7367 590-591           V7368 592-593
           V7369 594-595           V7370 596-597           V8560 598-599
           V8561 600-601           V7371 602-603           V7372 604-605
           V7542 606-607           V7543 608-609           V7377 610-611
           V7577 612-613           V7578 614-615           V7571 616-617
           V7572 618-619           V7573 620-621           V7574 622-623
           V7575 624-625           V7576 626-627           V7579 628-629
           V7580 630-631           V7581 632-633           V7582 634-635
           V7583 636-637           V7584 638-639           V7585 640-641
           V7586 642-643           V7710 644-645           V7711 646-647
           V7712 648-649           V7713 650-651           V7706 652-653
           V7707 654-655           V7708 656-657           V7709 658-659
           V7189 660-661           V7190 662-663           V7191 664-665
           V7192 666-667           V7193 668-669           V7194 670-671
           V7195 672-673           V7196 674-675           V7197 676-677
           V7198 678-679           V7222 680-681           V7221 682-683
           V7223 684-685           V7327 686-687           V7516 688-689
           V7517 690-691           V7518 692-693           V7519 694-695
           V7329 696-697           V7330 698-699           V7331 700-701
           V7332 702-703           V7334 704-705           V7335 706-707
           V7232 708-709           V7233 710-711           V7301 712-713
           V7333 714-715           V7251 716-717           V7252 718-719
           V7384 720-721           V7385 722-723           V7386 724-725
           V7496 726-727           V7497 728-729           V7387 730-731
           V7498 732-733           V7388 734-735           V7389 736-737
           V7499 738-739           V7390 740-741           V7391 742-743
           V7392 744-745           V7393 746-747           V7394 748-749
           V7395 750-751           V7396 752-753           V7397 754-755
           V7500 756-757           V7398 758-759           V7399 760-761
           V7400 762-763           V7556 764-765           V7522 766-767
           V7523 768-769           V7524 770-771           V7525 772-773
           V7526 774-775           V7527 776-777           V7528 778-779
           V7529 780-781           V7530 782-783           V7531 784-785
           V8537 786-787           V8538 788-789           V7537 790-791
           V7253 792-793           V7228 794-795           V7229 796-797
           V7230 798-799           V7231 800-801           V8539 802-803
           V8516 804-805           V8522 806-807           V7509 808-809
           V7510 810-811           V7511 812-813           V7512 814-815
           V7513 816-817           V7514 818-819           V7515 820-821
           V7234 822-823           V8543 824-825           V7534 826-827
           V7535 828-829           V7536 830-831           V7538 832-833
           V7224 834-835           V7225 836-837           V7227 838-839
           V7226 840-841           V7235 842-843           V7238 844-845
           V7236 846-847           V7237 848-849           V7374 850-851
           V7240 852-853           V7309 854-855           V7310 856-857
           V7311 858-859           V7312 860-861           V7313 862-863
           V7378 864-865           V7379 866-867           V7380 868-869
           V7319 870-871           V7325 872-873           V7317 874-875
           V7318 876-877           V7320 878-879           V7321 880-881
           V7322 882-883           V7323 884-885           V7381 886-887
           V7324 888-889           V7326 890-891           V7214 892-893
           V7239 894-895           V7539 896-897           V7552 898-899
           V7544 900-901           V7545 902-903           V7546 904-905
           V7551 906-907           V7553 908-909           V7562 910-911
           V7563 912-913           V7341 914-915           V7343 916-917
           V7532 918-919           V7533 920-921           V7339 922-923
           V7340 924-925           V7401 926-927           V7402 928-929
           V7219 930-931           V7220 932-933           V7255 934-935
           V7241 936-937           V7242 938-939           V7243 940-941
           V7244 942-943           V7258 944-945           V7375 946-947
           V7254 948-949           V7259 950-951           V7260 952-953
           V7261 954-955           V7262 956-957           V7565 958-959
           V7302 960-961           V8512 962-963           V8502 964-965
           V8505 966-967           V8509 968-969           V8514 970-971
           V8536 972-973           V8501 974-975           V8504 976-977
           V8508 978-979           V8503 980-981           V8507 982-983
           V8511 984-985           V8513 986-987           V7501 988-989
           V7502 990-991           V7504 992-993           V7505 994-995
           V7507 996-997           V7508 998-999         V7503 1000-1001
         V7506 1002-1003         V8555 1004-1005         V8556 1006-1007
         V8557 1008-1009         V8558 1010-1011         V8565 1012-1013
         V8566 1014-1015         V1252 1016-1017         V7202 1018-1019
         V1070 1020-1021         V7215 1022-1023         V7216 1024-1025
         V7217 1026-1027         V7206 1028-1029         V7207 1030-1031
         V7208 1032-1033         V7205 1034-1035         V8517 1036-1037
         V8518 1038-1039         V8519 1040-1041         V8520 1042-1043
         V8521 1044-1045         V8523 1046-1047         V8515 1048-1049
         V8526 1050-1051         V8527 1052-1053         V8528 1054-1055
         V8529 1056-1057         V8530 1058-1059         V8531 1060-1061
         V7555 1062-1063        V7101D 1064-1065        V7102D 1066-1067
        V7105D 1068-1069        V7106D 1070-1071        V7107D 1072-1073
        V7112D 1074-1075        V7113D 1076-1077        V7114D 1078-1079
        V7115D 1080-1081        V7116D 1082-1083        V7117D 1084-1085
        V7118D 1086-1087        V7119D 1088-1089        V7120D 1090-1091
        V7127D 1092-1093        V7128D 1094-1095        V7129D 1096-1097
        V7097D 1098-1099        V7098D 1100-1101        V7099D 1102-1103
        V7133D 1104-1105        V7134D 1106-1107        V7135D 1108-1109
        V7142D 1110-1111        V7143D 1112-1113        V7144D 1114-1115
        V7139D 1116-1117        V7140D 1118-1119        V7141D 1120-1121
   .

* SPSS VARIABLE LABELS COMMAND

VARIABLE LABELS
   CASEID    'CASE IDENTIFICATION NUMBER' /
   V1        '2012 YEAR OF ADMINISTRATION' /
   V3        '2012 FORM ID' /
   V4        '2012 R''S ID - SERIAL #' /
   V5        '2012 SAMPLING WEIGHT' /
   V501      '2012 GRADE' /
   V507      '2012 SCHOOL REGION' /
   V508      '2012 LARGE MSA=1/NOT=0' /
   V509      '2012 MSA=1/NON-MSA=0' /
   V7101     '2012 A01a EVR SMK CIG,REGL F1234' /
   V7104     '2012 A01a EVER DRINK       F1234' /
   V7105     '2012 A01a #X DRNK/LIFETIME F1234' /
   V7112     '2012 A01a #XMJ+HS/LIFETIME F1234' /
   V7115     '2012 A01a #X LSD/LIFETIME  F1234' /
   V7118     '2012 A01a #X PSYD/LIFETIME F1234' /
   V7127     '2012 A01a #X AMPH/LIFETIME F1234' /
   V7097     '2012 A01a #X SED/BARB/LIFE F1234' /
   V7133     '2012 A01a #X TRQL/LIFETIME F1234' /
   V7139     '2012 A01a #X NARC/LIFETIME F234' /
   V7142     '2012 A01a #X INHL/LIFETIME F1234' /
   V8451     '2012 A01a #X BEER/LIFETIME F2' /
   V7426     '2012 A01a #X SMKLESS/EVER  F13' /
   V7121     '2012 A01a #X CRACK/LIFETIM F1234' /
   V7124     '2012 A01a #XOTH COKE/LIFE  F1234' /
   V7164     '2012 A01a #X MDMA/LIFETIM  F23' /
   V7145     '2012 A01a #X STRD/LIFETIME F1234' /
   V7109     '2012 A01a #XDRUNK/LIFETIME F1234' /
   V7152     '2012 A01a #X H LIF USE NDL F1234' /
   V7155     '2012 A01a #X H LIF W/O NDL F1234' /
   V7158     '2012 A01a #X INJECTOTH/LIF F1234' /
   V7161     '2012 A01a #X ROHYPNOL/LIF  F4' /
   V7601     '2012 A01a #X METHAMPH/LIFE F1' /
   V8480     '2012 A01a #X FLVRDALC/LIFE F2' /
   V7106     '2012 A01b #X DRNK/LAST12MO F1234' /
   V7113     '2012 A01b #XMJ+HS/LAST12MO F1234' /
   V7116     '2012 A01b #X LSD/LAST 12MO F1234' /
   V7119     '2012 A01b #X PSYD/LAST12MO F1234' /
   V7128     '2012 A01b #X AMPH/LAST12MO F1234' /
   V7098     '2012 A01b #X SED/BARB/12MO F1234' /
   V7134     '2012 A01b #X TRQL/LAST12MO F1234' /
   V7140     '2012 A01b #X NARC/LAST12MO F234' /
   V7143     '2012 A01b #X INHL/LAST12MO F1234' /
   V8452     '2012 A01b #X BEER/LAST12MO F2' /
   V7122     '2012 A01b #X CRACK/LAST12M F1234' /
   V7125     '2012 A01b #XOTH COKE/12MO  F1234' /
   V7165     '2012 A01b #X MDMA/LAST12M  F23' /
   V7146     '2012 A01b #X STRD/LAST12MO F1234' /
   V7110     '2012 A01b #XDRUNK/LAST12MO F1234' /
   V7153     '2012 A01b #X H 12M USE NDL F1234' /
   V7156     '2012 A01b #X H 12M W/O NDL F1234' /
   V7159     '2012 A01b #X INJECTOTH/12M F1234' /
   V7162     '2012 A01b #X ROHYPNOL/12M  F4' /
   V7602     '2012 A01b #X METHAMPH/12MO F1' /
   V7487     '2012 A01b #X ANDRO/12MO    F1' /
   V7488     '2012 A01b #X CREATINE/12MO F1' /
   V7489     '2012 A01b #X RITALIN/12MO  F1' /
   V7491     '2012 A01b #X OXYCONTN/12MO F1' /
   V7492     '2012 A01b #X VICODIN/12MO  F1' /
   V8481     '2012 A01b #X FLVRDALC/12MO F2' /
   V7495     '2012 A01b #X COUGHMED/12MO F1' /
   V7554     '2012 A01b #X ADDERALL/12MO F1' /
   V7561     '2012 A01b #X SALVIA/12MO   F1' /
   V7564     '2012 A01b #X ALCL+CAFFN/12MO F1!' /
   V7566     '2012 A01b #X SYNTH MJ/12MO F1' /
   V7568     '2012 A01b #X DISLV TOB/12M0 F1' /
   V7569     '2012 A01b #X SNUS/12MO     F1' /
   V7567     '2012 A01b #X SYNTH STIM/12MO F1' /
   V7102     '2012 A01c #CIGS SMKD/30DAY F1234' /
   V7107     '2012 A01c #X DRNK/LAST30DA F1234' /
   V7114     '2012 A01c #XMJ+HS/LAST30DA F1234' /
   V7117     '2012 A01c #X LSD/LAST 30DA F1234' /
   V7120     '2012 A01c #X PSYD/LAST30DA F1234' /
   V7129     '2012 A01c #X AMPH/LAST30DA F1234' /
   V7099     '2012 A01c #X SED/BARB/30DA F1234' /
   V7135     '2012 A01c #X TRQL/LAST30DA F1234' /
   V7141     '2012 A01c #X NARC/LAST30DA F234' /
   V7144     '2012 A01c #X INHL/LAST30DA F1234' /
   V8453     '2012 A01c #X BEER/LAST30DA F2' /
   V7427     '2012 A01c #X SMKLESS/30DAY F13' /
   V7123     '2012 A01c #X CRACK/LAST30D F1234' /
   V7126     '2012 A01c #XOTH COKE/30DA  F1234' /
   V7166     '2012 A01c #X MDMA/LAST30D  F23' /
   V7147     '2012 A01c #X STRD/LAST30DA F1234' /
   V7111     '2012 A01c #XDRUNK/LAST30DA F1234' /
   V7154     '2012 A01c #X H 30D USE NDL F1234' /
   V7157     '2012 A01c #X H 30D W/O NDL F1234' /
   V7160     '2012 A01c #X INJECTOTH/30D F1234' /
   V7163     '2012 A01c #X ROHYPNOL/30D  F4' /
   V7603     '2012 A01c #X METHAMPH/30DA F1' /
   V8482     '2012 A01c #X FLVRDALC/30DA F2' /
   V7108     '2012 A01d 5+DRK ROW/LST 2W F1234' /
   V8454     '2012 A01d 5+BR/LST2WK,10+X F2' /
   V7442     '2012 A01g GR 1ST SMOK DLY  F1234' /
   V7441     '2012 A01g GR 1ST SMOK EVR  F1234' /
   V8413     '2012 A01g GR 1ST SMOKELESS F24' /
   V7443     '2012 A01g GR 1ST TRY ALC   F1234' /
   V7444     '2012 A01g GR 1ST DRUNK     F1234' /
   V7445     '2012 A01g GR 1ST TRY MJ    F1234' /
   V8417     '2012 A01g GR 1ST TRY LSD   F24' /
   V8418     '2012 A01g GR 1ST TRY PSY   F24' /
   V8419     '2012 A01g GR 1ST TRY AMP   F24' /
   V8483     '2012 A01g GR 1ST TRY SED/B F4' /
   V8421     '2012 A01g GR 1ST TRY TRN   F24' /
   V7446     '2012 A01g GR 1ST TRY CRACK F1234' /
   V7447     '2012 A01g GR 1STTRY POWCOK F1234' /
   V8424     '2012 A01g GR 1ST TRY HER   F24' /
   V8425     '2012 A01g GR 1ST TRY NRC   F24' /
   V7448     '2012 A01g GR 1ST TRY INHAL F1234' /
   V7449     '2012 A01g GR 1ST TRY STRDS F1234' /
   V8564     '2012 A01g GR 1ST TRY MDMA  F2' /
   V7548     '2012 A01g AGE 1ST AD STIM  F1' /
   V7103     '2012 A01i *TRY STP SMK&FL  F1234' /
   V7180     '2012 A01i #X TRY STOP SMK  F34' /
   V7181     '2012 A01i *WNT STP SMK NW  F34' /
   V7475     '2012 A01i DIF TRY QUIT CIG F13' /
   V7476     '2012 A01i DIF TRY QUIT ALC F13' /
   V7477     '2012 A01i DIF TRY QUIT MJ  F13' /
   V7478     '2012 A01i DIF TRY QUIT COK F13' /
   V7479     '2012 A01i DIF TRY QUIT H F13' /
   V7480     '2012 A01i DIF TRY QUIT OTD F13' /
   V7547     '2012 A01j EVER AD STIM DR  F1' /
   V7549     '2012 A01j # YRS TK AD STIM F1' /
   V7550     '2012 A01j EVER AD NONSTIM  F1' /
   V7176     '2012 A01l USUAL CIG BRAND  F134' /
   V7587     '2012 A01l SMOKE MENTHOL CIG F34' /
   V7557     '2012 A01o # ENERGY DRINKS/DAY F1' /
   V7558     '2012 A01o # ENERGY SHOTS/DAY F1' /
   V7559     '2012 A01o # REG SOFT DRINKS/DA F1' /
   V7560     '2012 A01o # DIET SOFT DRINKS/D F1' /
   V7428     '2012 A02a ALL FRD SMK CIGS F234' /
   V7432     '2012 A02a ALL FRD SMK MARJ F234' /
   V7433     '2012 A02a # FRNDS TK CRACK F234' /
   V7435     '2012 A02a ALL FRD TK HERON F234' /
   V7430     '2012 A02a ALL FRD DRK ALCL F234' /
   V7431     '2012 A02a ALL FRD GT DRUNK F234' /
   V7434     '2012 A02a # FRNDS TK C PWD F234' /
   V7429     '2012 A02a ALL FRD SMKLESS  F234' /
   V7436     '2012 A02a ALL FRND INHALNT F234' /
   V8473     '2012 A02a STDNTS SMK +1CIG F2' /
   V8474     '2012 A02a STDNTS DRNK/MO   F2' /
   V8475     '2012 A02a STDNTS USE MJ/MO F2' /
   V7437     '2012 A02b PRESR TO SMK CIG F34' /
   V7438     '2012 A02b PRESR TO DRK ALC F34' /
   V7439     '2012 A02b PRESR TO USE MJ  F34' /
   V7440     '2012 A02b PRSR TO OTH DRUG F34' /
   V7414     '2012 A03a EASY GT MARIJUAN F1234' /
   V7415     '2012 A03a EASY GT LSD      F1234' /
   V7416     '2012 A03a EASY GT PCP      F13' /
   V7417     '2012 A03a EASY GT AMPHTMNS F1234' /
   V7494     '2012 A03a EASY GT SED/BARB F1234' /
   V7419     '2012 A03a EASY GT TRANQLIZ F1234' /
   V7420     '2012 A03a EASY GT CRACK    F1234' /
   V7421     '2012 A03a EASY GT COK PWDR F1234' /
   V7422     '2012 A03a EASY GT HEROIN   F1234' /
   V7423     '2012 A03a EASY GT NARCOTIC F13' /
   V7412     '2012 A03a EASY GT CIGS     F1234' /
   V7413     '2012 A03a EASY GT ALCOHOL  F1234' /
   V7490     '2012 A03a EASY GT MDMA     F13' /
   V7425     '2012 A03a EASY GT STEROIDS F1234' /
   V7424     '2012 A03a EASY GT ICE      F13' /
   V8544     '2012 A03a ILL DRG SOLD@SCH F24' /
   V8477     '2012 A03a DRG SL NBHD/12MO F2' /
   V7167     '2012 A03b CIG HOW BUY-FRND F34' /
   V7168     '2012 A03b CIG HOW BUY-VEND F34' /
   V7169     '2012 A03b CIG HOW BUY-MAIL F34' /
   V7170     '2012 A03b CIG HOW BUY-PKUP F34' /
   V7171     '2012 A03b CIG HOW BUY-CLRK F34' /
   V7172     '2012 A03b CIG WHERE-SUPMKT F34' /
   V7173     '2012 A03b CIG WHERE-SMLGRC F34' /
   V7174     '2012 A03b CIG WHERE-DRGSTR F34' /
   V7175     '2012 A03b CIG WHERE-CNVGAS F34' /
   V7177     '2012 A03b CIG PROOF OF AGE F34' /
   V7178     '2012 A03b CIG SHOW ID/SELL F34' /
   V7179     '2012 A03b CIG STORE BUY<20 F34' /
   V7199     '2012 A03b CIG HOW BUY-OTHR F34' /
   V7200     '2012 A03b CIG WHERE-WEB    F34' /
   V7185     '2012 A04a NO SMK IN 5 YR   F34' /
   V7458     '2012 A04a NXT 12MOS USE MJ F1' /
   V7186     '2012 A04a NEVER CIG ADDICT F34' /
   V7187     '2012 A04a QUIT CIG WN WANT F34' /
   V7188     '2012 A04a SMK -DANGER QUIT F34' /
   V7184     '2012 A04b START SMK THISYR F34' /
   V7451     '2012 A05c #X USE DRUG HOME F1' /
   V7452     '2012 A05c #X USE DRG FRNDS F1' /
   V7453     '2012 A05c #X US DRG SCHEVE F1' /
   V7454     '2012 A05c #X USE DRG ATSCH F1' /
   V7455     '2012 A05c #X USE DRG NRSCH F1' /
   V7456     '2012 A05c #X USE DRG INCAR F1' /
   V7457     '2012 A05c #X USE DRG PARTY F1' /
   V8441     '2012 A05c #X USE ALC HOME  F2' /
   V8442     '2012 A05c #X USE ALC FRNDS F2' /
   V8443     '2012 A05c #X USEALC SCHEVE F2' /
   V8444     '2012 A05c #X USE ALC ATSCH F2' /
   V8445     '2012 A05c #X USE ALC NRSCH F2' /
   V8446     '2012 A05c #X USE ALC INCAR F2' /
   V8447     '2012 A05c #X USE ALC PARTY F2' /
   V8476     '2012 A05c #X USE ALC@PARK  F2' /
   V8540     '2012 A05c 4WKS ALC@SCHOOL  F2' /
   V8541     '2012 A05c 4WKS MJ/OTD@SCHL F2' /
   V8542     '2012 A05c 4WKS TOBACCO@SCH F2' /
   V7481     '2012 A05c #X USE DRG@PARK  F1' /
   V7183     '2012 A06a START SMK LOSEWT F34' /
   V7459     '2012 A06b MJ CRN PSYC DAMG F1' /
   V7460     '2012 A06b MJ CRN PHYS DAMG F1' /
   V7461     '2012 A06b MJ CRN GT ARREST F1' /
   V7462     '2012 A06b MJ CRN ADDICTED  F1' /
   V7463     '2012 A06b MJ AGNST BELIEFS F1' /
   V7464     '2012 A06b MJ CRN < ENGYAMB F1' /
   V7465     '2012 A06b MJ CRN < CONTROL F1' /
   V7466     '2012 A06b MJ->STRNGR DRUGS F1' /
   V7467     '2012 A06b MJ NOT ENJOYABLE F1' /
   V7468     '2012 A06b MJ PRNTS DISAPP  F1' /
   V7469     '2012 A06b MJ B/GFRND DISAP F1' /
   V7470     '2012 A06b MJ DISLIKE USERS F1' /
   V7471     '2012 A06b MJ FRNDS NOT USE F1' /
   V7472     '2012 A06b MJ TOO EXPENSIVE F1' /
   V7473     '2012 A06b MJ NOT AVAILABLE F1' /
   V7474     '2012 A06b MJ NOT WNT GT HI F1' /
   V7182     '2012 A06c QUIT SMK WRY FAT F34' /
   V7403     '2012 A07a #X/2W RIDE+ALCL  F13' /
   V7404     '2012 A07a #X/2W RIDE+5DRK  F13' /
   V8455     '2012 A08a GT HELP FR DRUGS F24' /
   V7405     '2012 A10a HAD DRUG EDUCATN F3' /
   V7406     '2012 A10a DG ED,>DG INTRST F3' /
   V7407     '2012 A10a DG ED,SPC COURSE F3' /
   V7408     '2012 A10a DG ED,IN REG CRS F3' /
   V7409     '2012 A10a DG ED,NT REG CRS F3' /
   V7410     '2012 A10a DG ED,SPC DISCUS F3' /
   V7411     '2012 A10a DG ED,GRT VALUE  F3' /
   V7482     '2012 A10a DARE EVR IN SCHL F12' /
   V8401     '2012 A10b #X SEE DRUG SPTS F24' /
   V8402     '2012 A10b ADS-YOU <FAVORBL F24' /
   V8403     '2012 A10b ADS-YOU <TRY DRG F24' /
   V8404     '2012 A10b ADS-OVRST DANGER F24' /
   V7701     '2012 A10b #X ANTISMK TV/RD F34' /
   V7702     '2012 A10b #X ANTISMK PRINT F34' /
   V7703     '2012 A10b ANTISMK ADS<FVRB F34' /
   V7704     '2012 A10b ANTISMK ADS<LKLY F34' /
   V7705     '2012 A10b ANTISMK ADS EXAG F34' /
   V7714     '2012 A10b SMKRS MOVIE THTR F34' /
   V7715     '2012 A10b SMKRS MOVIE HOME F34' /
   V8478     '2012 A10b #X ANTIDRUG ADS  F2' /
   V7570     '2012 A10b CIG HLTH WARNING F2' /
   V7344     '2012 A11a DISAP 1+PK CIGS  F12' /
   V7345     '2012 A11a DISAP SMOKELESS  F12' /
   V7346     '2012 A11a DISAP MJ 1-2 X   F12' /
   V7347     '2012 A11a DISAP MJ OCCAS   F12' /
   V7348     '2012 A11a DISAP MJ REG     F12' /
   V7349     '2012 A11a DISAP COKP 1-2 X F12' /
   V7350     '2012 A11a DISAP COKP OCCAS F12' /
   V7351     '2012 A11a DISAP CRK 1-2 X  F12' /
   V7352     '2012 A11a DISAP CRK OCCAS  F12' /
   V7353     '2012 A11a DISAP ALC 1-2 X  F12' /
   V7354     '2012 A11a DISAP ALC EVRYDA F12' /
   V7355     '2012 A11a DISAP 5+ALC WKND F12' /
   V7356     '2012 A11a DISAP INHAL 1-2X F12' /
   V7357     '2012 A11a DISAP INHAL REG  F12' /
   V8547     '2012 A11a DISAP LSD 1-2TM  F2' /
   V8548     '2012 A11a DISAP LSD REGULY F2' /
   V7540     '2012 A11a DAP H -NDL 1-2X  F1' /
   V7541     '2012 A11a DAP H -NDL OCC   F1' /
   V8562     '2012 A11a DISAP MDMA 1-2X  F2' /
   V8563     '2012 A11a DISAP MDMA OCC   F2' /
   V8456     '2012 A11c SMKRS ENJOY LIFE F24' /
   V8457     '2012 A11c PRFR DATE N-SMKR F24' /
   V8458     '2012 A11c HARMFUL CIG EXAG F24' /
   V8459     '2012 A11c SMKR POOR JDGMNT F24' /
   V8460     '2012 A11c DONT MIND SMOKNG F24' /
   V8461     '2012 A11c SMKG DIRTY HABIT F24' /
   V8462     '2012 A11c DTEST NEAR SMKRS F24' /
   V7718     '2012 A12b FRD DAP CIGS     F34' /
   V7716     '2012 A12b FRND DAP CIG OCC F34' /
   V7717     '2012 A12b FRND DAP CIG DLY F34' /
   V7719     '2012 A12b FRND DAP SMKL OC F34' /
   V7720     '2012 A12b FRND DAP SMKL DL F34' /
   V7721     '2012 A12b FRND DAP SMKL D+ F34' /
   V7359     '2012 A14a RSK OF CIG1+PK/D F1234' /
   V7360     '2012 A14a RSK SMKLESS REG  F1234' /
   V7361     '2012 A14a RSK OF MJ 1-2 X  F12' /
   V7362     '2012 A14a RSK OF MJ OCSNLY F12' /
   V7363     '2012 A14a RSK OF MJ REGLY  F12' /
   V8545     '2012 A14a RSK OF LSD 1-2X  F2' /
   V8546     '2012 A14a RSK OF LSD REGLY F2' /
   V7364     '2012 A14a RSK COK PWDR 1-2 F12' /
   V7365     '2012 A14a RSK COK PWDR OCC F12' /
   V7366     '2012 A14a RSK CRACK 1-2X   F12' /
   V7367     '2012 A14a RSK CRACK OCC    F12' /
   V7368     '2012 A14a RSK OF 1-2 DRINK F12' /
   V7369     '2012 A14a RSK OF 1-2 DR/DA F12' /
   V7370     '2012 A14a RSK OF 5+DR/WKND F12' /
   V8560     '2012 A14a RSK MDMA 1-2X    F2' /
   V8561     '2012 A14a RSK MDMA OCC     F2' /
   V7371     '2012 A14a RSK INHALANT 1-2 F12' /
   V7372     '2012 A14a RSK INHALANT REG F12' /
   V7542     '2012 A14a RSK H -NDL 1-2X  F1' /
   V7543     '2012 A14a RSK H -NDL OCC   F1' /
   V7377     '2012 A14a RSK 1-5 CIGS/DAY F34' /
   V7577     '2012 A14a RSK ADDERALL 1-2X F34' /
   V7578     '2012 A14a RSK ADDERALL OCC F34' /
   V7571     '2012 A14a RSK SALVIA 1-2X  F34' /
   V7572     '2012 A14a RSK SALVIA OCC   F34' /
   V7573     '2012 A14a RSK SYNTH MJ 1-2X F34' /
   V7574     '2012 A14a RSK SYNTH MJ OCC F34' /
   V7575     '2012 A14a RSK SYNTH STIM 1-2X F34' /
   V7576     '2012 A14a RSK SYNTH STIM OCC F34' /
   V7579     '2012 A14a RSK OXYCON 1-2X  F34' /
   V7580     '2012 A14a RSK OXYCON OCC   F34' /
   V7581     '2012 A14a RSK VICODIN 1-2X F34' /
   V7582     '2012 A14a RSK VICODIN OCC  F34' /
   V7583     '2012 A14a RSK COUGHMD 1-2X F34' /
   V7584     '2012 A14a RSK COUGHMD OCC  F34' /
   V7585     '2012 A14a RSK DISLV TOB REG F34' /
   V7586     '2012 A14a RSK SNUS REG     F34' /
   V7710     '2012 A17a USE DRUGS-ATHLT  F34' /
   V7711     '2012 A17a USE DRUGS-ROCK   F34' /
   V7712     '2012 A17a USE DRUGS-ACTOR  F34' /
   V7713     '2012 A17a USE DRUGS-PEERS  F34' /
   V7706     '2012 A17a CIG SMKRS-ATHLTS F34' /
   V7707     '2012 A17a CIG SMKRS-ROCKRS F34' /
   V7708     '2012 A17a CIG SMKRS-ACTORS F34' /
   V7709     '2012 A17a CIG SMKRS-PEERS  F34' /
   V7189     '2012 A18b OWN TOBACCO LOGO F34' /
   V7190     '2012 A18b CIG LOGO CAMEL   F34' /
   V7191     '2012 A18b CIG LOGO KOOL    F34' /
   V7192     '2012 A18b CIG LOGO MARLB   F34' /
   V7193     '2012 A18b CIG LOGO NEWPT   F34' /
   V7194     '2012 A18b CIG LOGO VASLM   F34' /
   V7195     '2012 A18b CIG LOGO OTHER   F34' /
   V7196     '2012 A18c SAVED CIG COUPON F34' /
   V7197     '2012 A18c SAVE CIG CPN NOW F34' /
   V7198     '2012 A18d CO GIVE FREE CIG F34' /
   V7222     '2012 B01 R''S HS PROGRAM   F1234' /
   V7221     '2012 B01 R HS GRADE/D=1   F1234' /
   V7223     '2012 B01 R WL GRADUATE HS F1234' /
   V7327     '2012 B01 HRS/WK SPND HMWK F1234' /
   V7516     '2012 B01 SCH ACTV-PBLCTNS F13' /
   V7517     '2012 B01 SCH ACTV-PRF ART F13' /
   V7518     '2012 B01 SCH ACTV-ATHLTCS F13' /
   V7519     '2012 B01 SCH ACTV-OTH ACT F13' /
   V7329     '2012 B01 LSTYR/ENJOY SCHL F1234' /
   V7330     '2012 B01 LSTYR/HATE SCHL  F1234' /
   V7331     '2012 B01 LSTYR/DO BEST WK F1234' /
   V7332     '2012 B01 LSTYR/SCH 2 HARD F1234' /
   V7334     '2012 B01 LSTYR/WK NT DONE F1234' /
   V7335     '2012 B01 LSTYR/U MISBEHAV F1234' /
   V7232     '2012 B01 EVER HELD BACK   F1234' /
   V7233     '2012 B01 NEED SUMMER SCHL F1234' /
   V7301     '2012 B01 WHAT GRADE LEVL  F1234' /
   V7333     '2012 B01 LSTYR/WK INTRSTG F1234' /
   V7251     '2012 B01 THNK FUT BYND SC F1234' /
   V7252     '2012 B01 PLANS AFTER SCHL F1234' /
   V7384     '2012 B01 SPORT/12M NONE   F1' /
   V7385     '2012 B01 SPORT/12M BASEBL F1' /
   V7386     '2012 B01 SPORT/12M BSKTBL F1' /
   V7496     '2012 B01 SPORT/12M CHEERLDG F1' /
   V7497     '2012 B01 SPORT/12M CREW   F1' /
   V7387     '2012 B01 SPORT/12M XCNTRY F1' /
   V7498     '2012 B01 SPORT/12M EQUESTRN F1' /
   V7388     '2012 B01 SPORT/12M FLDHKY F1' /
   V7389     '2012 B01 SPORT/12M FOOTBL F1' /
   V7499     '2012 B01 SPORT/12M GOLF   F1' /
   V7390     '2012 B01 SPORT/12M GYMNST F1' /
   V7391     '2012 B01 SPORT/12M ICEHKY F1' /
   V7392     '2012 B01 SPORT/12M LCRSSE F1' /
   V7393     '2012 B01 SPORT/12M SWIM   F1' /
   V7394     '2012 B01 SPORT/12M SOCCER F1' /
   V7395     '2012 B01 SPORT/12M TENNIS F1' /
   V7396     '2012 B01 SPORT/12M TRACK  F1' /
   V7397     '2012 B01 SPORT/12M VLLYBL F1' /
   V7500     '2012 B01 SPORT/12M WATER POLO F1' /
   V7398     '2012 B01 SPORT/12M WTLIFT F1' /
   V7399     '2012 B01 SPORT/12M WRESTL F1' /
   V7400     '2012 B01 SPORT/12M OTHER  F1' /
   V7556     '2012 B01 #DA/WK GYM CLASS F1' /
   V7522     '2012 B04 LOT CMPTN GRADE  F13' /
   V7523     '2012 B04 STDTS DSLK CHTG  F13' /
   V7524     '2012 B04 ST -LK PROV TCH  F13' /
   V7525     '2012 B04 FRD NCG/TCH -LK  F13' /
   V7526     '2012 B04 STS SCH RT FAMLY F13' /
   V7527     '2012 B04 STS SCH LDS STU  F13' /
   V7528     '2012 B04 STS SCH NIC CAR  F13' /
   V7529     '2012 B04 STS SCH HI GRDE  F13' /
   V7530     '2012 B04 STS SCH GD ATHLT F13' /
   V7531     '2012 B04 STS SCH PLN CLG  F13' /
   V8537     '2012 B04 #X TCHR INTRUPT  F2' /
   V8538     '2012 B04 #X MISBHVR INT U F2' /
   V7537     '2012 B04 SCHL RULES FAIR  F1' /
   V7253     '2012 B04 FRNDS DROP OUT   F1234' /
   V7228     '2012 B06 #DA/4W SC MS ILL F1234' /
   V7229     '2012 B06 #DA/4W SC MS CUT F1234' /
   V7230     '2012 B06 #DA/4W SC MS OTH F1234' /
   V7231     '2012 B06 #DA/4W SKP CLASS F1234' /
   V8539     '2012 B06 #X U UNEXCSD LAT F2' /
   V8516     '2012 B07 FRQ FGT WRK/SCHL F2' /
   V8522     '2012 B07 FRQ DMG SCH PPTY F24' /
   V7509     '2012 B07 SM1 SCL ROB <$50 F1' /
   V7510     '2012 B07 SM1 SCL ROB >$50 F1' /
   V7511     '2012 B07 SM1 SCL DMG PRTY F1' /
   V7512     '2012 B07 SM1 SCL IN U W/W F1' /
   V7513     '2012 B07 SM1 SCL TH U W/W F1' /
   V7514     '2012 B07 SM1 SCL IN U -WP F1' /
   V7515     '2012 B07 SM1 SCL TH U W/I F1' /
   V7234     '2012 B07 EVER SUSPENDED   F1234' /
   V8543     '2012 B07 4WKS WEAPON@SCHL F2' /
   V7534     '2012 B07 FEEL UNSAFE@SCHL F1' /
   V7535     '2012 B07 UNSAF TO/FRM SCH F1' /
   V7536     '2012 B07 4WK/UNSAF AVDSCH F1' /
   V7538     '2012 B07 #DA GUN SCHL/4WK F1' /
   V7224     '2012 B09 R WL DO VOC/TEC  F1234' /
   V7225     '2012 B09 R WL GO TO CLG   F1234' /
   V7227     '2012 B09 R WL DO ARMD FC  F1234' /
   V7226     '2012 B09 R WL DO 4YR CLG  F1234' /
   V7235     '2012 C01 HRS/WK PAID JOB  F1234' /
   V7238     '2012 C01 KIND OF PAID JOB F12' /
   V7236     '2012 C02 R$/AVG WEEK JOB  F1234' /
   V7237     '2012 C02 R$/AVG WEEK OTH  F1234' /
   V7374     '2012 C04 # HRS PREF WORK  F234' /
   V7240     '2012 C07 #X DATE 3+/WK    F1234' /
   V7309     '2012 C07 DALY GO TO MOVIE F1234' /
   V7310     '2012 C07 DALY MUSIC CNCRT F1234' /
   V7311     '2012 C07 DALY RIDE FORFUN F1234' /
   V7312     '2012 C07 DALY CMNTY AFFRS F1234' /
   V7313     '2012 C07 DALY ACTV SPORTS F1234' /
   V7378     '2012 C07 DALY VIS FRDS FR F1234' /
   V7379     '2012 C07 DALY GO TO MALL  F1234' /
   V7380     '2012 C07 DALY ALONE LS/FR F1234' /
   V7319     '2012 C07 DALY GO TO PARTY F1234' /
   V7325     '2012 C07 #HRS TV/DAY/5+   F1234' /
   V7317     '2012 C07 DALY READ MAGZNS F1234' /
   V7318     '2012 C07 DALY READ NWSPPR F1234' /
   V7320     '2012 C07 #XUSE RADIO4NEWS F1234' /
   V7321     '2012 C07 #XUSE TV 4 NEWS  F1234' /
   V7322     '2012 C07 #X USE PPR 4NEWS F1234' /
   V7323     '2012 C07 #X USE MAG 4NEWS F1234' /
   V7381     '2012 C07 #X INTERNET NEWS F1234' /
   V7324     '2012 C07 # HRS RADIO/DAY  F1234' /
   V7326     '2012 C07 # HRS TV/WKEND   F1234' /
   V7214     '2012 C07 AFTER SCHL ALONE F1234' /
   V7239     '2012 C07 #X OUT W/O PRNT  F1234' /
   V7539     '2012 C07 DALY GO VID ARC  F24' /
   V7552     '2012 C09 DALY WEB FACEBK  F1!2!3!4!' /
   V7544     '2012 C09 #HR/W COMPUTR SC F1' /
   V7545     '2012 C09 #HR/W COMPUTR JO F1' /
   V7546     '2012 C09 #HR/W COMPUTR OT F1' /
   V7551     '2012 C09 #HR/W INTERNET S F1' /
   V7553     '2012 C09 #HR/W GAMING     F1' /
   V7562     '2012 C10 # HR/W TEXT CELL PHO F1' /
   V7563     '2012 C10 # HR/W TALK CELL PHO F1' /
   V7341     '2012 D05 MN=ACHV/WMN=HOME F2' /
   V7343     '2012 D05 WK MO AS WRM REL F2' /
   V7532     '2012 D05 MO SH B W CHL>TM F3' /
   V7533     '2012 D05 FTHR>TIME W CHLD F3' /
   V7339     '2012 D06 MEN&WOMN/=$,=WRK F2' /
   V7340     '2012 D06 WMN SHD =JOB OPP F2' /
   V7401     '2012 F07 DRIVE>200 MI/WK  F13' /
   V7402     '2012 F07 USE SEATBLT-RIDR F13' /
   V7219     '2012 G R''ATTND REL SVC  F1234' /
   V7220     '2012 G RLGN IMP R''S LF  F1234' /
   V7255     '2012 M02 TALK PROB W/ADLT F1234' /
   V7241     '2012 M03 #X PRNT CHK HMWK F12' /
   V7242     '2012 M03 #X PRNT HLP HMWK F12' /
   V7243     '2012 M03 #X PRNT GV CHORE F12' /
   V7244     '2012 M03 #X PRNT LIMIT TV F12' /
   V7258     '2012 M03 #X PRNT ALW OUT  F12' /
   V7375     '2012 M03 PRT #HR PREF WRK F2' /
   V7254     '2012 M03 TALK PROB W/PRNT F1234' /
   V7259     '2012 M03 PRN KNW AFT SCHL F34' /
   V7260     '2012 M03 PRN KNW WHO@NITE F34' /
   V7261     '2012 M03 PRN KNW WHER@NGT F34' /
   V7262     '2012 M03 R''S WKND CURFEW  F34' /
   V7565     '2012 M03 DINNER W/PARENT  F1' /
   V7302     '2012 P01 VRY HPY THS DAY  F1234' /
   V8512     '2012 P01 SATISFD W MYSELF F24' /
   V8502     '2012 P01 LIFE MEANINGLESS F24' /
   V8505     '2012 P01 I ENJOY LIFE     F24' /
   V8509     '2012 P01 FUTURE HOPELESS  F24' /
   V8514     '2012 P01 GOOD TO BE ALIVE F24' /
   V8536     '2012 P01 FUTR R LIFE WRSE F2' /
   V8501     '2012 Q01 POS ATT TWD SELF F24' /
   V8504     '2012 Q01 AM PRSN OF WORTH F24' /
   V8508     '2012 Q01 DO WELL AS OTHRS F24' /
   V8503     '2012 Q01 -MUCH TO B PROUD F24' /
   V8507     '2012 Q01 I AM NO GOOD     F24' /
   V8511     '2012 Q01 I DO WRONG THING F24' /
   V8513     '2012 Q01 MY LIFE NT USEFL F24' /
   V7501     '2012 Q03 OFTN FEEL LONELY F3' /
   V7502     '2012 Q03 ALWYS SM1 HELP R F3' /
   V7504     '2012 Q03 OFTN FL LEFT OUT F3' /
   V7505     '2012 Q03 USLY SM1 TALK TO F3' /
   V7507     '2012 Q03 OFT WSH MOR FRND F3' /
   V7508     '2012 Q03 USLY FRDS BE WTH F3' /
   V7503     '2012 Q04 KICK DO DANGR TH F234' /
   V7506     '2012 Q04 LIKE RISK SOME X F234' /
   V8555     '2012 Q04 LIK XPLOR STRANG F2' /
   V8556     '2012 Q04 LIK DO FRIGHT TG F2' /
   V8557     '2012 Q04 LIK EVN BRK RULE F2' /
   V8558     '2012 Q04 PRF FRND EXCITNG F2' /
   V8565     '2012 Q10 I AM OFTEN BORED F2' /
   V8566     '2012 Q10 OFT NOTHNG TO DO F2' /
   V1252     '2012 (R) AGE <>16 DICHOTOMY (10TH GR ONLY)' /
   V7202     '2012 R01 R''S SEX          F1234' /
   V1070     '2012 RACE--B/W/H  F1234' /
   V7215     '2012 R02 FATHR EDUC LEVEL F1234' /
   V7216     '2012 R02 MOTHR EDUC LEVEL F1234' /
   V7217     '2012 R02 MOTHER PAID JOB  F1234' /
   V7206     '2012 R03 R''S HSHLD FATHER F1234' /
   V7207     '2012 R03 R''S HSHLD MOTHER F1234' /
   V7208     '2012 R03 R''S HSHLD SIBLING F1234' /
   V7205     '2012 R03 WHERE LIVE NOW   F1234' /
   V8517     '2012 S01 FRQ GANG FIGHT   F2' /
   V8518     '2012 S01 FRQ HURT SM1 BAD F2' /
   V8519     '2012 S01 FRQ STEAL <$50   F24' /
   V8520     '2012 S01 FRQ STEAL >$50   F24' /
   V8521     '2012 S01 FRQ TRESPAS BLDG F2' /
   V8523     '2012 S01 FRQ SELL DRUGS   F2' /
   V8515     '2012 S01 FRQ RUN AWAY HOM F2' /
   V8526     '2012 T02 OFTN EAT BRKFST  F2' /
   V8527     '2012 T02 OFTN EAT GN VEG  F2' /
   V8528     '2012 T02 OFTN EAT FRUIT   F2' /
   V8529     '2012 T02 OFTN EXERCISE    F2' /
   V8530     '2012 T02 OFTN 7HRS SLEEP  F2' /
   V8531     '2012 T02 OFTN SLEEP <SHLD F2' /
   V7555     '2012 T02 #DA/WK ACTV 60 MIN F1' /
   V7101D    '2013 A01a EVR SMK CIG,REGL F1234 (dicotomous recode)' /
   V7102D    '2013 A01c #CIGS SMKD/30DAY F1234 (dicotomous recode)' /
   V7105D    '2013 A01a #X DRNK/LIFETIME F1234 (dicotomous recode)' /
   V7106D    '2013 A01b #X DRNK/LAST12MO F1234 (dicotomous recode)' /
   V7107D    '2013 A01c #X DRNK/LAST30DA F1234 (dicotomous recode)' /
   V7112D    '2013 A01a #XMJ+HS/LIFETIME F1234 (dicotomous recode)' /
   V7113D    '2013 A01b #XMJ+HS/LAST12MO F1234 (dicotomous recode)' /
   V7114D    '2013 A01c #XMJ+HS/LAST30DA F1234 (dicotomous recode)' /
   V7115D    '2013 A01a #X LSD/LIFETIME  F1234 (dicotomous recode)' /
   V7116D    '2013 A01b #X LSD/LAST 12MO F1234 (dicotomous recode)' /
   V7117D    '2013 A01c #X LSD/LAST 30DA F1234 (dicotomous recode)' /
   V7118D    '2013 A01a #X PSYD/LIFETIME F1234 (dicotomous recode)' /
   V7119D    '2013 A01b #X PSYD/LAST12MO F1234 (dicotomous recode)' /
   V7120D    '2013 A01c #X PSYD/LAST30DA F1234 (dicotomous recode)' /
   V7127D    '2013 A01a #X AMPH/LIFETIME F12!34! (dicotomous recode)' /
   V7128D    '2013 A01b #X AMPH/LAST12MO F12!34! (dicotomous recode)' /
   V7129D    '2013 A01c #X AMPH/LAST30DA F12!34! (dicotomous recode)' /
   V7097D    '2013 A01a #X SED/BARB/LIFE F1!2!3!4! (dicotomous recode)' /
   V7098D    '2013 A01b #X SED/BARB/12MO F1!2!3!4! (dicotomous recode)' /
   V7099D    '2013 A01c #X SED/BARB/30DA F1!2!3!4! (dicotomous recode)' /
   V7133D    '2013 A01a #X TRQL/LIFETIME F1234 (dicotomous recode)' /
   V7134D    '2013 A01b #X TRQL/LAST12MO F1234 (dicotomous recode)' /
   V7135D    '2013 A01c #X TRQL/LAST30DA F1234 (dicotomous recode)' /
   V7142D    '2013 A01a #X INHL/LIFETIME F1234 (dicotomous recode)' /
   V7143D    '2013 A01b #X INHL/LAST12MO F1234 (dicotomous recode)' /
   V7144D    '2013 A01c #X INHL/LAST30DA F1234 (dicotomous recode)' /
   V7139D    '2013 A01a #X NARC/LIFETIME F234 (dicotomous recode)' /
   V7140D    '2013 A01b #X NARC/LAST12MO F234 (dicotomous recode)' /
   V7141D    '2013 A01c #X NARC/LAST30DA F234 (dicotomous recode)' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   V501      8 'EIGHTH:(8)' 10 'TENTH:(10)' /
   V507      1 'NORTHEAST:(1)' 2 'NORTHCENTRAL:(2)' 3 'SOUTH:(3)'
             4 'WEST:(4)' /
   V508      0 'NOT:(0)' 1 'LARGE MSA:(1)' /
   V509      0 'NON-MSA:(0)' 1 'MSA:(1)' /
   V7101     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 '1-2X:(2)' 3 'OCCASNLY:(3)'
             4 'REG PAST:(4)' 5 'REG NOW:(5)' /
   V7104     -9 'MISSING:(-9)' 1 'NO:(1)' 2 'YES:(2)' /
   V7105     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7112     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7115     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7118     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7127     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7097     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7133     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7139     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7142     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V8451     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7426     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 '1-2X:(2)' 3 'OCCASNLY:(3)' 4 'REG PAST:(4)'
             5 'REG NOW:(5)' /
   V7121     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7124     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7164     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7145     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7109     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7152     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7155     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7158     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7161     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7601     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V8480     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7106     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7113     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7116     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7119     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7128     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7098     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7134     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7140     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7143     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V8452     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7122     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7125     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7165     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7146     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7110     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7153     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7156     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7159     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7162     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7602     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7487     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7488     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7489     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7491     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7492     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V8481     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7495     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7554     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7561     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7564     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7566     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7568     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7569     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7567     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7102     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '<1 CIG/DAY:(2)'
             3 '1-5 CIG/DAY:(3)' 4 '1/2PK/DAY:(4)' 5 '1 PK/DAY:(5)'
             6 '1.5 PK/DAY:(6)' 7 '2+ PKS/DAY:(7)' /
   V7107     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7114     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7117     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7120     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7129     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7099     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7135     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7141     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7144     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V8453     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7427     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT@ALL:(1)' 2 '1-2 X:(2)' 3 '1-2/WK:(3)' 4 '3-5/WK:(4)'
             5 '1/DAY:(5)' 6 '>1/DAY:(6)' /
   V7123     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7126     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7166     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7147     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7111     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7154     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7157     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7160     -9 'MISSING:(-9)' 1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)'
             4 '6-9X:(4)' 5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7163     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7603     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V8482     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 OCCAS:(1)' 2 '1-2X:(2)' 3 '3-5X:(3)' 4 '6-9X:(4)'
             5 '10-19X:(5)' 6 '20-39X:(6)' 7 '40+X:(7)' /
   V7108     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)'
             4 '3-5 TIMES:(4)' 5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V8454     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7442     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7441     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8413     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V7443     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7444     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7445     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8417     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V8418     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V8419     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V8483     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V8421     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V7446     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7447     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8424     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V8425     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V7448     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V7449     -9 'MISSING:(-9)' 1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)'
             3 'GRADE 6:(3)' 4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)'
             7 'GRADE 10:(7)' 8 'NEVER:(8)' /
   V8564     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'GRADE 4 OR <:(1)' 2 'GRADE 5:(2)' 3 'GRADE 6:(3)'
             4 'GRADE 7:(4)' 5 'GRADE 8:(5)' 6 'GRADE 9:(6)' 7 'GRADE 10:(7)'
             8 'NEVER:(8)' /
   V7548     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '1-4 YRS:(1)' 2 '5-9:(2)' 3 '10-14:(3)' 4 '15+ YRS:(4)' /
   V7103     -9 'MISSING:(-9)' 1 'YES:(1)' 2 'NO:(2)' /
   V7180     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7181     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'YES:(1)' 2 'NO:(2)' 8 'DONT SMOKE:(8)' /
   V7475     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7476     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7477     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7478     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7479     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7480     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' 8 'NEVER USED:(8)' /
   V7547     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES PAST:(2)' 3 'YES NOW:(3)' /
   V7549     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '<1 YEAR:(1)' 2 '1 YEAR:(2)' 3 '2 YRS:(3)' 4 '3-5 YRS:(4)'
             5 '6-9 YRS:(5)' 6 '10+ YRS:(6)' /
   V7550     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES PAST:(2)' 3 'YES NOW:(3)' 8 'DONT KNOW:(8)' /
   V7176     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'BASIC:(1)' 2 'BEN&HEDGE:(2)' 3 'BLK&WHITE:(3)'
             4 'CAMBRIDGE:(4)' 5 'CAMEL:(5)' 6 'CAPRI:(6)' 7 'CARLTON:(7)'
             8 'DORAL:(8)' 9 'GPC:(9)' 10 'KENT:(10)' 11 'KOOL:(11)'
             12 'MARLBORO:(12)' 13 'MERIT:(13)' 14 'MISTY:(14)'
             15 'MONARCH:(15)' 16 'MORE:(16)' 17 'NEWPORT:(17)'
             18 'PALLMALL:(18)' 19 'PARLMENT:(19)' 20 'SALEM:(20)'
             21 'VANTAGE:(21)' 22 'VA SLIMS:(22)' 23 'WINSTON:(23)'
             24 'OTHER:(24)' 25 'NO USUAL BRAND:(25)' /
   V7587     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7557     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NONE:(0)' 1 '< 1:(1)' 2 'ONE:(2)' 3 'TWO:(3)' 4 'THREE:(4)'
             5 'FOUR:(5)' 6 '5-6:(6)' 7 '7 OR +:(7)' /
   V7558     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NONE:(0)' 1 '< 1:(1)' 2 'ONE:(2)' 3 'TWO:(3)' 4 'THREE:(4)'
             5 'FOUR:(5)' 6 '5-6:(6)' 7 '7 OR +:(7)' /
   V7559     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NONE:(0)' 1 '< 1:(1)' 2 'ONE:(2)' 3 'TWO:(3)' 4 'THREE:(4)'
             5 'FOUR:(5)' 6 '5-6:(6)' 7 '7 OR +:(7)' /
   V7560     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NONE:(0)' 1 '< 1:(1)' 2 'ONE:(2)' 3 'TWO:(3)' 4 'THREE:(4)'
             5 'FOUR:(5)' 6 '5-6:(6)' 7 '7 OR +:(7)' /
   V7428     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7432     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7433     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7435     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7430     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7431     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7434     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7429     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V7436     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)' 4 'MOST:(4)' 5 'ALL:(5)'
             /
   V8473     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' /
   V8474     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' /
   V8475     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' /
   V7437     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7438     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7439     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7440     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7414     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7415     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7416     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'PROB IMP:(1)' 2 'VRY DIFF:(2)' 3 'FRLY DIF:(3)'
             4 'FRLY EAS:(4)' 5 'VRY EASY:(5)' 8 'CANT SAY:(8)' /
   V7417     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7494     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7419     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7420     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7421     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7422     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7423     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'PROB IMP:(1)' 2 'VRY DIFF:(2)' 3 'FRLY DIF:(3)'
             4 'FRLY EAS:(4)' 5 'VRY EASY:(5)' 8 'CANT SAY:(8)' /
   V7412     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7413     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7490     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'PROB IMP:(1)' 2 'VRY DIFF:(2)' 3 'FRLY DIF:(3)'
             4 'FRLY EAS:(4)' 5 'VRY EASY:(5)' 8 'CANT SAY:(8)' /
   V7425     -9 'MISSING:(-9)' 1 'PROB IMP:(1)' 2 'VRY DIFF:(2)'
             3 'FRLY DIF:(3)' 4 'FRLY EAS:(4)' 5 'VRY EASY:(5)'
             8 'CANT SAY:(8)' /
   V7424     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'PROB IMP:(1)' 2 'VRY DIFF:(2)' 3 'FRLY DIF:(3)'
             4 'FRLY EAS:(4)' 5 'VRY EASY:(5)' 8 'CANT SAY:(8)' /
   V8544     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'YES:(1)' 2 'NO:(2)' /
   V8477     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)' 4 '1+ /WK:(4)'
             5 'ALMOST DAILY:(5)' /
   V7167     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7168     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7169     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7170     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7171     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7172     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7173     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7174     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7175     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7177     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER TRIED:(1)' 2 'NO & SOLD:(2)' 3 'NO & NOSALE:(3)'
             4 'YES:(4)' /
   V7178     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'ID & GOT:(1)' 2 'ID & NOSALE:(2)' 3 'NO ID & SOLD:(3)'
             4 'NO ID & NOSALE:(4)' /
   V7179     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'PAST 12MO:(2)' 3 'NOT PAST12MO:(3)' /
   V7199     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7200     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7185     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DEF WILL:(1)' 2 'PROB WILL:(2)' 3 'PROB WONT:(3)'
             4 'DEF WONT:(4)' /
   V7458     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DEF WILL:(1)' 2 'PRB WILL:(2)' 3 'PRB NOT:(3)'
             4 'DEF NOT:(4)' /
   V7186     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7187     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7188     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7184     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'ALREADY TRIED:(1)' 2 'DEF WILL:(2)' 3 'PROB WILL:(3)'
             4 'PROB WONT:(4)' 5 'DEF WONT:(5)' /
   V7451     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7452     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7453     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7454     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7455     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7456     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7457     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8441     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8442     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8443     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8444     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8445     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8446     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8447     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8476     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V8540     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V8541     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V8542     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V7481     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 '1-2 X:(2)' 3 '3-5 X:(3)' 4 '6+ TIMES:(4)' /
   V7183     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7459     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7460     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7461     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7462     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7463     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7464     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7465     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7466     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7467     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7468     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7469     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7470     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7471     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7472     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7473     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7474     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SOMEWHAT:(2)' 3 'VERY IMP:(3)' /
   V7182     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'A LOT:(4)' /
   V7403     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V7404     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-5 TIMES:(4)'
             5 '6-9 TIMES:(5)' 6 '10+ TIMES:(6)' /
   V8455     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'NOPASTYR:(2)' 3 'INPASTYR:(3)' /
   V7405     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'WISH HAD:(2)' 3 'YES:(3)' /
   V7406     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '<INTERST:(1)' 2 'NO CHNGE:(2)' 3 '>INTERST:(3)' 8 'INAP:(8)'
             /
   V7407     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' 8 'INAP:(8)' /
   V7408     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' 8 'INAP:(8)' /
   V7409     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' 8 'INAP:(8)' /
   V7410     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NT MARKED:(0)' 1 'MARKED:(1)' 8 'INAP:(8)' /
   V7411     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO VALUE:(1)' 2 'SOME:(2)' 3 'CNSIDRBL:(3)' 4 'GT VALUE:(4)'
             8 'INAP:(8)' /
   V7482     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'YES:(1)' 2 'NO:(2)' 8 'NOT SURE:(8)' /
   V8401     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT@ALL:(1)' 2 '<1/MONTH:(2)' 3 '1-3X/MON:(3)'
             4 '1-3/WEEK:(4)' 5 'DAILY:(5)' 6 '>1/DAY:(6)' /
   V8402     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'LTTL EXT:(2)' 3 'SOME EXT:(3)'
             4 'GRT EXT:(4)' 5 'VRGR EXT:(5)' /
   V8403     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'LTTL EXT:(2)' 3 'SOME EXT:(3)'
             4 'GRT EXT:(4)' 5 'VRGR EXT:(5)' /
   V8404     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'LTTL EXT:(2)' 3 'SOME EXT:(3)'
             4 'GRT EXT:(4)' 5 'VRGR EXT:(5)' /
   V7701     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT@ALL:(1)' 2 '<1X/MO:(2)' 3 '1-3/MO:(3)' 4 '1-3/WK:(4)'
             5 'ABT DAILY:(5)' 6 '> DAILY:(6)' /
   V7702     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT@ALL:(1)' 2 '<1X/MO:(2)' 3 '1-3/MO:(3)' 4 '1-3/WK:(4)'
             5 'ABT DAILY:(5)' 6 '> DAILY:(6)' /
   V7703     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT@ALL:(1)' 2 'LITTLE:(2)' 3 'SOME:(3)' 4 'GREAT:(4)'
             5 'VRY GREAT:(5)' /
   V7704     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT@ALL:(1)' 2 'LITTLE:(2)' 3 'SOME:(3)' 4 'GREAT:(4)'
             5 'VRY GREAT:(5)' /
   V7705     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT@ALL:(1)' 2 'LITTLE:(2)' 3 'SOME:(3)' 4 'GREAT:(4)'
             5 'VRY GREAT:(5)' /
   V7714     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'SOME:(2)' 3 'A LOT:(3)' 4 'DONT REMEMBER:(4)' /
   V7715     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'SOME:(2)' 3 'A LOT:(3)' 4 'DONT REMEMBER:(4)' /
   V8478     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT AT ALL:(1)' 2 '<1 /MO:(2)' 3 '1-3 /MO:(3)'
             4 '1-3 /WK:(4)' 5 'ALMOST DAILY:(5)' 6 '1+ /DAY:(6)' /
   V7570     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'YES:(1)' 2 'NO:(2)' /
   V7344     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7345     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7346     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7347     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7348     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7349     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7350     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7351     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7352     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7353     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7354     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7355     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7356     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7357     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V8547     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V8548     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7540     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V7541     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V8562     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V8563     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DONT DIS:(1)' 2 'DISAPPRV:(2)' 3 'STRG DIS:(3)'
             8 'CANT SAY:(8)' /
   V8456     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8457     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8458     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8459     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8460     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8461     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8462     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7718     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NT DISAP:(1)' 2 'DISAPRV:(2)' 3 'ST DISAP:(3)' /
   V7716     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NT DISAP:(1)' 2 'DISAPRV:(2)' 3 'ST DISAP:(3)' /
   V7717     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NT DISAP:(1)' 2 'DISAPRV:(2)' 3 'ST DISAP:(3)' /
   V7719     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NT DISAP:(1)' 2 'DISAPRV:(2)' 3 'ST DISAP:(3)' /
   V7720     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NT DISAP:(1)' 2 'DISAPRV:(2)' 3 'ST DISAP:(3)' /
   V7721     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NT DISAP:(1)' 2 'DISAPRV:(2)' 3 'ST DISAP:(3)' /
   V7359     -9 'MISSING:(-9)' 1 'NO RISK:(1)' 2 'SLIGHT:(2)'
             3 'MOD RISK:(3)' 4 'GRT RISK:(4)' 8 'CANT SAY:(8)' /
   V7360     -9 'MISSING:(-9)' 1 'NO RISK:(1)' 2 'SLIGHT:(2)'
             3 'MOD RISK:(3)' 4 'GRT RISK:(4)' 8 'CANT SAY:(8)' /
   V7361     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7362     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7363     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8545     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8546     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7364     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7365     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7366     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7367     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7368     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7369     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7370     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8560     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V8561     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7371     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7372     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7542     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7543     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7377     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7577     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7578     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7571     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7572     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7573     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7574     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7575     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7576     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7579     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7580     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7581     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7582     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7583     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7584     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7585     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7586     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO RISK:(1)' 2 'SLIGHT:(2)' 3 'MOD RISK:(3)' 4 'GRT RISK:(4)'
             8 'CANT SAY:(8)' /
   V7710     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7711     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7712     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7713     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7706     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7707     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7708     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7709     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0%-10%:(1)' 2 '11%-30%:(2)' 3 '31%-50%:(3)' 4 '51%-70%:(4)'
             5 '71%-90%:(5)' 6 '91%-100%:(6)' 8 'NO IDEA:(8)' /
   V7189     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' /
   V7190     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NO:(0)' 1 'YES:(1)' /
   V7191     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NO:(0)' 1 'YES:(1)' /
   V7192     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NO:(0)' 1 'YES:(1)' /
   V7193     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NO:(0)' 1 'YES:(1)' /
   V7194     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NO:(0)' 1 'YES:(1)' /
   V7195     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NO:(0)' 1 'YES:(1)' /
   V7196     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' /
   V7197     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'YES:(2)' /
   V7198     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'PAST 12MO:(2)' 3 'NOT PAST12M:(3)' /
   V7222     -9 'MISSING:(-9)' 1 'CLG PREP:(1)' 2 'GENERAL:(2)'
             3 'VOC-TECH:(3)' 4 'OTH/DK:(4)' /
   V7221     -9 'MISSING:(-9)' 1 'D:(1)' 2 'C-:(2)' 3 'C:(3)' 4 'C+:(4)'
             5 'B-:(5)' 6 'B:(6)' 7 'B+:(7)' 8 'A-:(8)' 9 'A:(9)' /
   V7223     -9 'MISSING:(-9)' 1 'DEF WONT:(1)' 2 'PRB WONT:(2)'
             3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7327     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '1-4 HRS:(2)' 3 '5-9 HRS:(3)'
             4 '10-14HRS:(4)' 5 '15-19HRS:(5)' 6 '20-24HRS:(6)'
             7 '25+ HRS:(7)' /
   V7516     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SLIGHT:(2)' 3 'MODERATE:(3)'
             4 'CONSDRBL:(4)' 5 'GRT EXT:(5)' /
   V7517     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SLIGHT:(2)' 3 'MODERATE:(3)'
             4 'CONSDRBL:(4)' 5 'GRT EXT:(5)' /
   V7518     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SLIGHT:(2)' 3 'MODERATE:(3)'
             4 'CONSDRBL:(4)' 5 'GRT EXT:(5)' /
   V7519     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'SLIGHT:(2)' 3 'MODERATE:(3)'
             4 'CONSDRBL:(4)' 5 'GRT EXT:(5)' /
   V7329     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7330     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7331     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7332     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7334     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7335     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7232     -9 'MISSING:(-9)' 0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7233     -9 'MISSING:(-9)' 0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7301     -9 'MISSING:(-9)' 1 '7TH:(1)' 2 '8TH:(2)' 3 '9TH:(3)'
             4 '10TH:(4)' 5 '11TH:(5)' 6 '12TH:(6)' /
   V7333     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' 5 'ALWAYS:(5)' /
   V7251     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)'
             4 'OFTEN:(4)' /
   V7252     -9 'MISSING:(-9)' 1 'NO IDEA:(1)' 2 'A FEW:(2)' 3 'PRTYWELL:(3)'
             4 'EXACTLY:(4)' /
   V7384     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7385     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7386     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7496     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7497     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7387     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7498     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7388     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7389     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7499     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7390     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7391     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7392     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7393     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7394     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7395     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7396     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7397     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7500     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7398     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7399     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7400     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7556     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 '0 DAYS:(0)' 1 '1 DAY:(1)' 2 '2 DAYS:(2)' 3 '3 DAYS:(3)'
             4 '4 DAYS:(4)' 5 '5 DAYS:(5)' /
   V7522     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'A LITTLE:(2)' 3 'SOME:(3)' 4 'QUITEBIT:(4)'
             5 'GRT DEAL:(5)' /
   V7523     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'LIK VMCH:(1)' 2 'LIKE IT:(2)' 3 'NOT CARE:(3)'
             4 'DISLIKE:(4)' 5 'DLIK MCH:(5)' /
   V7524     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'LIK VMCH:(1)' 2 'LIKE IT:(2)' 3 'NOT CARE:(3)'
             4 'DISLIKE:(4)' 5 'DLIK MCH:(5)' /
   V7525     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMTIMES:(3)' 4 'OFTEN:(4)'
             5 'ALWAYS:(5)' /
   V7526     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO IMPRT:(1)' 2 'LITL IMP:(2)' 3 'MOD IMPT:(3)'
             4 'GRT IMPT:(4)' 5 'VGRT IMP:(5)' /
   V7527     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO IMPRT:(1)' 2 'LITL IMP:(2)' 3 'MOD IMPT:(3)'
             4 'GRT IMPT:(4)' 5 'VGRT IMP:(5)' /
   V7528     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO IMPRT:(1)' 2 'LITL IMP:(2)' 3 'MOD IMPT:(3)'
             4 'GRT IMPT:(4)' 5 'VGRT IMP:(5)' /
   V7529     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO IMPRT:(1)' 2 'LITL IMP:(2)' 3 'MOD IMPT:(3)'
             4 'GRT IMPT:(4)' 5 'VGRT IMP:(5)' /
   V7530     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO IMPRT:(1)' 2 'LITL IMP:(2)' 3 'MOD IMPT:(3)'
             4 'GRT IMPT:(4)' 5 'VGRT IMP:(5)' /
   V7531     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO IMPRT:(1)' 2 'LITL IMP:(2)' 3 'MOD IMPT:(3)'
             4 'GRT IMPT:(4)' 5 'VGRT IMP:(5)' /
   V8537     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 '< 1/WK:(2)' 3 '1-2X/WK:(3)' 4 '3-5X/WK:(4)'
             5 '6-9X/WK:(5)' 6 '10-19X/W:(6)' 7 '20+:(7)' /
   V8538     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 '< 1/WK:(2)' 3 '1-2X/WK:(3)' 4 '3-5X/WK:(4)'
             5 '6-9X/WK:(5)' 6 '10-19X/W:(6)' 7 '20+:(7)' /
   V7537     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO:(1)' 2 'NO MSTLY:(2)' 3 'DK:(3)' 4 'YES MSTL:(4)'
             5 'YES:(5)' /
   V7253     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 'A FEW:(2)' 3 'SOME:(3)'
             4 'MOST/ALL:(4)' /
   V7228     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '1 DAY:(2)' 3 '2 DAYS:(3)'
             4 '3 DAYS:(4)' 5 '4-5 DAYS:(5)' 6 '6-10 DA:(6)' 7 '11+ DAYS:(7)'
             /
   V7229     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '1 DAY:(2)' 3 '2 DAYS:(3)'
             4 '3 DAYS:(4)' 5 '4-5 DAYS:(5)' 6 '6-10 DA:(6)' 7 '11+ DAYS:(7)'
             /
   V7230     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '1 DAY:(2)' 3 '2 DAYS:(3)'
             4 '3 DAYS:(4)' 5 '4-5 DAYS:(5)' 6 '6-10 DA:(6)' 7 '11+ DAYS:(7)'
             /
   V7231     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '1-2:(2)' 3 '3-5:(3)'
             4 '6-10:(4)' 5 '11-20:(5)' 6 '21+:(6)' /
   V8539     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 '< 1/WK:(2)' 3 '1-2X/WK:(3)' 4 '3-5X/WK:(4)'
             5 '6-9X/WK:(5)' 6 '10-19X/W:(6)' 7 '20+:(7)' /
   V8516     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8522     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V7509     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)'
             5 '5+ TIMES:(5)' /
   V7510     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)'
             5 '5+ TIMES:(5)' /
   V7511     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)'
             5 '5+ TIMES:(5)' /
   V7512     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)'
             5 '5+ TIMES:(5)' /
   V7513     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)'
             5 '5+ TIMES:(5)' /
   V7514     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)'
             5 '5+ TIMES:(5)' /
   V7515     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NOT @ALL:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4 X:(4)'
             5 '5+ TIMES:(5)' /
   V7234     -9 'MISSING:(-9)' 0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V8543     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONE DAY:(2)' 3 'TWO DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V7534     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMEDAYS:(3)' 4 'MOSTDAYS:(4)'
             5 'EVERYDAY:(5)' /
   V7535     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMEDAYS:(3)' 4 'MOSTDAYS:(4)'
             5 'EVERYDAY:(5)' /
   V7536     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '0 DAYS:(1)' 2 '1 DAY:(2)' 3 '2 OR 3:(3)' 4 '4+ DAYS:(4)' /
   V7538     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '1 DAY:(2)' 3 '2 DAYS:(3)' 4 '3-5 DAYS:(4)'
             5 '6-9 DAYS:(5)' 6 '10+ DAYS:(6)' /
   V7224     -9 'MISSING:(-9)' 1 'DEF WONT:(1)' 2 'PRB WONT:(2)'
             3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7225     -9 'MISSING:(-9)' 1 'DEF WONT:(1)' 2 'PRB WONT:(2)'
             3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7227     -9 'MISSING:(-9)' 1 'DEF WONT:(1)' 2 'PRB WONT:(2)'
             3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7226     -9 'MISSING:(-9)' 1 'DEF WONT:(1)' 2 'PRB WONT:(2)'
             3 'PRB WILL:(3)' 4 'DEF WILL:(4)' /
   V7235     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '5 OR <:(2)' 3 '6-10 HRS:(3)'
             4 '11-15 HR:(4)' 5 '16-20 HR:(5)' 6 '21-25 HR:(6)'
             7 '26-30 HR:(7)' 8 '30+ HRS:(8)' /
   V7238     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NO WORK:(1)' 2 'LAWN WK:(2)' 3 'FASTFOOD:(3)' 4 'WAITER:(4)'
             5 'OTH REST:(5)' 6 'PAPER RT:(6)' 7 'BABYSIT:(7)'
             8 'FARM WK:(8)' 9 'SALES WK:(9)' 10 'OFFICE:(10)'
             11 'ODD JOBS:(11)' 12 'OTHER:(12)' /
   V7236     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '$1-5:(2)' 3 '$6-10:(3)'
             4 '$11-20:(4)' 5 '$21-35:(5)' 6 '$36-50:(6)' 7 '$51-75:(7)'
             8 '$76-125:(8)' 9 '$126-175:(9)' 10 '$176+:(10)' /
   V7237     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '$1-5:(2)' 3 '$6-10:(3)'
             4 '$11-20:(4)' 5 '$21-35:(5)' 6 '$36-50:(6)' 7 '$51-75:(7)'
             8 '$76-125:(8)' 9 '$126-175:(9)' 10 '$176+:(10)' /
   V7374     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '5 OR <:(2)' 3 '6-10:(3)' 4 '11-15:(4)'
             5 '16-20:(5)' 6 '21-25:(6)' 7 '26-30:(7)' 8 '31+:(8)' 9 'DK:(9)'
             /
   V7240     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 '1/MO OR<:(2)' 3 '2-3/MO:(3)'
             4 '1/WK:(4)' 5 '2-3/WK:(5)' 6 '3+/WK:(6)' /
   V7309     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7310     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7311     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7312     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7313     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7378     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7379     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7380     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7319     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7325     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '1/2 HOUR:(2)' 3 'ONE HOUR:(3)'
             4 '2 HOURS:(4)' 5 '3 HOURS:(5)' 6 '4 HOURS:(6)' 7 '5+ HRS:(7)' /
   V7317     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7318     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7320     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7321     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7322     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7323     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7381     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)'
             4 '1 /WK:(4)' 5 'NR DAILY:(5)' /
   V7324     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '1/2 HOUR:(2)' 3 'ONE HOUR:(3)'
             4 '2 HOURS:(4)' 5 '3 HOURS:(5)' 6 '4 HOURS:(6)' 7 '5+ HRS:(7)' /
   V7326     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)'
             4 '3-4 HRS:(4)' 5 '5-6 HRS:(5)' 6 '7-8 HRS:(6)' 7 '9+ HRS:(7)' /
   V7214     -9 'MISSING:(-9)' 1 'NONE:(1)' 2 'LT 1 HR:(2)' 3 '1-2HRS:(3)'
             4 '2-3 HRS:(4)' 5 '4-5 HRS:(5)' 6 '>5 HRS(6)' /
   V7239     -9 'MISSING:(-9)' 1 '< 1:(1)' 2 'ONE:(2)' 3 'TWO:(3)'
             4 'THREE:(4)' 5 '4-5:(5)' 6 '6-7:(6)' /
   V7539     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)' 4 '1 /WK:(4)'
             5 'NR DAILY:(5)' /
   V7552     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'FEW /YR:(2)' 3 '1-2 /MO:(3)' 4 '1 /WK:(4)'
             5 'NR DAILY:(5)' /
   V7544     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '3-5 HRS:(4)'
             5 '6-9 HRS:(5)' 6 '10-19 HRS:(6)' 7 '20-29 HRS:(7)'
             8 '30-39 HRS:(8)' 9 '40+ HRS:(9)' /
   V7545     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '3-5 HRS:(4)'
             5 '6-9 HRS:(5)' 6 '10-19 HRS:(6)' 7 '20-29 HRS:(7)'
             8 '30-39 HRS:(8)' 9 '40+ HRS:(9)' /
   V7546     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '3-5 HRS:(4)'
             5 '6-9 HRS:(5)' 6 '10-19 HRS:(6)' 7 '20-29 HRS:(7)'
             8 '30-39 HRS:(8)' 9 '40+ HRS:(9)' /
   V7551     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '3-5 HRS:(4)'
             5 '6-9 HRS:(5)' 6 '10-19 HRS:(6)' 7 '20-29 HRS:(7)'
             8 '30-39 HRS:(8)' 9 '40+ HRS:(9)' /
   V7553     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '3-5 HRS:(4)'
             5 '6-9 HRS:(5)' 6 '10-19 HRS:(6)' 7 '20-29 HRS:(7)'
             8 '30-39 HRS:(8)' 9 '40+ HRS:(9)' /
   V7562     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '3-5 HRS:(4)'
             5 '6-9 HRS:(5)' 6 '10-19 HRS:(6)' 7 '20-29 HRS:(7)'
             8 '30-39 HRS:(8)' 9 '40+ HRS:(9)' /
   V7563     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '< 1 HR:(2)' 3 '1-2 HRS:(3)' 4 '3-5 HRS:(4)'
             5 '6-9 HRS:(5)' 6 '10-19 HRS:(6)' 7 '20-29 HRS:(7)'
             8 '30-39 HRS:(8)' 9 '40+ HRS:(9)' /
   V7341     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7343     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7532     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7533     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7339     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7340     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7401     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '1-10 MI:(2)' 3 '11-50:(3)' 4 '51-100:(4)'
             5 '101-200:(5)' 6 '> 200:(6)' /
   V7402     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)'
             5 'ALWAYS:(5)' 8 'INAP:(8)' /
   V7219     -9 'MISSING:(-9)' 1 'NEVER:(1)' 2 'RARELY:(2)' 3 '1-2X/MO:(3)'
             4 '1/WK OR+:(4)' /
   V7220     -9 'MISSING:(-9)' 1 'NOT IMPT:(1)' 2 'LITL IMP:(2)'
             3 'PRTY IMP:(3)' 4 'VERY IMP:(4)' /
   V7255     -9 'MISSING:(-9)' 1 'NO:(1)' 2 'YES SOME:(2)'
             3 'YES MOST/ALL:(3)' /
   V7241     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7242     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7243     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7244     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7258     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIME:(3)' 4 'OFTEN:(4)' /
   V7375     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 '5 OR <:(2)' 3 '6-10:(3)' 4 '11-15:(4)'
             5 '16-20:(5)' 6 '21-25:(6)' 7 '26-30:(7)' 8 '31+:(8)' 9 'DK:(9)'
             /
   V7254     -9 'MISSING:(-9)' 1 'NO:(1)' 2 'YES SOME:(2)'
             3 'YES MOST/ALL:(3)' /
   V7259     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)'
             5 'ALL:(5)' /
   V7260     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)'
             5 'ALL:(5)' /
   V7261     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)'
             5 'ALL:(5)' /
   V7262     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'RARELY:(2)' 3 'SOMETIMES:(3)' 4 'MOST:(4)'
             5 'ALL:(5)' /
   V7565     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '<1 DAY/WK(1)' 2 '1 DAY/WK(2)' 3 '2 DAYS/WK(3)'
             4 '3 DAYS/WK(4)' 5 '4-5 DAYS/WK(5)' 6 '6-7 DAYS/WK(6)' /
   V7302     -9 'MISSING:(-9)' 1 'NT HAPPY:(1)' 2 'PRTY HPY:(2)'
             3 'VRY HPY:(3)' /
   V8512     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8502     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8505     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8509     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8514     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8536     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'MUCH BETR:(1)' 2 'SMWT BETR:(2)' 3 'SAME:(3)'
             4 'SMWT WRSE:(4)' 5 'MUCH WRSE:(5)' /
   V8501     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8504     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8508     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8503     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8507     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8511     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8513     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7501     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7502     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7504     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7505     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7507     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7508     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7503     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V7506     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8555     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8556     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8557     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8558     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8565     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V8566     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'DISAGREE:(1)' 2 'MOST DISAG:(2)' 3 'NEITHER:(3)'
             4 'MOST AGREE:(4)' 5 'AGREE:(5)' /
   V1252     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 '< 16 YRS:(1)' 2 '16 OR + YRS:(2)' /
   V7202     -9 'MISSING:(-9)' 1 'MALE:(1)' 2 'FEMALE:(2)' /
   V1070     -9 'MISSING:(-9)' 1 'BLACK:(1)' 2 'WHITE:(2)' 3 'HISPANIC:(3)' /
   V7215     -9 'MISSING:(-9)' 1 'GRDE SCH:(1)' 2 'SOME HS:(2)'
             3 'HS GRAD:(3)' 4 'SOME CLG:(4)' 5 'CLG GRAD:(5)'
             6 'GRAD SCH:(6)' 7 'DK:(7)' /
   V7216     -9 'MISSING:(-9)' 1 'GRDE SCH:(1)' 2 'SOME HS:(2)'
             3 'HS GRAD:(3)' 4 'SOME CLG:(4)' 5 'CLG GRAD:(5)'
             6 'GRAD SCH:(6)' 7 'DK:(7)' /
   V7217     -9 'MISSING:(-9)' 1 'NO:(1)' 2 'YES P/T:(2)' 3 'YES F/T:(3)' /
   V7206     -9 'MISSING:(-9)' 0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7207     -9 'MISSING:(-9)' 0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7208     -9 'MISSING:(-9)' 0 'NOT MARKED:(0)' 1 'MARKED:(1)' /
   V7205     -9 'MISSING:(-9)' 1 'FARM:(1)' 2 'COUNTRY:(2)' 3 'CITYTOWN:(3)'
             /
   V8517     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8518     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8519     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8520     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8521     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8523     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8515     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NONE:(1)' 2 'ONCE:(2)' 3 'TWICE:(3)' 4 '3-4TIMES:(4)'
             5 '5+ TIMES:(5)' /
   V8526     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'MST DAYS:(4)'
             5 'NR EV DA:(5)' 6 'EVERYDAY:(6)' /
   V8527     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'MST DAYS:(4)'
             5 'NR EV DA:(5)' 6 'EVERYDAY:(6)' /
   V8528     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'MST DAYS:(4)'
             5 'NR EV DA:(5)' 6 'EVERYDAY:(6)' /
   V8529     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'MST DAYS:(4)'
             5 'NR EV DA:(5)' 6 'EVERYDAY:(6)' /
   V8530     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'MST DAYS:(4)'
             5 'NR EV DA:(5)' 6 'EVERYDAY:(6)' /
   V8531     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             1 'NEVER:(1)' 2 'SELDOM:(2)' 3 'SOMETIME:(3)' 4 'MST DAYS:(4)'
             5 'NR EV DA:(5)' 6 'EVERYDAY:(6)' /
   V7555     -9 'MISSING:(-9)' -8 'NA: NOT ASKED ON THIS FORM:(-8)'
             0 '0 DAYS:(0)' 1 '1 DAY:(1)' 2 '2 DAYS:(2)' 3 '3 DAYS:(3)'
             4 '4 DAYS:(4)' 5 '5 DAYS:(5)' 6 '6 DAYS:(6)' 7 '7 DAYS:(7)' /
   V7101D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7102D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7105D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7106D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7107D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7112D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7113D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7114D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7115D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7116D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7117D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7118D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7119D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7120D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7127D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7128D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7129D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7097D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7098D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7099D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7133D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7134D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7135D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7142D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7143D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7144D    -9 'MISSING: (-9)' 0 'NO: (0)' 1 'YES: (1)' /
   V7139D    -9 'MISSING: (-9)' -8 'NA: NOT ASKED ON THIS FORM: (-8)'
             0 'NO: (0)' 1 'YES: (1)' /
   V7140D    -9 'MISSING: (-9)' -8 'NA: NOT ASKED ON THIS FORM: (-8)'
             0 'NO: (0)' 1 'YES: (1)' /
   V7141D    -9 'MISSING: (-9)' -8 'NA: NOT ASKED ON THIS FORM: (-8)'
             0 'NO: (0)' 1 'YES: (1)' /
   .

* SPSS MISSING VALUES COMMAND.

* MISSING VALUES
     V7101 (low thru -1) /
     V7104 (low thru -1) /
     V7105 (low thru -1) /
     V7112 (low thru -1) /
     V7115 (low thru -1) /
     V7118 (low thru -1) /
     V7127 (low thru -1) /
     V7097 (low thru -1) /
     V7133 (low thru -1) /
     V7139 (low thru -1) /
     V7142 (low thru -1) /
     V8451 (low thru -1) /
     V7426 (low thru -1) /
     V7121 (low thru -1) /
     V7124 (low thru -1) /
     V7164 (low thru -1) /
     V7145 (low thru -1) /
     V7109 (low thru -1) /
     V7152 (low thru -1) /
     V7155 (low thru -1) /
     V7158 (low thru -1) /
     V7161 (low thru -1) /
     V7601 (low thru -1) /
     V8480 (low thru -1) /
     V7106 (low thru -1) /
     V7113 (low thru -1) /
     V7116 (low thru -1) /
     V7119 (low thru -1) /
     V7128 (low thru -1) /
     V7098 (low thru -1) /
     V7134 (low thru -1) /
     V7140 (low thru -1) /
     V7143 (low thru -1) /
     V8452 (low thru -1) /
     V7122 (low thru -1) /
     V7125 (low thru -1) /
     V7165 (low thru -1) /
     V7146 (low thru -1) /
     V7110 (low thru -1) /
     V7153 (low thru -1) /
     V7156 (low thru -1) /
     V7159 (low thru -1) /
     V7162 (low thru -1) /
     V7602 (low thru -1) /
     V7487 (low thru -1) /
     V7488 (low thru -1) /
     V7489 (low thru -1) /
     V7491 (low thru -1) /
     V7492 (low thru -1) /
     V8481 (low thru -1) /
     V7495 (low thru -1) /
     V7554 (low thru -1) /
     V7561 (low thru -1) /
     V7564 (low thru -1) /
     V7566 (low thru -1) /
     V7568 (low thru -1) /
     V7569 (low thru -1) /
     V7567 (low thru -1) /
     V7102 (low thru -1) /
     V7107 (low thru -1) /
     V7114 (low thru -1) /
     V7117 (low thru -1) /
     V7120 (low thru -1) /
     V7129 (low thru -1) /
     V7099 (low thru -1) /
     V7135 (low thru -1) /
     V7141 (low thru -1) /
     V7144 (low thru -1) /
     V8453 (low thru -1) /
     V7427 (low thru -1) /
     V7123 (low thru -1) /
     V7126 (low thru -1) /
     V7166 (low thru -1) /
     V7147 (low thru -1) /
     V7111 (low thru -1) /
     V7154 (low thru -1) /
     V7157 (low thru -1) /
     V7160 (low thru -1) /
     V7163 (low thru -1) /
     V7603 (low thru -1) /
     V8482 (low thru -1) /
     V7108 (low thru -1) /
     V8454 (low thru -1) /
     V7442 (low thru -1) /
     V7441 (low thru -1) /
     V8413 (low thru -1) /
     V7443 (low thru -1) /
     V7444 (low thru -1) /
     V7445 (low thru -1) /
     V8417 (low thru -1) /
     V8418 (low thru -1) /
     V8419 (low thru -1) /
     V8483 (low thru -1) /
     V8421 (low thru -1) /
     V7446 (low thru -1) /
     V7447 (low thru -1) /
     V8424 (low thru -1) /
     V8425 (low thru -1) /
     V7448 (low thru -1) /
     V7449 (low thru -1) /
     V8564 (low thru -1) /
     V7548 (low thru -1) /
     V7103 (low thru -1) /
     V7180 (low thru -1) /
     V7181 (low thru -1) /
     V7475 (low thru -1) /
     V7476 (low thru -1) /
     V7477 (low thru -1) /
     V7478 (low thru -1) /
     V7479 (low thru -1) /
     V7480 (low thru -1) /
     V7547 (low thru -1) /
     V7549 (low thru -1) /
     V7550 (low thru -1) /
     V7176 (low thru -1) /
     V7587 (low thru -1) /
     V7557 (low thru -1) /
     V7558 (low thru -1) /
     V7559 (low thru -1) /
     V7560 (low thru -1) /
     V7428 (low thru -1) /
     V7432 (low thru -1) /
     V7433 (low thru -1) /
     V7435 (low thru -1) /
     V7430 (low thru -1) /
     V7431 (low thru -1) /
     V7434 (low thru -1) /
     V7429 (low thru -1) /
     V7436 (low thru -1) /
     V8473 (low thru -1) /
     V8474 (low thru -1) /
     V8475 (low thru -1) /
     V7437 (low thru -1) /
     V7438 (low thru -1) /
     V7439 (low thru -1) /
     V7440 (low thru -1) /
     V7414 (low thru -1) /
     V7415 (low thru -1) /
     V7416 (low thru -1) /
     V7417 (low thru -1) /
     V7494 (low thru -1) /
     V7419 (low thru -1) /
     V7420 (low thru -1) /
     V7421 (low thru -1) /
     V7422 (low thru -1) /
     V7423 (low thru -1) /
     V7412 (low thru -1) /
     V7413 (low thru -1) /
     V7490 (low thru -1) /
     V7425 (low thru -1) /
     V7424 (low thru -1) /
     V8544 (low thru -1) /
     V8477 (low thru -1) /
     V7167 (low thru -1) /
     V7168 (low thru -1) /
     V7169 (low thru -1) /
     V7170 (low thru -1) /
     V7171 (low thru -1) /
     V7172 (low thru -1) /
     V7173 (low thru -1) /
     V7174 (low thru -1) /
     V7175 (low thru -1) /
     V7177 (low thru -1) /
     V7178 (low thru -1) /
     V7179 (low thru -1) /
     V7199 (low thru -1) /
     V7200 (low thru -1) /
     V7185 (low thru -1) /
     V7458 (low thru -1) /
     V7186 (low thru -1) /
     V7187 (low thru -1) /
     V7188 (low thru -1) /
     V7184 (low thru -1) /
     V7451 (low thru -1) /
     V7452 (low thru -1) /
     V7453 (low thru -1) /
     V7454 (low thru -1) /
     V7455 (low thru -1) /
     V7456 (low thru -1) /
     V7457 (low thru -1) /
     V8441 (low thru -1) /
     V8442 (low thru -1) /
     V8443 (low thru -1) /
     V8444 (low thru -1) /
     V8445 (low thru -1) /
     V8446 (low thru -1) /
     V8447 (low thru -1) /
     V8476 (low thru -1) /
     V8540 (low thru -1) /
     V8541 (low thru -1) /
     V8542 (low thru -1) /
     V7481 (low thru -1) /
     V7183 (low thru -1) /
     V7459 (low thru -1) /
     V7460 (low thru -1) /
     V7461 (low thru -1) /
     V7462 (low thru -1) /
     V7463 (low thru -1) /
     V7464 (low thru -1) /
     V7465 (low thru -1) /
     V7466 (low thru -1) /
     V7467 (low thru -1) /
     V7468 (low thru -1) /
     V7469 (low thru -1) /
     V7470 (low thru -1) /
     V7471 (low thru -1) /
     V7472 (low thru -1) /
     V7473 (low thru -1) /
     V7474 (low thru -1) /
     V7182 (low thru -1) /
     V7403 (low thru -1) /
     V7404 (low thru -1) /
     V8455 (low thru -1) /
     V7405 (low thru -1) /
     V7406 (low thru -1) /
     V7407 (low thru -1) /
     V7408 (low thru -1) /
     V7409 (low thru -1) /
     V7410 (low thru -1) /
     V7411 (low thru -1) /
     V7482 (low thru -1) /
     V8401 (low thru -1) /
     V8402 (low thru -1) /
     V8403 (low thru -1) /
     V8404 (low thru -1) /
     V7701 (low thru -1) /
     V7702 (low thru -1) /
     V7703 (low thru -1) /
     V7704 (low thru -1) /
     V7705 (low thru -1) /
     V7714 (low thru -1) /
     V7715 (low thru -1) /
     V8478 (low thru -1) /
     V7570 (low thru -1) /
     V7344 (low thru -1) /
     V7345 (low thru -1) /
     V7346 (low thru -1) /
     V7347 (low thru -1) /
     V7348 (low thru -1) /
     V7349 (low thru -1) /
     V7350 (low thru -1) /
     V7351 (low thru -1) /
     V7352 (low thru -1) /
     V7353 (low thru -1) /
     V7354 (low thru -1) /
     V7355 (low thru -1) /
     V7356 (low thru -1) /
     V7357 (low thru -1) /
     V8547 (low thru -1) /
     V8548 (low thru -1) /
     V7540 (low thru -1) /
     V7541 (low thru -1) /
     V8562 (low thru -1) /
     V8563 (low thru -1) /
     V8456 (low thru -1) /
     V8457 (low thru -1) /
     V8458 (low thru -1) /
     V8459 (low thru -1) /
     V8460 (low thru -1) /
     V8461 (low thru -1) /
     V8462 (low thru -1) /
     V7718 (low thru -1) /
     V7716 (low thru -1) /
     V7717 (low thru -1) /
     V7719 (low thru -1) /
     V7720 (low thru -1) /
     V7721 (low thru -1) /
     V7359 (low thru -1) /
     V7360 (low thru -1) /
     V7361 (low thru -1) /
     V7362 (low thru -1) /
     V7363 (low thru -1) /
     V8545 (low thru -1) /
     V8546 (low thru -1) /
     V7364 (low thru -1) /
     V7365 (low thru -1) /
     V7366 (low thru -1) /
     V7367 (low thru -1) /
     V7368 (low thru -1) /
     V7369 (low thru -1) /
     V7370 (low thru -1) /
     V8560 (low thru -1) /
     V8561 (low thru -1) /
     V7371 (low thru -1) /
     V7372 (low thru -1) /
     V7542 (low thru -1) /
     V7543 (low thru -1) /
     V7377 (low thru -1) /
     V7577 (low thru -1) /
     V7578 (low thru -1) /
     V7571 (low thru -1) /
     V7572 (low thru -1) /
     V7573 (low thru -1) /
     V7574 (low thru -1) /
     V7575 (low thru -1) /
     V7576 (low thru -1) /
     V7579 (low thru -1) /
     V7580 (low thru -1) /
     V7581 (low thru -1) /
     V7582 (low thru -1) /
     V7583 (low thru -1) /
     V7584 (low thru -1) /
     V7585 (low thru -1) /
     V7586 (low thru -1) /
     V7710 (low thru -1) /
     V7711 (low thru -1) /
     V7712 (low thru -1) /
     V7713 (low thru -1) /
     V7706 (low thru -1) /
     V7707 (low thru -1) /
     V7708 (low thru -1) /
     V7709 (low thru -1) /
     V7189 (low thru -1) /
     V7190 (low thru -1) /
     V7191 (low thru -1) /
     V7192 (low thru -1) /
     V7193 (low thru -1) /
     V7194 (low thru -1) /
     V7195 (low thru -1) /
     V7196 (low thru -1) /
     V7197 (low thru -1) /
     V7198 (low thru -1) /
     V7222 (low thru -1) /
     V7221 (low thru -1) /
     V7223 (low thru -1) /
     V7327 (low thru -1) /
     V7516 (low thru -1) /
     V7517 (low thru -1) /
     V7518 (low thru -1) /
     V7519 (low thru -1) /
     V7329 (low thru -1) /
     V7330 (low thru -1) /
     V7331 (low thru -1) /
     V7332 (low thru -1) /
     V7334 (low thru -1) /
     V7335 (low thru -1) /
     V7232 (low thru -1) /
     V7233 (low thru -1) /
     V7301 (low thru -1) /
     V7333 (low thru -1) /
     V7251 (low thru -1) /
     V7252 (low thru -1) /
     V7384 (low thru -1) /
     V7385 (low thru -1) /
     V7386 (low thru -1) /
     V7496 (low thru -1) /
     V7497 (low thru -1) /
     V7387 (low thru -1) /
     V7498 (low thru -1) /
     V7388 (low thru -1) /
     V7389 (low thru -1) /
     V7499 (low thru -1) /
     V7390 (low thru -1) /
     V7391 (low thru -1) /
     V7392 (low thru -1) /
     V7393 (low thru -1) /
     V7394 (low thru -1) /
     V7395 (low thru -1) /
     V7396 (low thru -1) /
     V7397 (low thru -1) /
     V7500 (low thru -1) /
     V7398 (low thru -1) /
     V7399 (low thru -1) /
     V7400 (low thru -1) /
     V7556 (low thru -1) /
     V7522 (low thru -1) /
     V7523 (low thru -1) /
     V7524 (low thru -1) /
     V7525 (low thru -1) /
     V7526 (low thru -1) /
     V7527 (low thru -1) /
     V7528 (low thru -1) /
     V7529 (low thru -1) /
     V7530 (low thru -1) /
     V7531 (low thru -1) /
     V8537 (low thru -1) /
     V8538 (low thru -1) /
     V7537 (low thru -1) /
     V7253 (low thru -1) /
     V7228 (low thru -1) /
     V7229 (low thru -1) /
     V7230 (low thru -1) /
     V7231 (low thru -1) /
     V8539 (low thru -1) /
     V8516 (low thru -1) /
     V8522 (low thru -1) /
     V7509 (low thru -1) /
     V7510 (low thru -1) /
     V7511 (low thru -1) /
     V7512 (low thru -1) /
     V7513 (low thru -1) /
     V7514 (low thru -1) /
     V7515 (low thru -1) /
     V7234 (low thru -1) /
     V8543 (low thru -1) /
     V7534 (low thru -1) /
     V7535 (low thru -1) /
     V7536 (low thru -1) /
     V7538 (low thru -1) /
     V7224 (low thru -1) /
     V7225 (low thru -1) /
     V7227 (low thru -1) /
     V7226 (low thru -1) /
     V7235 (low thru -1) /
     V7238 (low thru -1) /
     V7236 (low thru -1) /
     V7237 (low thru -1) /
     V7374 (low thru -1) /
     V7240 (low thru -1) /
     V7309 (low thru -1) /
     V7310 (low thru -1) /
     V7311 (low thru -1) /
     V7312 (low thru -1) /
     V7313 (low thru -1) /
     V7378 (low thru -1) /
     V7379 (low thru -1) /
     V7380 (low thru -1) /
     V7319 (low thru -1) /
     V7325 (low thru -1) /
     V7317 (low thru -1) /
     V7318 (low thru -1) /
     V7320 (low thru -1) /
     V7321 (low thru -1) /
     V7322 (low thru -1) /
     V7323 (low thru -1) /
     V7381 (low thru -1) /
     V7324 (low thru -1) /
     V7326 (low thru -1) /
     V7214 (low thru -1) /
     V7239 (low thru -1) /
     V7539 (low thru -1) /
     V7552 (low thru -1) /
     V7544 (low thru -1) /
     V7545 (low thru -1) /
     V7546 (low thru -1) /
     V7551 (low thru -1) /
     V7553 (low thru -1) /
     V7562 (low thru -1) /
     V7563 (low thru -1) /
     V7341 (low thru -1) /
     V7343 (low thru -1) /
     V7532 (low thru -1) /
     V7533 (low thru -1) /
     V7339 (low thru -1) /
     V7340 (low thru -1) /
     V7401 (low thru -1) /
     V7402 (low thru -1) /
     V7219 (low thru -1) /
     V7220 (low thru -1) /
     V7255 (low thru -1) /
     V7241 (low thru -1) /
     V7242 (low thru -1) /
     V7243 (low thru -1) /
     V7244 (low thru -1) /
     V7258 (low thru -1) /
     V7375 (low thru -1) /
     V7254 (low thru -1) /
     V7259 (low thru -1) /
     V7260 (low thru -1) /
     V7261 (low thru -1) /
     V7262 (low thru -1) /
     V7565 (low thru -1) /
     V7302 (low thru -1) /
     V8512 (low thru -1) /
     V8502 (low thru -1) /
     V8505 (low thru -1) /
     V8509 (low thru -1) /
     V8514 (low thru -1) /
     V8536 (low thru -1) /
     V8501 (low thru -1) /
     V8504 (low thru -1) /
     V8508 (low thru -1) /
     V8503 (low thru -1) /
     V8507 (low thru -1) /
     V8511 (low thru -1) /
     V8513 (low thru -1) /
     V7501 (low thru -1) /
     V7502 (low thru -1) /
     V7504 (low thru -1) /
     V7505 (low thru -1) /
     V7507 (low thru -1) /
     V7508 (low thru -1) /
     V7503 (low thru -1) /
     V7506 (low thru -1) /
     V8555 (low thru -1) /
     V8556 (low thru -1) /
     V8557 (low thru -1) /
     V8558 (low thru -1) /
     V8565 (low thru -1) /
     V8566 (low thru -1) /
     V1252 (low thru -1) /
     V7202 (low thru -1) /
     V1070 (low thru -1) /
     V7215 (low thru -1) /
     V7216 (low thru -1) /
     V7217 (low thru -1) /
     V7206 (low thru -1) /
     V7207 (low thru -1) /
     V7208 (low thru -1) /
     V7205 (low thru -1) /
     V8517 (low thru -1) /
     V8518 (low thru -1) /
     V8519 (low thru -1) /
     V8520 (low thru -1) /
     V8521 (low thru -1) /
     V8523 (low thru -1) /
     V8515 (low thru -1) /
     V8526 (low thru -1) /
     V8527 (low thru -1) /
     V8528 (low thru -1) /
     V8529 (low thru -1) /
     V8530 (low thru -1) /
     V8531 (low thru -1) /
     V7555 (low thru -1) /
     V7101D (-9) /
     V7102D (-9) /
     V7105D (-9) /
     V7106D (-9) /
     V7107D (-9) /
     V7112D (-9) /
     V7113D (-9) /
     V7114D (-9) /
     V7115D (-9) /
     V7116D (-9) /
     V7117D (-9) /
     V7118D (-9) /
     V7119D (-9) /
     V7120D (-9) /
     V7127D (-9) /
     V7128D (-9) /
     V7129D (-9) /
     V7097D (-9) /
     V7098D (-9) /
     V7099D (-9) /
     V7133D (-9) /
     V7134D (-9) /
     V7135D (-9) /
     V7142D (-9) /
     V7143D (-9) /
     V7144D (-9) /
     V7139D (-9, -8) /
     V7140D (-9, -8) /
     V7141D (-9, -8) /
   .

EXECUTE.

* SPSS VARIABLE LEVEL COMMAND.

VARIABLE LEVEL
   CASEID
   V1
   V3
   V4
   V5
    (scale).

VARIABLE LEVEL
   V501
   V507
   V508
   V509
   V7101
   V7104
   V7105
   V7112
   V7115
   V7118
   V7127
   V7097
   V7133
   V7139
   V7142
   V8451
   V7426
   V7121
   V7124
   V7164
   V7145
   V7109
   V7152
   V7155
   V7158
   V7161
   V7601
   V8480
   V7106
   V7113
   V7116
   V7119
   V7128
   V7098
   V7134
   V7140
   V7143
   V8452
   V7122
   V7125
   V7165
   V7146
   V7110
   V7153
   V7156
   V7159
   V7162
   V7602
   V7487
   V7488
   V7489
   V7491
   V7492
   V8481
   V7495
   V7554
   V7561
   V7564
   V7566
   V7568
   V7569
   V7567
   V7102
   V7107
   V7114
   V7117
   V7120
   V7129
   V7099
   V7135
   V7141
   V7144
   V8453
   V7427
   V7123
   V7126
   V7166
   V7147
   V7111
   V7154
   V7157
   V7160
   V7163
   V7603
   V8482
   V7108
   V8454
   V7442
   V7441
   V8413
   V7443
   V7444
   V7445
   V8417
   V8418
   V8419
   V8483
   V8421
   V7446
   V7447
   V8424
   V8425
   V7448
   V7449
   V8564
   V7548
   V7103
   V7180
   V7181
   V7475
   V7476
   V7477
   V7478
   V7479
   V7480
   V7547
   V7549
   V7550
   V7176
   V7587
   V7557
   V7558
   V7559
   V7560
   V7428
   V7432
   V7433
   V7435
   V7430
   V7431
   V7434
   V7429
   V7436
   V8473
   V8474
   V8475
   V7437
   V7438
   V7439
   V7440
   V7414
   V7415
   V7416
   V7417
   V7494
   V7419
   V7420
   V7421
   V7422
   V7423
   V7412
   V7413
   V7490
   V7425
   V7424
   V8544
   V8477
   V7167
   V7168
   V7169
   V7170
   V7171
   V7172
   V7173
   V7174
   V7175
   V7177
   V7178
   V7179
   V7199
   V7200
   V7185
   V7458
   V7186
   V7187
   V7188
   V7184
   V7451
   V7452
   V7453
   V7454
   V7455
   V7456
   V7457
   V8441
   V8442
   V8443
   V8444
   V8445
   V8446
   V8447
   V8476
   V8540
   V8541
   V8542
   V7481
   V7183
   V7459
   V7460
   V7461
   V7462
   V7463
   V7464
   V7465
   V7466
   V7467
   V7468
   V7469
   V7470
   V7471
   V7472
   V7473
   V7474
   V7182
   V7403
   V7404
   V8455
   V7405
   V7406
   V7407
   V7408
   V7409
   V7410
   V7411
   V7482
   V8401
   V8402
   V8403
   V8404
   V7701
   V7702
   V7703
   V7704
   V7705
   V7714
   V7715
   V8478
   V7570
   V7344
   V7345
   V7346
   V7347
   V7348
   V7349
   V7350
   V7351
   V7352
   V7353
   V7354
   V7355
   V7356
   V7357
   V8547
   V8548
   V7540
   V7541
   V8562
   V8563
   V8456
   V8457
   V8458
   V8459
   V8460
   V8461
   V8462
   V7718
   V7716
   V7717
   V7719
   V7720
   V7721
   V7359
   V7360
   V7361
   V7362
   V7363
   V8545
   V8546
   V7364
   V7365
   V7366
   V7367
   V7368
   V7369
   V7370
   V8560
   V8561
   V7371
   V7372
   V7542
   V7543
   V7377
   V7577
   V7578
   V7571
   V7572
   V7573
   V7574
   V7575
   V7576
   V7579
   V7580
   V7581
   V7582
   V7583
   V7584
   V7585
   V7586
   V7710
   V7711
   V7712
   V7713
   V7706
   V7707
   V7708
   V7709
   V7189
   V7190
   V7191
   V7192
   V7193
   V7194
   V7195
   V7196
   V7197
   V7198
   V7222
   V7221
   V7223
   V7327
   V7516
   V7517
   V7518
   V7519
   V7329
   V7330
   V7331
   V7332
   V7334
   V7335
   V7232
   V7233
   V7301
   V7333
   V7251
   V7252
   V7384
   V7385
   V7386
   V7496
   V7497
   V7387
   V7498
   V7388
   V7389
   V7499
   V7390
   V7391
   V7392
   V7393
   V7394
   V7395
   V7396
   V7397
   V7500
   V7398
   V7399
   V7400
   V7556
   V7522
   V7523
   V7524
   V7525
   V7526
   V7527
   V7528
   V7529
   V7530
   V7531
   V8537
   V8538
   V7537
   V7253
   V7228
   V7229
   V7230
   V7231
   V8539
   V8516
   V8522
   V7509
   V7510
   V7511
   V7512
   V7513
   V7514
   V7515
   V7234
   V8543
   V7534
   V7535
   V7536
   V7538
   V7224
   V7225
   V7227
   V7226
   V7235
   V7238
   V7236
   V7237
   V7374
   V7240
   V7309
   V7310
   V7311
   V7312
   V7313
   V7378
   V7379
   V7380
   V7319
   V7325
   V7317
   V7318
   V7320
   V7321
   V7322
   V7323
   V7381
   V7324
   V7326
   V7214
   V7239
   V7539
   V7552
   V7544
   V7545
   V7546
   V7551
   V7553
   V7562
   V7563
   V7341
   V7343
   V7532
   V7533
   V7339
   V7340
   V7401
   V7402
   V7219
   V7220
   V7255
   V7241
   V7242
   V7243
   V7244
   V7258
   V7375
   V7254
   V7259
   V7260
   V7261
   V7262
   V7565
   V7302
   V8512
   V8502
   V8505
   V8509
   V8514
   V8536
   V8501
   V8504
   V8508
   V8503
   V8507
   V8511
   V8513
   V7501
   V7502
   V7504
   V7505
   V7507
   V7508
   V7503
   V7506
   V8555
   V8556
   V8557
   V8558
   V8565
   V8566
   V1252
   V7202
   V1070
   V7215
   V7216
   V7217
   V7206
   V7207
   V7208
   V7205
   V8517
   V8518
   V8519
   V8520
   V8521
   V8523
   V8515
   V8526
   V8527
   V8528
   V8529
   V8530
   V8531
   V7555
   V7101D
   V7102D
   V7105D
   V7106D
   V7107D
   V7112D
   V7113D
   V7114D
   V7115D
   V7116D
   V7117D
   V7118D
   V7119D
   V7120D
   V7127D
   V7128D
   V7129D
   V7097D
   V7098D
   V7099D
   V7133D
   V7134D
   V7135D
   V7142D
   V7143D
   V7144D
   V7139D
   V7140D
   V7141D
    (nominal).

* SPSS FORMAT COMMAND.

    CASEID (F5.0) /
    V1 (F4.0) /
    V3 (F1.0) /
    V4 (F5.0) /
    V5 (F15.13) /
    V501 (F2.0) /
    V507 (F1.0) /
    V508 (F1.0) /
    V509 (F1.0) /
    V7101 (F2.0) /
    V7104 (F2.0) /
    V7105 (F2.0) /
    V7112 (F2.0) /
    V7115 (F2.0) /
    V7118 (F2.0) /
    V7127 (F2.0) /
    V7097 (F2.0) /
    V7133 (F2.0) /
    V7139 (F2.0) /
    V7142 (F2.0) /
    V8451 (F2.0) /
    V7426 (F2.0) /
    V7121 (F2.0) /
    V7124 (F2.0) /
    V7164 (F2.0) /
    V7145 (F2.0) /
    V7109 (F2.0) /
    V7152 (F2.0) /
    V7155 (F2.0) /
    V7158 (F2.0) /
    V7161 (F2.0) /
    V7601 (F2.0) /
    V8480 (F2.0) /
    V7106 (F2.0) /
    V7113 (F2.0) /
    V7116 (F2.0) /
    V7119 (F2.0) /
    V7128 (F2.0) /
    V7098 (F2.0) /
    V7134 (F2.0) /
    V7140 (F2.0) /
    V7143 (F2.0) /
    V8452 (F2.0) /
    V7122 (F2.0) /
    V7125 (F2.0) /
    V7165 (F2.0) /
    V7146 (F2.0) /
    V7110 (F2.0) /
    V7153 (F2.0) /
    V7156 (F2.0) /
    V7159 (F2.0) /
    V7162 (F2.0) /
    V7602 (F2.0) /
    V7487 (F2.0) /
    V7488 (F2.0) /
    V7489 (F2.0) /
    V7491 (F2.0) /
    V7492 (F2.0) /
    V8481 (F2.0) /
    V7495 (F2.0) /
    V7554 (F2.0) /
    V7561 (F2.0) /
    V7564 (F2.0) /
    V7566 (F2.0) /
    V7568 (F2.0) /
    V7569 (F2.0) /
    V7567 (F2.0) /
    V7102 (F2.0) /
    V7107 (F2.0) /
    V7114 (F2.0) /
    V7117 (F2.0) /
    V7120 (F2.0) /
    V7129 (F2.0) /
    V7099 (F2.0) /
    V7135 (F2.0) /
    V7141 (F2.0) /
    V7144 (F2.0) /
    V8453 (F2.0) /
    V7427 (F2.0) /
    V7123 (F2.0) /
    V7126 (F2.0) /
    V7166 (F2.0) /
    V7147 (F2.0) /
    V7111 (F2.0) /
    V7154 (F2.0) /
    V7157 (F2.0) /
    V7160 (F2.0) /
    V7163 (F2.0) /
    V7603 (F2.0) /
    V8482 (F2.0) /
    V7108 (F2.0) /
    V8454 (F2.0) /
    V7442 (F2.0) /
    V7441 (F2.0) /
    V8413 (F2.0) /
    V7443 (F2.0) /
    V7444 (F2.0) /
    V7445 (F2.0) /
    V8417 (F2.0) /
    V8418 (F2.0) /
    V8419 (F2.0) /
    V8483 (F2.0) /
    V8421 (F2.0) /
    V7446 (F2.0) /
    V7447 (F2.0) /
    V8424 (F2.0) /
    V8425 (F2.0) /
    V7448 (F2.0) /
    V7449 (F2.0) /
    V8564 (F2.0) /
    V7548 (F2.0) /
    V7103 (F2.0) /
    V7180 (F2.0) /
    V7181 (F2.0) /
    V7475 (F2.0) /
    V7476 (F2.0) /
    V7477 (F2.0) /
    V7478 (F2.0) /
    V7479 (F2.0) /
    V7480 (F2.0) /
    V7547 (F2.0) /
    V7549 (F2.0) /
    V7550 (F2.0) /
    V7176 (F2.0) /
    V7587 (F2.0) /
    V7557 (F2.0) /
    V7558 (F2.0) /
    V7559 (F2.0) /
    V7560 (F2.0) /
    V7428 (F2.0) /
    V7432 (F2.0) /
    V7433 (F2.0) /
    V7435 (F2.0) /
    V7430 (F2.0) /
    V7431 (F2.0) /
    V7434 (F2.0) /
    V7429 (F2.0) /
    V7436 (F2.0) /
    V8473 (F2.0) /
    V8474 (F2.0) /
    V8475 (F2.0) /
    V7437 (F2.0) /
    V7438 (F2.0) /
    V7439 (F2.0) /
    V7440 (F2.0) /
    V7414 (F2.0) /
    V7415 (F2.0) /
    V7416 (F2.0) /
    V7417 (F2.0) /
    V7494 (F2.0) /
    V7419 (F2.0) /
    V7420 (F2.0) /
    V7421 (F2.0) /
    V7422 (F2.0) /
    V7423 (F2.0) /
    V7412 (F2.0) /
    V7413 (F2.0) /
    V7490 (F2.0) /
    V7425 (F2.0) /
    V7424 (F2.0) /
    V8544 (F2.0) /
    V8477 (F2.0) /
    V7167 (F2.0) /
    V7168 (F2.0) /
    V7169 (F2.0) /
    V7170 (F2.0) /
    V7171 (F2.0) /
    V7172 (F2.0) /
    V7173 (F2.0) /
    V7174 (F2.0) /
    V7175 (F2.0) /
    V7177 (F2.0) /
    V7178 (F2.0) /
    V7179 (F2.0) /
    V7199 (F2.0) /
    V7200 (F2.0) /
    V7185 (F2.0) /
    V7458 (F2.0) /
    V7186 (F2.0) /
    V7187 (F2.0) /
    V7188 (F2.0) /
    V7184 (F2.0) /
    V7451 (F2.0) /
    V7452 (F2.0) /
    V7453 (F2.0) /
    V7454 (F2.0) /
    V7455 (F2.0) /
    V7456 (F2.0) /
    V7457 (F2.0) /
    V8441 (F2.0) /
    V8442 (F2.0) /
    V8443 (F2.0) /
    V8444 (F2.0) /
    V8445 (F2.0) /
    V8446 (F2.0) /
    V8447 (F2.0) /
    V8476 (F2.0) /
    V8540 (F2.0) /
    V8541 (F2.0) /
    V8542 (F2.0) /
    V7481 (F2.0) /
    V7183 (F2.0) /
    V7459 (F2.0) /
    V7460 (F2.0) /
    V7461 (F2.0) /
    V7462 (F2.0) /
    V7463 (F2.0) /
    V7464 (F2.0) /
    V7465 (F2.0) /
    V7466 (F2.0) /
    V7467 (F2.0) /
    V7468 (F2.0) /
    V7469 (F2.0) /
    V7470 (F2.0) /
    V7471 (F2.0) /
    V7472 (F2.0) /
    V7473 (F2.0) /
    V7474 (F2.0) /
    V7182 (F2.0) /
    V7403 (F2.0) /
    V7404 (F2.0) /
    V8455 (F2.0) /
    V7405 (F2.0) /
    V7406 (F2.0) /
    V7407 (F2.0) /
    V7408 (F2.0) /
    V7409 (F2.0) /
    V7410 (F2.0) /
    V7411 (F2.0) /
    V7482 (F2.0) /
    V8401 (F2.0) /
    V8402 (F2.0) /
    V8403 (F2.0) /
    V8404 (F2.0) /
    V7701 (F2.0) /
    V7702 (F2.0) /
    V7703 (F2.0) /
    V7704 (F2.0) /
    V7705 (F2.0) /
    V7714 (F2.0) /
    V7715 (F2.0) /
    V8478 (F2.0) /
    V7570 (F2.0) /
    V7344 (F2.0) /
    V7345 (F2.0) /
    V7346 (F2.0) /
    V7347 (F2.0) /
    V7348 (F2.0) /
    V7349 (F2.0) /
    V7350 (F2.0) /
    V7351 (F2.0) /
    V7352 (F2.0) /
    V7353 (F2.0) /
    V7354 (F2.0) /
    V7355 (F2.0) /
    V7356 (F2.0) /
    V7357 (F2.0) /
    V8547 (F2.0) /
    V8548 (F2.0) /
    V7540 (F2.0) /
    V7541 (F2.0) /
    V8562 (F2.0) /
    V8563 (F2.0) /
    V8456 (F2.0) /
    V8457 (F2.0) /
    V8458 (F2.0) /
    V8459 (F2.0) /
    V8460 (F2.0) /
    V8461 (F2.0) /
    V8462 (F2.0) /
    V7718 (F2.0) /
    V7716 (F2.0) /
    V7717 (F2.0) /
    V7719 (F2.0) /
    V7720 (F2.0) /
    V7721 (F2.0) /
    V7359 (F2.0) /
    V7360 (F2.0) /
    V7361 (F2.0) /
    V7362 (F2.0) /
    V7363 (F2.0) /
    V8545 (F2.0) /
    V8546 (F2.0) /
    V7364 (F2.0) /
    V7365 (F2.0) /
    V7366 (F2.0) /
    V7367 (F2.0) /
    V7368 (F2.0) /
    V7369 (F2.0) /
    V7370 (F2.0) /
    V8560 (F2.0) /
    V8561 (F2.0) /
    V7371 (F2.0) /
    V7372 (F2.0) /
    V7542 (F2.0) /
    V7543 (F2.0) /
    V7377 (F2.0) /
    V7577 (F2.0) /
    V7578 (F2.0) /
    V7571 (F2.0) /
    V7572 (F2.0) /
    V7573 (F2.0) /
    V7574 (F2.0) /
    V7575 (F2.0) /
    V7576 (F2.0) /
    V7579 (F2.0) /
    V7580 (F2.0) /
    V7581 (F2.0) /
    V7582 (F2.0) /
    V7583 (F2.0) /
    V7584 (F2.0) /
    V7585 (F2.0) /
    V7586 (F2.0) /
    V7710 (F2.0) /
    V7711 (F2.0) /
    V7712 (F2.0) /
    V7713 (F2.0) /
    V7706 (F2.0) /
    V7707 (F2.0) /
    V7708 (F2.0) /
    V7709 (F2.0) /
    V7189 (F2.0) /
    V7190 (F2.0) /
    V7191 (F2.0) /
    V7192 (F2.0) /
    V7193 (F2.0) /
    V7194 (F2.0) /
    V7195 (F2.0) /
    V7196 (F2.0) /
    V7197 (F2.0) /
    V7198 (F2.0) /
    V7222 (F2.0) /
    V7221 (F2.0) /
    V7223 (F2.0) /
    V7327 (F2.0) /
    V7516 (F2.0) /
    V7517 (F2.0) /
    V7518 (F2.0) /
    V7519 (F2.0) /
    V7329 (F2.0) /
    V7330 (F2.0) /
    V7331 (F2.0) /
    V7332 (F2.0) /
    V7334 (F2.0) /
    V7335 (F2.0) /
    V7232 (F2.0) /
    V7233 (F2.0) /
    V7301 (F2.0) /
    V7333 (F2.0) /
    V7251 (F2.0) /
    V7252 (F2.0) /
    V7384 (F2.0) /
    V7385 (F2.0) /
    V7386 (F2.0) /
    V7496 (F2.0) /
    V7497 (F2.0) /
    V7387 (F2.0) /
    V7498 (F2.0) /
    V7388 (F2.0) /
    V7389 (F2.0) /
    V7499 (F2.0) /
    V7390 (F2.0) /
    V7391 (F2.0) /
    V7392 (F2.0) /
    V7393 (F2.0) /
    V7394 (F2.0) /
    V7395 (F2.0) /
    V7396 (F2.0) /
    V7397 (F2.0) /
    V7500 (F2.0) /
    V7398 (F2.0) /
    V7399 (F2.0) /
    V7400 (F2.0) /
    V7556 (F2.0) /
    V7522 (F2.0) /
    V7523 (F2.0) /
    V7524 (F2.0) /
    V7525 (F2.0) /
    V7526 (F2.0) /
    V7527 (F2.0) /
    V7528 (F2.0) /
    V7529 (F2.0) /
    V7530 (F2.0) /
    V7531 (F2.0) /
    V8537 (F2.0) /
    V8538 (F2.0) /
    V7537 (F2.0) /
    V7253 (F2.0) /
    V7228 (F2.0) /
    V7229 (F2.0) /
    V7230 (F2.0) /
    V7231 (F2.0) /
    V8539 (F2.0) /
    V8516 (F2.0) /
    V8522 (F2.0) /
    V7509 (F2.0) /
    V7510 (F2.0) /
    V7511 (F2.0) /
    V7512 (F2.0) /
    V7513 (F2.0) /
    V7514 (F2.0) /
    V7515 (F2.0) /
    V7234 (F2.0) /
    V8543 (F2.0) /
    V7534 (F2.0) /
    V7535 (F2.0) /
    V7536 (F2.0) /
    V7538 (F2.0) /
    V7224 (F2.0) /
    V7225 (F2.0) /
    V7227 (F2.0) /
    V7226 (F2.0) /
    V7235 (F2.0) /
    V7238 (F2.0) /
    V7236 (F2.0) /
    V7237 (F2.0) /
    V7374 (F2.0) /
    V7240 (F2.0) /
    V7309 (F2.0) /
    V7310 (F2.0) /
    V7311 (F2.0) /
    V7312 (F2.0) /
    V7313 (F2.0) /
    V7378 (F2.0) /
    V7379 (F2.0) /
    V7380 (F2.0) /
    V7319 (F2.0) /
    V7325 (F2.0) /
    V7317 (F2.0) /
    V7318 (F2.0) /
    V7320 (F2.0) /
    V7321 (F2.0) /
    V7322 (F2.0) /
    V7323 (F2.0) /
    V7381 (F2.0) /
    V7324 (F2.0) /
    V7326 (F2.0) /
    V7214 (F2.0) /
    V7239 (F2.0) /
    V7539 (F2.0) /
    V7552 (F2.0) /
    V7544 (F2.0) /
    V7545 (F2.0) /
    V7546 (F2.0) /
    V7551 (F2.0) /
    V7553 (F2.0) /
    V7562 (F2.0) /
    V7563 (F2.0) /
    V7341 (F2.0) /
    V7343 (F2.0) /
    V7532 (F2.0) /
    V7533 (F2.0) /
    V7339 (F2.0) /
    V7340 (F2.0) /
    V7401 (F2.0) /
    V7402 (F2.0) /
    V7219 (F2.0) /
    V7220 (F2.0) /
    V7255 (F2.0) /
    V7241 (F2.0) /
    V7242 (F2.0) /
    V7243 (F2.0) /
    V7244 (F2.0) /
    V7258 (F2.0) /
    V7375 (F2.0) /
    V7254 (F2.0) /
    V7259 (F2.0) /
    V7260 (F2.0) /
    V7261 (F2.0) /
    V7262 (F2.0) /
    V7565 (F2.0) /
    V7302 (F2.0) /
    V8512 (F2.0) /
    V8502 (F2.0) /
    V8505 (F2.0) /
    V8509 (F2.0) /
    V8514 (F2.0) /
    V8536 (F2.0) /
    V8501 (F2.0) /
    V8504 (F2.0) /
    V8508 (F2.0) /
    V8503 (F2.0) /
    V8507 (F2.0) /
    V8511 (F2.0) /
    V8513 (F2.0) /
    V7501 (F2.0) /
    V7502 (F2.0) /
    V7504 (F2.0) /
    V7505 (F2.0) /
    V7507 (F2.0) /
    V7508 (F2.0) /
    V7503 (F2.0) /
    V7506 (F2.0) /
    V8555 (F2.0) /
    V8556 (F2.0) /
    V8557 (F2.0) /
    V8558 (F2.0) /
    V8565 (F2.0) /
    V8566 (F2.0) /
    V1252 (F2.0) /
    V7202 (F2.0) /
    V1070 (F2.0) /
    V7215 (F2.0) /
    V7216 (F2.0) /
    V7217 (F2.0) /
    V7206 (F2.0) /
    V7207 (F2.0) /
    V7208 (F2.0) /
    V7205 (F2.0) /
    V8517 (F2.0) /
    V8518 (F2.0) /
    V8519 (F2.0) /
    V8520 (F2.0) /
    V8521 (F2.0) /
    V8523 (F2.0) /
    V8515 (F2.0) /
    V8526 (F2.0) /
    V8527 (F2.0) /
    V8528 (F2.0) /
    V8529 (F2.0) /
    V8530 (F2.0) /
    V8531 (F2.0) /
    V7555 (F2.0) /
    V7101D (F2.0) /
    V7102D (F2.0) /
    V7105D (F2.0) /
    V7106D (F2.0) /
    V7107D (F2.0) /
    V7112D (F2.0) /
    V7113D (F2.0) /
    V7114D (F2.0) /
    V7115D (F2.0) /
    V7116D (F2.0) /
    V7117D (F2.0) /
    V7118D (F2.0) /
    V7119D (F2.0) /
    V7120D (F2.0) /
    V7127D (F2.0) /
    V7128D (F2.0) /
    V7129D (F2.0) /
    V7097D (F2.0) /
    V7098D (F2.0) /
    V7099D (F2.0) /
    V7133D (F2.0) /
    V7134D (F2.0) /
    V7135D (F2.0) /
    V7142D (F2.0) /
    V7143D (F2.0) /
    V7144D (F2.0) /
    V7139D (F2.0) /
    V7140D (F2.0) /
    V7141D (F2.0) /

* SPSS PRINT FORMAT COMMAND.

PRINT FORMAT
   CASEID (F5)
   V1 (F4)
   V3 (F1)
   V4 (F5)
   V5 (F6.4)
   V501 (F2)
   V507 (F1)
   V508 (F1)
   V509 (F1)
   V7101 (F2)
   V7104 (F2)
   V7105 (F2)
   V7112 (F2)
   V7115 (F2)
   V7118 (F2)
   V7127 (F2)
   V7097 (F2)
   V7133 (F2)
   V7139 (F2)
   V7142 (F2)
   V8451 (F2)
   V7426 (F2)
   V7121 (F2)
   V7124 (F2)
   V7164 (F2)
   V7145 (F2)
   V7109 (F2)
   V7152 (F2)
   V7155 (F2)
   V7158 (F2)
   V7161 (F2)
   V7601 (F2)
   V8480 (F2)
   V7106 (F2)
   V7113 (F2)
   V7116 (F2)
   V7119 (F2)
   V7128 (F2)
   V7098 (F2)
   V7134 (F2)
   V7140 (F2)
   V7143 (F2)
   V8452 (F2)
   V7122 (F2)
   V7125 (F2)
   V7165 (F2)
   V7146 (F2)
   V7110 (F2)
   V7153 (F2)
   V7156 (F2)
   V7159 (F2)
   V7162 (F2)
   V7602 (F2)
   V7487 (F2)
   V7488 (F2)
   V7489 (F2)
   V7491 (F2)
   V7492 (F2)
   V8481 (F2)
   V7495 (F2)
   V7554 (F2)
   V7561 (F2)
   V7564 (F2)
   V7566 (F2)
   V7568 (F2)
   V7569 (F2)
   V7567 (F2)
   V7102 (F2)
   V7107 (F2)
   V7114 (F2)
   V7117 (F2)
   V7120 (F2)
   V7129 (F2)
   V7099 (F2)
   V7135 (F2)
   V7141 (F2)
   V7144 (F2)
   V8453 (F2)
   V7427 (F2)
   V7123 (F2)
   V7126 (F2)
   V7166 (F2)
   V7147 (F2)
   V7111 (F2)
   V7154 (F2)
   V7157 (F2)
   V7160 (F2)
   V7163 (F2)
   V7603 (F2)
   V8482 (F2)
   V7108 (F2)
   V8454 (F2)
   V7442 (F2)
   V7441 (F2)
   V8413 (F2)
   V7443 (F2)
   V7444 (F2)
   V7445 (F2)
   V8417 (F2)
   V8418 (F2)
   V8419 (F2)
   V8483 (F2)
   V8421 (F2)
   V7446 (F2)
   V7447 (F2)
   V8424 (F2)
   V8425 (F2)
   V7448 (F2)
   V7449 (F2)
   V8564 (F2)
   V7548 (F2)
   V7103 (F2)
   V7180 (F2)
   V7181 (F2)
   V7475 (F2)
   V7476 (F2)
   V7477 (F2)
   V7478 (F2)
   V7479 (F2)
   V7480 (F2)
   V7547 (F2)
   V7549 (F2)
   V7550 (F2)
   V7176 (F2)
   V7587 (F2)
   V7557 (F2)
   V7558 (F2)
   V7559 (F2)
   V7560 (F2)
   V7428 (F2)
   V7432 (F2)
   V7433 (F2)
   V7435 (F2)
   V7430 (F2)
   V7431 (F2)
   V7434 (F2)
   V7429 (F2)
   V7436 (F2)
   V8473 (F2)
   V8474 (F2)
   V8475 (F2)
   V7437 (F2)
   V7438 (F2)
   V7439 (F2)
   V7440 (F2)
   V7414 (F2)
   V7415 (F2)
   V7416 (F2)
   V7417 (F2)
   V7494 (F2)
   V7419 (F2)
   V7420 (F2)
   V7421 (F2)
   V7422 (F2)
   V7423 (F2)
   V7412 (F2)
   V7413 (F2)
   V7490 (F2)
   V7425 (F2)
   V7424 (F2)
   V8544 (F2)
   V8477 (F2)
   V7167 (F2)
   V7168 (F2)
   V7169 (F2)
   V7170 (F2)
   V7171 (F2)
   V7172 (F2)
   V7173 (F2)
   V7174 (F2)
   V7175 (F2)
   V7177 (F2)
   V7178 (F2)
   V7179 (F2)
   V7199 (F2)
   V7200 (F2)
   V7185 (F2)
   V7458 (F2)
   V7186 (F2)
   V7187 (F2)
   V7188 (F2)
   V7184 (F2)
   V7451 (F2)
   V7452 (F2)
   V7453 (F2)
   V7454 (F2)
   V7455 (F2)
   V7456 (F2)
   V7457 (F2)
   V8441 (F2)
   V8442 (F2)
   V8443 (F2)
   V8444 (F2)
   V8445 (F2)
   V8446 (F2)
   V8447 (F2)
   V8476 (F2)
   V8540 (F2)
   V8541 (F2)
   V8542 (F2)
   V7481 (F2)
   V7183 (F2)
   V7459 (F2)
   V7460 (F2)
   V7461 (F2)
   V7462 (F2)
   V7463 (F2)
   V7464 (F2)
   V7465 (F2)
   V7466 (F2)
   V7467 (F2)
   V7468 (F2)
   V7469 (F2)
   V7470 (F2)
   V7471 (F2)
   V7472 (F2)
   V7473 (F2)
   V7474 (F2)
   V7182 (F2)
   V7403 (F2)
   V7404 (F2)
   V8455 (F2)
   V7405 (F2)
   V7406 (F2)
   V7407 (F2)
   V7408 (F2)
   V7409 (F2)
   V7410 (F2)
   V7411 (F2)
   V7482 (F2)
   V8401 (F2)
   V8402 (F2)
   V8403 (F2)
   V8404 (F2)
   V7701 (F2)
   V7702 (F2)
   V7703 (F2)
   V7704 (F2)
   V7705 (F2)
   V7714 (F2)
   V7715 (F2)
   V8478 (F2)
   V7570 (F2)
   V7344 (F2)
   V7345 (F2)
   V7346 (F2)
   V7347 (F2)
   V7348 (F2)
   V7349 (F2)
   V7350 (F2)
   V7351 (F2)
   V7352 (F2)
   V7353 (F2)
   V7354 (F2)
   V7355 (F2)
   V7356 (F2)
   V7357 (F2)
   V8547 (F2)
   V8548 (F2)
   V7540 (F2)
   V7541 (F2)
   V8562 (F2)
   V8563 (F2)
   V8456 (F2)
   V8457 (F2)
   V8458 (F2)
   V8459 (F2)
   V8460 (F2)
   V8461 (F2)
   V8462 (F2)
   V7718 (F2)
   V7716 (F2)
   V7717 (F2)
   V7719 (F2)
   V7720 (F2)
   V7721 (F2)
   V7359 (F2)
   V7360 (F2)
   V7361 (F2)
   V7362 (F2)
   V7363 (F2)
   V8545 (F2)
   V8546 (F2)
   V7364 (F2)
   V7365 (F2)
   V7366 (F2)
   V7367 (F2)
   V7368 (F2)
   V7369 (F2)
   V7370 (F2)
   V8560 (F2)
   V8561 (F2)
   V7371 (F2)
   V7372 (F2)
   V7542 (F2)
   V7543 (F2)
   V7377 (F2)
   V7577 (F2)
   V7578 (F2)
   V7571 (F2)
   V7572 (F2)
   V7573 (F2)
   V7574 (F2)
   V7575 (F2)
   V7576 (F2)
   V7579 (F2)
   V7580 (F2)
   V7581 (F2)
   V7582 (F2)
   V7583 (F2)
   V7584 (F2)
   V7585 (F2)
   V7586 (F2)
   V7710 (F2)
   V7711 (F2)
   V7712 (F2)
   V7713 (F2)
   V7706 (F2)
   V7707 (F2)
   V7708 (F2)
   V7709 (F2)
   V7189 (F2)
   V7190 (F2)
   V7191 (F2)
   V7192 (F2)
   V7193 (F2)
   V7194 (F2)
   V7195 (F2)
   V7196 (F2)
   V7197 (F2)
   V7198 (F2)
   V7222 (F2)
   V7221 (F2)
   V7223 (F2)
   V7327 (F2)
   V7516 (F2)
   V7517 (F2)
   V7518 (F2)
   V7519 (F2)
   V7329 (F2)
   V7330 (F2)
   V7331 (F2)
   V7332 (F2)
   V7334 (F2)
   V7335 (F2)
   V7232 (F2)
   V7233 (F2)
   V7301 (F2)
   V7333 (F2)
   V7251 (F2)
   V7252 (F2)
   V7384 (F2)
   V7385 (F2)
   V7386 (F2)
   V7496 (F2)
   V7497 (F2)
   V7387 (F2)
   V7498 (F2)
   V7388 (F2)
   V7389 (F2)
   V7499 (F2)
   V7390 (F2)
   V7391 (F2)
   V7392 (F2)
   V7393 (F2)
   V7394 (F2)
   V7395 (F2)
   V7396 (F2)
   V7397 (F2)
   V7500 (F2)
   V7398 (F2)
   V7399 (F2)
   V7400 (F2)
   V7556 (F2)
   V7522 (F2)
   V7523 (F2)
   V7524 (F2)
   V7525 (F2)
   V7526 (F2)
   V7527 (F2)
   V7528 (F2)
   V7529 (F2)
   V7530 (F2)
   V7531 (F2)
   V8537 (F2)
   V8538 (F2)
   V7537 (F2)
   V7253 (F2)
   V7228 (F2)
   V7229 (F2)
   V7230 (F2)
   V7231 (F2)
   V8539 (F2)
   V8516 (F2)
   V8522 (F2)
   V7509 (F2)
   V7510 (F2)
   V7511 (F2)
   V7512 (F2)
   V7513 (F2)
   V7514 (F2)
   V7515 (F2)
   V7234 (F2)
   V8543 (F2)
   V7534 (F2)
   V7535 (F2)
   V7536 (F2)
   V7538 (F2)
   V7224 (F2)
   V7225 (F2)
   V7227 (F2)
   V7226 (F2)
   V7235 (F2)
   V7238 (F2)
   V7236 (F2)
   V7237 (F2)
   V7374 (F2)
   V7240 (F2)
   V7309 (F2)
   V7310 (F2)
   V7311 (F2)
   V7312 (F2)
   V7313 (F2)
   V7378 (F2)
   V7379 (F2)
   V7380 (F2)
   V7319 (F2)
   V7325 (F2)
   V7317 (F2)
   V7318 (F2)
   V7320 (F2)
   V7321 (F2)
   V7322 (F2)
   V7323 (F2)
   V7381 (F2)
   V7324 (F2)
   V7326 (F2)
   V7214 (F2)
   V7239 (F2)
   V7539 (F2)
   V7552 (F2)
   V7544 (F2)
   V7545 (F2)
   V7546 (F2)
   V7551 (F2)
   V7553 (F2)
   V7562 (F2)
   V7563 (F2)
   V7341 (F2)
   V7343 (F2)
   V7532 (F2)
   V7533 (F2)
   V7339 (F2)
   V7340 (F2)
   V7401 (F2)
   V7402 (F2)
   V7219 (F2)
   V7220 (F2)
   V7255 (F2)
   V7241 (F2)
   V7242 (F2)
   V7243 (F2)
   V7244 (F2)
   V7258 (F2)
   V7375 (F2)
   V7254 (F2)
   V7259 (F2)
   V7260 (F2)
   V7261 (F2)
   V7262 (F2)
   V7565 (F2)
   V7302 (F2)
   V8512 (F2)
   V8502 (F2)
   V8505 (F2)
   V8509 (F2)
   V8514 (F2)
   V8536 (F2)
   V8501 (F2)
   V8504 (F2)
   V8508 (F2)
   V8503 (F2)
   V8507 (F2)
   V8511 (F2)
   V8513 (F2)
   V7501 (F2)
   V7502 (F2)
   V7504 (F2)
   V7505 (F2)
   V7507 (F2)
   V7508 (F2)
   V7503 (F2)
   V7506 (F2)
   V8555 (F2)
   V8556 (F2)
   V8557 (F2)
   V8558 (F2)
   V8565 (F2)
   V8566 (F2)
   V1252 (F2)
   V7202 (F2)
   V1070 (F2)
   V7215 (F2)
   V7216 (F2)
   V7217 (F2)
   V7206 (F2)
   V7207 (F2)
   V7208 (F2)
   V7205 (F2)
   V8517 (F2)
   V8518 (F2)
   V8519 (F2)
   V8520 (F2)
   V8521 (F2)
   V8523 (F2)
   V8515 (F2)
   V8526 (F2)
   V8527 (F2)
   V8528 (F2)
   V8529 (F2)
   V8530 (F2)
   V8531 (F2)
   V7555 (F2)
   V7101D (F2)
   V7102D (F2)
   V7105D (F2)
   V7106D (F2)
   V7107D (F2)
   V7112D (F2)
   V7113D (F2)
   V7114D (F2)
   V7115D (F2)
   V7116D (F2)
   V7117D (F2)
   V7118D (F2)
   V7119D (F2)
   V7120D (F2)
   V7127D (F2)
   V7128D (F2)
   V7129D (F2)
   V7097D (F2)
   V7098D (F2)
   V7099D (F2)
   V7133D (F2)
   V7134D (F2)
   V7135D (F2)
   V7142D (F2)
   V7143D (F2)
   V7144D (F2)
   V7139D (F2)
   V7140D (F2)
   V7141D (F2)
  .

* Create SPSS system file.

*SAVE OUTFILE="spss-filename.sav".
