/*
 * Decompiled with CFR 0.152.
 */
package edu.dtulnu.stat.brpts.rect;

import edu.dtulnu.stat.brpts.rect.BreakPointsMinMaxDriver;
import edu.dtulnu.stat.brpts.rect.EAParameterset;
import edu.dtulnu.stat.brpts.rect.SolutionString;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Vector;

public class EvolutionaryAlgoMinMax {
    private int noOfStrings;
    private Vector<SolutionString> solStrings;
    private SolutionString bestSolution;
    private double[] data;
    private int N;
    private int startNoOfBPs;
    private int maxNoOfBPs;
    private double totalArea;
    private int[] breakPoints;
    private double[][] result;
    private int minDistBtwBPs;
    private boolean debugflag = false;
    private int selType = 1;
    private double one_pt_cross_prob;
    private double uniform_cross_prob;
    private double mutation_prob;
    private double mutation_prob_per_index;
    private double bestFitness;
    private int bestIteration;
    private int lastImprovment;
    private int noOfMut;
    private int noOf1PtCo;
    private int noOfUnifCo;
    private int iterUsed;
    private BreakPointsMinMaxDriver driver;
    private DecimalFormat df = new DecimalFormat("00.0000");

    public EvolutionaryAlgoMinMax(EAParameterset eaParams, BreakPointsMinMaxDriver driver) {
        this.noOfStrings = eaParams.getNoOfSolStrings();
        this.N = eaParams.getStringLength();
        this.startNoOfBPs = eaParams.getStartNoOfBPs();
        this.maxNoOfBPs = eaParams.getMaxNoOfBPs();
        this.minDistBtwBPs = eaParams.getMinDistBetweenBPs();
        this.driver = driver;
        this.mutation_prob = eaParams.getProbForMutataion();
        this.one_pt_cross_prob = eaParams.getProbForOnePtCR();
        this.uniform_cross_prob = eaParams.getProbForUniformCR();
        this.mutation_prob_per_index = eaParams.getMutationProbPerIndex();
        this.iterUsed = 0;
        this.noOfUnifCo = 0;
        this.noOf1PtCo = 0;
        this.noOfMut = 0;
    }

    public void run() {
        this.runAlgo();
    }

    public void init() {
        this.solStrings = new Vector();
        this.debug("MinDist=" + this.minDistBtwBPs);
        int i = 0;
        while (i < this.noOfStrings) {
            int noOfBPs = (int)Math.max(1.0, (double)this.startNoOfBPs * Math.random());
            SolutionString ss = new SolutionString(this.N, noOfBPs, this.minDistBtwBPs);
            this.solStrings.add(ss);
            ++i;
        }
        for (SolutionString ss : this.solStrings) {
            int[] bpIdxs = ss.getBPIndicesAsArray();
            ss.setFitness(this.driver.fitness(bpIdxs));
            if (ss.getNoOfBPs() <= this.maxNoOfBPs) continue;
            ss.setFitness(ss.getFitness() * 0.6);
        }
        Collections.sort(this.solStrings);
        this.bestSolution = this.solStrings.get(0);
        this.debug("--------------- Init -------------\n" + this.populationAsString());
    }

    private void runAlgo() {
        this.init();
        this.bestFitness = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.solStrings.size()) {
            this.bestFitness = Math.max(this.bestFitness, this.solStrings.get(i).getFitness());
            ++i;
        }
        int k = 0;
        boolean goon = true;
        SolutionString newString = null;
        while (k < 2000 && goon) {
            OPERATION oper;
            this.debug("--------- iter = " + k + " ------------");
            this.debug("bf= " + this.bestFitness);
            ++this.iterUsed;
            double rr = Math.random();
            if (rr < this.one_pt_cross_prob) {
                oper = OPERATION.ONE_PT_CROSS;
                newString = this.performOnePtCrossover();
            } else if (rr < this.uniform_cross_prob + this.one_pt_cross_prob) {
                oper = OPERATION.UNIFORM_CROSS;
                newString = this.performUniformCrossover();
            } else {
                oper = OPERATION.MUTATION;
                newString = this.performMutation();
            }
            this.debug("Operation = " + (Object)((Object)oper));
            this.addToPopulation(newString, k);
            if (++k - this.lastImprovment <= 400) continue;
            goon = false;
        }
        this.debug("--------------- Final -------------\n" + this.populationAsString());
        this.debug("--------------- Best --------------\n" + this.bestSolution.toString() + "\n");
        this.debug("Found at k = " + this.lastImprovment);
    }

    public void run(Vector<SolutionString> collectionOfBest) {
        this.runAlgo(collectionOfBest);
    }

    private void runAlgo(Vector<SolutionString> collectionOfBest) {
        this.solStrings = collectionOfBest;
        this.bestSolution = this.solStrings.get(0);
        this.bestFitness = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.solStrings.size()) {
            this.bestFitness = Math.max(this.bestFitness, this.solStrings.get(i).getFitness());
            ++i;
        }
        int k = 0;
        boolean goon = true;
        SolutionString newString = null;
        while (k < 2000 && goon) {
            OPERATION oper;
            ++this.iterUsed;
            this.debug("--------- iter = " + k + " ------------");
            this.debug("bf= " + this.bestFitness);
            double rr = Math.random();
            if (rr < this.one_pt_cross_prob) {
                oper = OPERATION.ONE_PT_CROSS;
                newString = this.performOnePtCrossover();
            } else if (rr < this.uniform_cross_prob + this.one_pt_cross_prob) {
                oper = OPERATION.UNIFORM_CROSS;
                newString = this.performUniformCrossover();
            } else {
                oper = OPERATION.MUTATION;
                newString = this.performMutation();
            }
            this.debug("Operation = " + (Object)((Object)oper));
            this.addToPopulation(newString, k);
            if (++k - this.lastImprovment <= 400) continue;
            goon = false;
        }
    }

    private SolutionString performMutation() {
        this.debug("mutation");
        ++this.noOfMut;
        int idx1 = this.selectWRTFitness(this.selType);
        SolutionString newString = this.mutation_prob_per_index > 0.0 ? this.solStrings.get(idx1).mutate(0.3, 0.3, this.mutation_prob_per_index) : this.solStrings.get(idx1).mutate(0.3, 0.3);
        int[] bpIdxs = newString.getBPIndicesAsArray();
        newString.setFitness(this.driver.fitness(bpIdxs));
        if (newString.getNoOfBPs() > this.maxNoOfBPs) {
            newString.setFitness(newString.getFitness() * 0.6);
        }
        return newString;
    }

    private SolutionString performOnePtCrossover() {
        int idx2;
        this.debug("one-pt-crossover");
        ++this.noOf1PtCo;
        int idx1 = this.selectWRTFitness(this.selType);
        while (idx1 == (idx2 = this.selectWRTFitness(this.selType))) {
        }
        SolutionString newString = this.solStrings.get(idx1).crossOverOnePoint(this.solStrings.get(idx2));
        int[] bpIdxs = newString.getBPIndicesAsArray();
        newString.setFitness(this.driver.fitness(bpIdxs));
        if (newString.getNoOfBPs() > this.maxNoOfBPs) {
            newString.setFitness(newString.getFitness() * 0.6);
        }
        return newString;
    }

    private int selectWRTFitness(int type) {
        Collections.sort(this.solStrings);
        double[] fitnessSums = new double[this.solStrings.size()];
        switch (type) {
            case 1: {
                fitnessSums[0] = this.solStrings.get(0).getFitness();
                int i = 1;
                while (i < fitnessSums.length) {
                    fitnessSums[i] = fitnessSums[i - 1] + this.solStrings.get(i).getFitness();
                    ++i;
                }
                break;
            }
            case 2: {
                fitnessSums[0] = Math.pow(this.solStrings.get(0).getFitness(), 2.0);
                int i = 1;
                while (i < fitnessSums.length) {
                    fitnessSums[i] = fitnessSums[i - 1] + Math.pow(this.solStrings.get(i).getFitness(), 2.0);
                    ++i;
                }
                break;
            }
            case 3: {
                fitnessSums[0] = Math.exp(this.solStrings.get(0).getFitness());
                int i = 1;
                while (i < fitnessSums.length) {
                    fitnessSums[i] = fitnessSums[i - 1] + Math.exp(this.solStrings.get(i).getFitness());
                    ++i;
                }
                break;
            }
        }
        double rand = Math.random() * fitnessSums[fitnessSums.length - 1];
        int idx = 0;
        while (idx < fitnessSums.length && rand > fitnessSums[idx]) {
            ++idx;
        }
        if (idx < 0) {
            System.out.println("************* selectidx: idx < 0");
            idx = 0;
        }
        if (idx > this.solStrings.size() - 1) {
            System.out.println("************* selectidx: idx >= no of strings");
            idx = this.solStrings.size() - 1;
        }
        return idx;
    }

    private SolutionString performUniformCrossover() {
        int idx2;
        this.debug("uniform-crossover");
        ++this.noOfUnifCo;
        int idx1 = this.selectWRTFitness(this.selType);
        while (idx1 == (idx2 = this.selectWRTFitness(this.selType))) {
        }
        SolutionString newString = this.solStrings.get(idx1).crossOverUniform(this.solStrings.get(idx2));
        int[] bpIdxs = newString.getBPIndicesAsArray();
        newString.setFitness(this.driver.fitness(bpIdxs));
        if (newString.getNoOfBPs() > this.maxNoOfBPs) {
            newString.setFitness(newString.getFitness() * 0.6);
        }
        return newString;
    }

    private void addToPopulation(SolutionString solString, int k) {
        int worstIdx = -1;
        if (solString.getFitness() > this.bestFitness) {
            this.bestFitness = solString.getFitness();
            this.bestSolution = solString;
            this.bestIteration = k;
            this.lastImprovment = k;
        }
        double worstFitness = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.solStrings.size()) {
            if (worstFitness > this.solStrings.get(i).getFitness()) {
                worstFitness = this.solStrings.get(i).getFitness();
                worstIdx = i;
            }
            ++i;
        }
        this.solStrings.remove(worstIdx);
        this.solStrings.add(solString);
    }

    public void printCurrenStrings() {
        for (SolutionString ss : this.solStrings) {
            System.out.println(ss.toString());
        }
    }

    private void debug(String txt) {
        if (this.debugflag) {
            System.out.println(txt);
        }
    }

    private String populationAsString() {
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (i < this.noOfStrings) {
            sb.append(String.valueOf(this.solStrings.get(i).toString()) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public SolutionString getBestSol() {
        return this.bestSolution;
    }

    private static enum OPERATION {
        ONE_PT_CROSS,
        UNIFORM_CROSS,
        MUTATION;

    }
}

