/*
 * Decompiled with CFR 0.152.
 */
package edu.dtulnu.stat.brpts.rect;

import edu.dtulnu.stat.brpts.rect.EAParameterset;
import edu.dtulnu.stat.brpts.rect.EvolutionaryAlgoMinMax;
import edu.dtulnu.stat.brpts.rect.MinMaxRangeTree;
import edu.dtulnu.stat.brpts.rect.SolutionString;
import java.util.Arrays;
import java.util.Vector;

public class BreakPointsMinMaxDriver {
    private MinMaxRangeTree rt;
    private double maxArea;
    private double alpha;
    private StringBuilder messages;
    private boolean computed = false;
    private int[] breakPoints;
    private double[][] rectangles;

    public int[] computeBreakPoints(double[] series, double alpha) {
        this.computed = false;
        this.messages = new StringBuilder();
        return this.compute(series, alpha);
    }

    public double[][] computeRectangles(double[] series, double alpha) {
        if (this.computed) {
            return this.rectangles;
        }
        this.computeBreakPoints(series, alpha);
        return this.rectangles;
    }

    private int[] compute(double[] series, double alpha) {
        if (series.length <= 1 || alpha < 0.0 || alpha > 1.0) {
            this.breakPoints = new int[0];
            this.rectangles = new double[][]{new double[0]};
            this.computed = true;
            return this.breakPoints;
        }
        this.rt = new MinMaxRangeTree(series);
        this.alpha = alpha;
        double[] minmax = this.rt.getResult(0, series.length - 1);
        this.maxArea = (minmax[1] - minmax[0]) * (double)series.length;
        if (this.maxArea <= 0.0) {
            int[] nArray = new int[2];
            nArray[1] = series.length;
            this.breakPoints = nArray;
            this.rectangles = new double[][]{{0.0, minmax[0], series.length - 1, minmax[1]}};
            this.computed = true;
            return this.breakPoints;
        }
        EAParameterset ps = new EAParameterset(series.length);
        EvolutionaryAlgoMinMax ea = new EvolutionaryAlgoMinMax(ps, this);
        Vector<SolutionString> collectionOfBest = new Vector<SolutionString>();
        int k = 0;
        while (k < 50) {
            ea.init();
            ea.run();
            SolutionString currentBestSolution = ea.getBestSol();
            int[] bpidxs = currentBestSolution.getBPIndicesAsArray();
            collectionOfBest.add(currentBestSolution);
            ++k;
        }
        ea.run(collectionOfBest);
        this.computed = true;
        this.breakPoints = ea.getBestSol().getBPIndicesAsArray();
        this.computeRectanglesI();
        return this.breakPoints;
    }

    private void computeRectanglesI() {
        this.rectangles = new double[this.breakPoints.length - 1][4];
        int i = 0;
        while (i < this.rectangles.length) {
            int l = this.breakPoints[i];
            int r = this.breakPoints[i + 1] - 1;
            double[] minmax = this.rt.getResult(l, r);
            this.rectangles[i][0] = l;
            this.rectangles[i][1] = minmax[0];
            this.rectangles[i][2] = this.breakPoints[i + 1] - 1;
            this.rectangles[i][3] = minmax[1];
            ++i;
        }
    }

    public double fitness(int[] brPtIdxs) {
        double alpha2 = this.alpha;
        double alpha2_1 = 1.0 - alpha2;
        int noOfBPs = brPtIdxs.length;
        int left = brPtIdxs[0];
        double rectArea = 0.0;
        int i = 1;
        while (i < brPtIdxs.length) {
            double ySpan;
            double area;
            int right = brPtIdxs[i];
            double[] minmax = this.rt.getResult(left, right - 1);
            if (minmax == null) {
                System.out.println(String.valueOf(Arrays.toString(brPtIdxs)) + "  " + left + "  " + right);
            }
            if (((area = (double)(right - left) * (ySpan = minmax[1] - minmax[0])) < 0.0 || area > this.maxArea) && (i != brPtIdxs.length - 1 || left != right - 1)) {
                System.out.println("StructuralBreaksWithRectangles: illegal area " + left + " " + right + " " + ySpan + "  " + area);
                System.out.println(Arrays.toString(brPtIdxs));
            }
            rectArea += area;
            left = right;
            ++i;
        }
        double areaTerm = 1.0 - rectArea / this.maxArea;
        double noOfSegmentsTerm = 1.0 / Math.sqrt(noOfBPs + 1);
        double fit = alpha2_1 * areaTerm + alpha2 * noOfSegmentsTerm;
        return fit;
    }
}

