/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import moa.core.Measurement;
import moa.core.utils.EvalUtils;
import moa.evaluation.WindowClassificationPerformanceEvaluator;
import weka.core.Instance;

public class MultilabelWindowClassificationPerformanceEvaluator
extends WindowClassificationPerformanceEvaluator {
    ArrayList<double[]> result_pred = new ArrayList();
    ArrayList<int[]> result_real = new ArrayList();
    private double LC = -1.0;

    public void reset() {
        this.result_pred = new ArrayList(this.widthOption.getValue());
        this.result_real = new ArrayList(this.widthOption.getValue());
    }

    public void reset(int L) {
        this.numClasses = L;
        this.result_pred = new ArrayList(this.widthOption.getValue());
        this.result_real = new ArrayList(this.widthOption.getValue());
    }

    public void addResult(Instance x, double[] y) {
        if (y.length <= 2) {
            System.err.println("y.length too short (" + y.length + "). We've lost track of L at some point, unable to continue");
            System.exit(1);
        }
        this.result_real.add(EvalUtils.toIntArray(x, y.length));
        this.result_pred.add(y);
    }

    public Measurement[] getPerformanceMeasurements() {
        double t = 0.5;
        try {
            t = this.LC > 0.0 ? EvalUtils.calibrateThreshold(this.result_pred, this.LC) : 0.5;
        }
        catch (Exception e) {
            System.err.println("Warning: failed to calibrate threshold, continuing with default: t = " + t);
            e.printStackTrace();
        }
        HashMap<String, Double> result = EvalUtils.evaluateMultiLabel(this.result_pred, this.result_real, t);
        Measurement[] m = new Measurement[]{new Measurement("Subset Accuracy", result.get("Accuracy")), new Measurement("Exact Match", result.get("Exact_match")), new Measurement("Hamming Accucaracy", result.get("H_acc")), new Measurement("Log Loss_D", result.get("LogLossD")), new Measurement("Threshold", result.get("Threshold"))};
        this.LC = result.get("LCard_real");
        this.reset();
        return m;
    }

    public void getDescription(StringBuilder sb, int indent) {
        sb.append("Multi-label Window Classification Performance Evaluator");
    }
}

