/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.lang.Text;
import javolution.realtime.LogContext;

public class StandardLog
extends LogContext {
    private Logger _logger;

    public StandardLog() {
        this(Logger.getLogger(""));
    }

    public StandardLog(Logger logger) {
        this._logger = logger;
    }

    public final Logger getLogger() {
        return this._logger;
    }

    public static boolean isLoggable(Level level) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            return ((StandardLog)logContext)._logger.isLoggable(level);
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return logContext.isWarningLogged();
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return logContext.isInfoLogged();
        }
        return false;
    }

    public static void log(LogRecord logRecord) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.log(logRecord);
        } else {
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                logContext.logError(throwable, StandardLog.toCharSeq(logRecord.getMessage()));
            } else if (logRecord.getLevel().intValue() > Level.WARNING.intValue()) {
                logContext.logWarning(StandardLog.toCharSeq(logRecord.getMessage()));
            } else if (logRecord.getLevel().intValue() > Level.INFO.intValue()) {
                logContext.logInfo(StandardLog.toCharSeq(logRecord.getMessage()));
            }
        }
    }

    public static void severe(String string) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.severe(string);
        } else {
            logContext.logWarning(StandardLog.toCharSeq(string));
        }
    }

    public static void warning(String string) {
        LogContext logContext = LogContext.current();
        logContext.logWarning(StandardLog.toCharSeq(string));
    }

    public static void info(String string) {
        LogContext logContext = LogContext.current();
        logContext.logInfo(StandardLog.toCharSeq(string));
    }

    public static void config(String string) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.config(string);
        }
    }

    public static void fine(String string) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.fine(string);
        }
    }

    public static void finer(String string) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.finer(string);
        }
    }

    public static void finest(String string) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.finest(string);
        }
    }

    public static void throwing(String string, String string2, Throwable throwable) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.throwing(string, string2, throwable);
        } else {
            logContext.logError(throwable, null);
        }
    }

    public static void entering(String string, String string2) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.entering(string, string2);
        }
    }

    public static void exiting(String string, String string2) {
        LogContext logContext = LogContext.current();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.exiting(string, string2);
        }
    }

    public boolean isInfoLogged() {
        return this._logger.isLoggable(Level.INFO);
    }

    public boolean isWarningLogged() {
        return this._logger.isLoggable(Level.WARNING);
    }

    public boolean isErrorLogged() {
        return this._logger.isLoggable(Level.SEVERE);
    }

    public void logInfo(CharSequence charSequence) {
        this._logger.info(((Object)charSequence).toString());
    }

    public void logWarning(CharSequence charSequence) {
        this._logger.warning(((Object)charSequence).toString());
    }

    public void logError(Throwable throwable, CharSequence charSequence) {
        String string = charSequence == null ? throwable.getMessage() : ((Object)charSequence).toString();
        string = string == null ? throwable.getClass().getName() : throwable.getClass().getName() + " - " + string;
        this._logger.severe(string);
    }

    private static CharSequence toCharSeq(Object object) {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return Text.valueOf((String)object);
    }
}

