/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.random;

import net.sourceforge.jclec.util.random.AbstractRandGen;
import org.apache.commons.lang.builder.EqualsBuilder;

public class Ranlux
extends AbstractRandGen {
    private static final long serialVersionUID = 7707398773259479291L;
    static final int GIGA = 1000000000;
    static final int TWOP12 = 4096;
    static final int ITWO24 = 0x1000000;
    static final int ICONS = 2147483563;
    static final int[] ND_SKIP;
    static final int[] NEXT;
    int nskip;
    float twom24;
    float twom12;
    int i24;
    int j24;
    int in24;
    int kount;
    float carry;
    float[] seeds;

    static {
        int[] nArray = new int[5];
        nArray[1] = 24;
        nArray[2] = 73;
        nArray[3] = 199;
        nArray[4] = 365;
        ND_SKIP = nArray;
        int[] nArray2 = new int[25];
        nArray2[1] = 24;
        nArray2[2] = 1;
        nArray2[3] = 2;
        nArray2[4] = 3;
        nArray2[5] = 4;
        nArray2[6] = 5;
        nArray2[7] = 6;
        nArray2[8] = 7;
        nArray2[9] = 8;
        nArray2[10] = 9;
        nArray2[11] = 10;
        nArray2[12] = 11;
        nArray2[13] = 12;
        nArray2[14] = 13;
        nArray2[15] = 14;
        nArray2[16] = 15;
        nArray2[17] = 16;
        nArray2[18] = 17;
        nArray2[19] = 18;
        nArray2[20] = 19;
        nArray2[21] = 20;
        nArray2[22] = 21;
        nArray2[23] = 22;
        nArray2[24] = 23;
        NEXT = nArray2;
    }

    protected Ranlux() {
    }

    public Ranlux(int luxlev, int seed) {
        this.rluxgo(luxlev, seed);
    }

    @Override
    public final double raw() {
        float uni = this.seeds[this.j24] - this.seeds[this.i24] - this.carry;
        if (uni < 0.0f) {
            uni += 1.0f;
            this.carry = this.twom24;
        } else {
            this.carry = 0.0f;
        }
        this.seeds[this.i24] = uni;
        this.i24 = NEXT[this.i24];
        this.j24 = NEXT[this.j24];
        float out = uni;
        if (uni < this.twom12) {
            out += this.twom24 * this.seeds[this.j24];
        }
        if ((double)out == 0.0) {
            out = this.twom24 * this.twom24;
        }
        ++this.in24;
        if (this.in24 == 24) {
            this.in24 = 0;
            this.kount += this.nskip;
            int i = 1;
            while (i <= this.nskip) {
                uni = this.seeds[this.j24] - this.seeds[this.i24] - this.carry;
                if (uni < 0.0f) {
                    uni += 1.0f;
                    this.carry = this.twom24;
                } else {
                    this.carry = 0.0f;
                }
                this.seeds[this.i24] = uni;
                this.i24 = NEXT[this.i24];
                this.j24 = NEXT[this.j24];
                ++i;
            }
        }
        ++this.kount;
        if (this.kount >= 1000000000) {
            this.kount -= 1000000000;
        }
        return out;
    }

    public boolean equals(Object other) {
        if (other instanceof Ranlux) {
            Ranlux o = (Ranlux)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.nskip, o.nskip);
            eb.append(this.twom24, o.twom24);
            eb.append(this.twom12, o.twom12);
            eb.append(this.i24, o.i24);
            eb.append(this.j24, o.j24);
            eb.append(this.in24, o.in24);
            eb.append(this.kount, o.kount);
            eb.append(this.carry, o.carry);
            eb.append(this.seeds, o.seeds);
            return eb.isEquals();
        }
        return false;
    }

    private final void rluxgo(int lux, int ins) {
        if (lux < 0 || lux > 4) {
            throw new IllegalArgumentException("Luxury level must be an integer in the range [0,4]");
        }
        this.nskip = ND_SKIP[lux];
        this.in24 = 0;
        if (ins <= 0) {
            throw new IllegalArgumentException("ins must be a positive integer");
        }
        this.twom24 = 1.0f;
        int[] iseeds = new int[25];
        int aux = ins;
        int i = 1;
        while (i <= 24) {
            this.twom24 *= 0.5f;
            int k = aux / 53668;
            if ((aux = 40014 * (aux - k * 53668) - k * 12211) < 0) {
                aux += 2147483563;
            }
            iseeds[i] = aux % 0x1000000;
            ++i;
        }
        this.twom12 = this.twom24 * 4096.0f;
        this.seeds = new float[25];
        i = 1;
        while (i <= 24) {
            this.seeds[i] = (float)iseeds[i] * this.twom24;
            ++i;
        }
        this.i24 = 24;
        this.j24 = 10;
        this.carry = 0.0f;
        if ((double)this.seeds[24] == 0.0) {
            this.carry = this.twom24;
        }
        this.kount = 0;
    }
}

