/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.stefano;

import net.sourceforge.jclec.problem.classification.blocks.RandomConstantOfContinuousValues;
import net.sourceforge.jclec.problem.classification.blocks.RandomConstantOfDiscreteValues;
import net.sourceforge.jclec.syntaxtree.IMutateSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.syntaxtree.TerminalNode;
import net.sourceforge.jclec.util.random.IRandGen;
import net.sourceforge.jclec.util.range.Interval;

public class StefanoMutator
implements IMutateSyntaxTree {
    private static final long serialVersionUID = -6447244450691681809L;

    @Override
    public SyntaxTree mutateSyntaxTree(SyntaxTree parent, SyntaxTreeSchema schema, IRandGen randgen) {
        System.out.println("recibo " + parent);
        int p_branchStart = randgen.choose(0, parent.size());
        SyntaxTree son = new SyntaxTree();
        if (parent.getNode(p_branchStart) instanceof NonTerminalNode) {
            System.out.println("muto no terminal");
            NonTerminalNode selectedSymbol = (NonTerminalNode)parent.getNode(p_branchStart);
            int p_branchEnd = this.endOfBranch(parent, p_branchStart);
            int i = 0;
            while (i < p_branchStart) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            int p_branchDepth = parent.derivSize();
            int p_swapBranch = 0;
            int i2 = p_branchStart;
            while (i2 <= p_branchEnd) {
                if (parent.getNode(i2).arity() != 0) {
                    ++p_swapBranch;
                }
                ++i2;
            }
            int beforeValue = schema.getMaxDerivSize() - p_branchDepth + p_swapBranch;
            if (p_swapBranch < schema.getMinDerivSize()) {
                p_swapBranch = schema.getMinDerivSize();
            }
            int nOfDer = randgen.choose(p_swapBranch, beforeValue);
            schema.fillSyntaxBranch(son, selectedSymbol.getSymbol(), nOfDer, randgen);
            int i3 = p_branchEnd + 1;
            while (i3 < parent.size()) {
                son.addNode(parent.getNode(i3).copy());
                ++i3;
            }
        } else {
            System.out.println("muto terminal");
            TerminalNode selectedSymbol = (TerminalNode)parent.getNode(p_branchStart);
            int i = 0;
            while (i < p_branchStart) {
                son.addNode(parent.getNode(i).copy());
                ++i;
            }
            TerminalNode node = this.selectOtherTerminalNode(selectedSymbol, schema, randgen);
            if (node != null) {
                son.addNode(node);
            }
            int i4 = p_branchStart + 1;
            while (i4 < parent.size()) {
                son.addNode(parent.getNode(i4).copy());
                ++i4;
            }
        }
        System.out.println("devuelvo " + son);
        return son;
    }

    private final int endOfBranch(SyntaxTree tree, int currentNode) {
        int count = 1;
        while (count != 0) {
            count += tree.getNode(currentNode).arity() - 1;
            ++currentNode;
        }
        return currentNode - 1;
    }

    private TerminalNode selectOtherTerminalNode(TerminalNode symbol, SyntaxTreeSchema schema, IRandGen randgen) {
        if (symbol.getSymbol().equalsIgnoreCase("=") || symbol.getSymbol().equalsIgnoreCase(">") || symbol.getSymbol().equalsIgnoreCase(">=") || symbol.getSymbol().equalsIgnoreCase("<=") || symbol.getSymbol().equalsIgnoreCase("<")) {
            if (randgen.raw() < 0.2) {
                return schema.getTerminal("=");
            }
            if (randgen.raw() < 0.2) {
                return schema.getTerminal(">");
            }
            if (randgen.raw() < 0.2) {
                return schema.getTerminal(">=");
            }
            if (randgen.raw() < 0.2) {
                return schema.getTerminal("<");
            }
            if (randgen.raw() < 0.2) {
                return schema.getTerminal("<=");
            }
        }
        if (symbol.getSymbol().equalsIgnoreCase("AND")) {
            return schema.getTerminal("OR");
        }
        if (symbol.getSymbol().equalsIgnoreCase("OR")) {
            return schema.getTerminal("AND");
        }
        if (symbol.getSymbol().equalsIgnoreCase("NOT")) {
            return null;
        }
        if (symbol.getCode() instanceof RandomConstantOfContinuousValues) {
            TerminalNode terminalAux = new TerminalNode(symbol.getSymbol(), new RandomConstantOfContinuousValues(randgen));
            Interval interval = ((RandomConstantOfContinuousValues)symbol.getCode()).getInterval();
            ((RandomConstantOfContinuousValues)terminalAux.getCode()).setInterval(interval);
            ((RandomConstantOfContinuousValues)terminalAux.getCode()).initializeValue();
            return terminalAux;
        }
        if (symbol.getCode() instanceof RandomConstantOfDiscreteValues) {
            TerminalNode terminalAux = new TerminalNode(symbol.getSymbol(), new RandomConstantOfDiscreteValues(randgen));
            net.sourceforge.jclec.util.intset.Interval interval = ((RandomConstantOfDiscreteValues)symbol.getCode()).getInterval();
            ((RandomConstantOfDiscreteValues)terminalAux.getCode()).setInterval(interval);
            ((RandomConstantOfDiscreteValues)terminalAux.getCode()).initializeValue();
            return terminalAux;
        }
        return symbol;
    }
}

