/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.VQ;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.LVQ.LVQ1;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class VQGenerator
extends LVQ1 {
    protected double inverseOfNumberOfIterations = 1.0;
    protected int k = 1;

    public VQGenerator(PrototypeSet t, int iterations, int np, double alpha_0, int k) {
        super(t, iterations, np, alpha_0);
        this.algorithmName = "VQ";
        this.inverseOfNumberOfIterations = 1.0 / (double)iterations;
        this.k = k;
        KNN.setK(k);
        this.randomIndexes = RandomGenerator.generateDifferentRandomIntegers(0, t.size() - 1);
    }

    public VQGenerator(PrototypeSet t, int iterations, double pcNprots, double alpha_0, int k) {
        super(t, iterations, pcNprots, alpha_0);
        this.algorithmName = "VQ";
        this.inverseOfNumberOfIterations = 1.0 / (double)iterations;
        this.k = k;
        KNN.setK(k);
        this.randomIndexes = RandomGenerator.generateDifferentRandomIntegers(0, t.size() - 1);
    }

    public VQGenerator(PrototypeSet t, Parameters param) {
        super(t, param);
        this.algorithmName = "VQ";
        this.inverseOfNumberOfIterations = 1.0 / (double)this.iterations;
        this.k = 1;
        if (param.existMore()) {
            this.k = param.getNextAsInt();
        }
        KNN.setK(this.k);
        this.randomIndexes = RandomGenerator.generateDifferentRandomIntegers(0, t.size() - 1);
    }

    protected void updateAlpha(int t) {
        this.alpha_0 = (1.0 - (double)t * this.inverseOfNumberOfIterations) * this.alpha_0;
    }

    @Override
    protected void correct(Prototype i, PrototypeSet tData) {
        double class_nearest;
        Prototype nearest = KNN._1nn(i, tData);
        double class_i = i.label();
        if (class_i == (class_nearest = nearest.label())) {
            this.reward(nearest, i);
        }
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet outputDataSet = this.initDataSet();
        for (int it = 0; it < this.iterations; ++it) {
            Prototype instance = this.extract(this.trainingDataSet);
            this.correct(instance, outputDataSet);
            this.updateAlpha(it);
        }
        for (Prototype p : outputDataSet) {
            PrototypeSet neighbors = KNN.knn(p, this.trainingDataSet);
            double maxFreqClass = neighbors.mostFrequentClass();
            p.setClass(maxFreqClass);
        }
        return outputDataSet;
    }

    public static void main(String[] args) {
        Parameters.setUse("VQ", "<num. iterations> <percentage of num. prototypes> <alpha_0> <k>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        VQGenerator.setSeed(seed);
        int iter = Parameters.assertExtendedArgAsInt(args, 3, "number of iterations", 1.0, 2.147483647E9);
        double pcNprot = Parameters.assertExtendedArgAsDouble(args, 4, "percentage of prototypes", 0.0, 100.0);
        double alpha_0 = Parameters.assertExtendedArgAsDouble(args, 5, "alpha_0", 0.0, 1.0);
        int k = Parameters.assertExtendedArgAsInt(args, 6, "k", 1.0, 5.0);
        VQGenerator generator = new VQGenerator(training, iter, pcNprot, alpha_0, k);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

