/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.C45_Binarization;

import java.util.StringTokenizer;
import keel.Algorithms.Decision_Trees.C45_Binarization.KNN;
import keel.Algorithms.Decision_Trees.C45_Binarization.Metodo;
import org.core.Fichero;

public class ENN
extends Metodo {
    private int k;
    private int nClases = 0;

    public ENN(String ficheroScript) {
        super(ficheroScript);
        for (int i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= this.nClases) continue;
            this.nClases = this.clasesTrain[i];
        }
        ++this.nClases;
    }

    public void setK(int k) {
        this.k = k;
    }

    public int getK() {
        return this.k;
    }

    public int evaluaKNN(int i, int[] vecinos, double[] distancias, int[] votos, boolean test, boolean distanceEu) {
        if (!test) {
            return KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], this.nClases, distanceEu, vecinos, distancias, votos);
        }
        return KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTest[i], this.realTest[i], this.nominalTest[i], this.nulosTest[i], this.nClases, distanceEu, vecinos, distancias, votos);
    }

    public void ejecutar() {
        int i;
        int nSel = 0;
        long tiempo = System.currentTimeMillis();
        boolean[] marcas = new boolean[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = false;
        }
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        for (i = 0; i < this.datosTrain.length; ++i) {
            int claseObt = KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu);
            if (claseObt != this.clasesTrain[i]) continue;
            marcas[i] = true;
            ++nSel;
        }
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            for (int j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("ENN " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        int[][] trainRealClass = new int[conjS.length][1];
        int[][] trainPrediction = new int[conjS.length][1];
        for (i = 0; i < conjS.length; ++i) {
            trainRealClass[i][0] = clasesS[i];
            trainPrediction[i][0] = KNN.evaluate(conjS[i], this.datosTrain, nClases, this.clasesTrain, this.k);
        }
        KNN.writeOutput(this.ficheroSalida[0], trainRealClass, trainPrediction, this.entradas, this.salida, this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate(this.datosTest[i], conjS, nClases, clasesS, this.k);
        }
        KNN.writeOutput(this.ficheroSalida[1], realClass, prediction, this.entradas, this.salida, this.relation);
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

