/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.CustomPanelSupplier;
import weka.gui.PropertyDialog;

public class PropertyPanel
extends JPanel {
    static final long serialVersionUID = 5370025273466728904L;
    private PropertyEditor m_Editor;
    private PropertyDialog m_PD;
    private boolean m_HasCustomPanel = false;

    public PropertyPanel(PropertyEditor propertyEditor) {
        this(propertyEditor, false);
    }

    public PropertyPanel(PropertyEditor propertyEditor, boolean bl) {
        this.m_Editor = propertyEditor;
        if (!bl && this.m_Editor instanceof CustomPanelSupplier) {
            this.setLayout(new BorderLayout());
            this.add((Component)((CustomPanelSupplier)((Object)this.m_Editor)).getCustomPanel(), "Center");
            this.m_HasCustomPanel = true;
        } else {
            this.createDefaultPanel();
        }
    }

    protected void createDefaultPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setToolTipText("Left-click to edit properties for this object, right-click/Alt+Shift+left-click for menu");
        this.setOpaque(true);
        final PropertyPanel propertyPanel = this;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 1) {
                    if (mouseEvent.getButton() == 1 && !mouseEvent.isAltDown() && !mouseEvent.isShiftDown()) {
                        PropertyPanel.this.showPropertyDialog();
                    } else if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 1 && mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
                        JMenuItem jMenuItem;
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        if (PropertyPanel.this.m_Editor.getValue() != null) {
                            jMenuItem = new JMenuItem("Show properties...");
                            jMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    PropertyPanel.this.showPropertyDialog();
                                }
                            });
                            jPopupMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem("Copy configuration to clipboard");
                            jMenuItem.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    String string = PropertyPanel.this.m_Editor.getValue().getClass().getName();
                                    if (PropertyPanel.this.m_Editor.getValue() instanceof OptionHandler) {
                                        string = string + " " + Utils.joinOptions(((OptionHandler)PropertyPanel.this.m_Editor.getValue()).getOptions());
                                    }
                                    StringSelection stringSelection = new StringSelection(string.trim());
                                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                    clipboard.setContents(stringSelection, stringSelection);
                                }
                            });
                            jPopupMenu.add(jMenuItem);
                        }
                        jMenuItem = new JMenuItem("Enter configuration...");
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = JOptionPane.showInputDialog(propertyPanel, (Object)"Configuration (<classname> [<options>])");
                                if (string != null) {
                                    try {
                                        String[] stringArray = Utils.splitOptions(string);
                                        String string2 = stringArray[0];
                                        stringArray[0] = "";
                                        PropertyPanel.this.m_Editor.setValue(Utils.forName(Object.class, string2, stringArray));
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        JOptionPane.showMessageDialog(propertyPanel, "Error parsing commandline:\n" + exception, "Error...", 0);
                                    }
                                }
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                        jPopupMenu.show(propertyPanel, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        Dimension dimension = this.getPreferredSize();
        dimension.height = this.getFontMetrics(this.getFont()).getHeight() * 5 / 4;
        dimension.width = dimension.height * 5;
        this.setPreferredSize(dimension);
        this.m_Editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyPanel.this.repaint();
            }
        });
    }

    public void showPropertyDialog() {
        if (this.m_Editor.getValue() != null) {
            if (this.m_PD == null) {
                int n = this.getLocationOnScreen().x;
                int n2 = this.getLocationOnScreen().y;
                this.m_PD = new PropertyDialog(this.m_Editor, n, n2);
            } else {
                this.m_PD.setVisible(true);
            }
            this.m_Editor.setValue(this.m_Editor.getValue());
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_PD != null) {
            this.m_PD.dispose();
            this.m_PD = null;
        }
    }

    public void paintComponent(Graphics graphics) {
        if (!this.m_HasCustomPanel) {
            Insets insets = this.getInsets();
            Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getSize().width - insets.left - insets.right - 1, this.getSize().height - insets.top - insets.bottom - 1);
            graphics.clearRect(insets.left, insets.top, this.getSize().width - insets.right - insets.left, this.getSize().height - insets.bottom - insets.top);
            this.m_Editor.paintValue(graphics, rectangle);
        }
    }
}

