/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.util.Utils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public final class CheckboxListTableModel<T>
extends AbstractTableModel {
    private static final Logger LOGGER = Logger.getLogger(CheckboxListTableModel.class.getName());
    private static final long serialVersionUID = 1L;
    private static volatile int counter = 0;
    private final String[] columnIdentifiers;
    private Object[][] items = new Object[0][];
    private final int num = counter++;

    public CheckboxListTableModel(String string, String string2) {
        this.columnIdentifiers = new String[]{"", string, string2};
    }

    public void setItems(Map<String, String> map) {
        LOGGER.info(this.num + " - " + new Object(){}.getClass().getEnclosingMethod().getName());
        Object[][] objectArrayArray = new Object[map.size()][];
        int n = 0;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                objectArrayArray[n++] = new Object[]{Boolean.FALSE, entry.getKey(), entry.getValue()};
            }
        }
        this.items = objectArrayArray;
        this.fireTableStructureChanged();
    }

    public void setItems(List<T> list, Utils.Function<? super T, String[]> function) {
        LOGGER.info(this.num + " - " + new Object(){}.getClass().getEnclosingMethod().getName());
        Object[][] objectArrayArray = new Object[list.size()][];
        int n = 0;
        if (list != null) {
            for (T t : list) {
                Object[] objectArray = new Object[]{Boolean.FALSE, null, null};
                System.arraycopy(function.apply(t), 0, objectArray, 1, 2);
                objectArrayArray[n++] = objectArray;
            }
        }
        this.items = objectArrayArray;
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Boolean.class : String.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnIdentifiers[n];
    }

    public Collection<String> getCheckedCodes() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < this.items.length; ++i) {
            if (!((Boolean)this.items[i][0]).booleanValue()) continue;
            linkedList.add((String)this.items[i][1]);
        }
        return linkedList;
    }

    public void uncheckAll() {
        LOGGER.info(this.num + " - " + new Object(){}.getClass().getEnclosingMethod().getName());
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setValueAt(false, i, 0);
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.items.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            return this.items[n][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return n2 == 0 ? Boolean.FALSE : "";
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        LOGGER.info(this.num + " - " + new Object(){}.getClass().getEnclosingMethod().getName());
        this.items[n][n2] = object;
        this.fireTableCellUpdated(n, n2);
    }
}

