/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.LevelShift;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public class LevelShiftFactory
implements IOutlierFactory {
    private int minLength = 1;
    private boolean zeroEnded = true;
    public static final int DEF_MINLENGTH = 1;

    @Override
    public LevelShift create(Day position) {
        LevelShift ls = new LevelShift(position);
        ls.zeroEnded = this.zeroEnded;
        return ls;
    }

    @Override
    public TsDomain definitionDomain(TsDomain tsdomain) {
        return tsdomain.drop(this.minLength, this.minLength);
    }

    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public OutlierType getOutlierType() {
        return OutlierType.LS;
    }

    @Override
    public String getOutlierCode() {
        return "LS";
    }

    public boolean isZeroEnded() {
        return this.zeroEnded;
    }

    public void setMinLength(int value) {
        this.minLength = value;
    }

    public void setZeroEnded(boolean value) {
        this.zeroEnded = value;
    }
}

