/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.satoolkit.diagnostics.FTest;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.simplets.TsData;

public class SeasonalOverDifferencingTest {
    private static double THRESHOLD = -0.7;

    public int test(ModellingContext context) {
        SarimaModel arima = context.estimation.getArima();
        SarimaSpecification spec = arima.getSpecification();
        if (spec.getFrequency() == 1) {
            return 0;
        }
        if (spec.getBP() != 0 || spec.getBD() != 1 || spec.getBQ() != 1 || arima.btheta(1) >= THRESHOLD) {
            return 0;
        }
        TsData lin = context.current(false).linearizedSeries(false);
        SeasonalityTests tests = SeasonalityTests.seasonalityTest(lin, 1, true, true);
        FTest ftest = new FTest();
        ftest.test(context.description);
        int score = tests.getScore();
        boolean fsign = ftest.getFTest().isSignificant();
        if (fsign) {
            ++score;
        }
        if (score >= 2 || fsign || tests.getQs().isSignificant()) {
            return 1;
        }
        return 2;
    }
}

