/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.diagnostics;

import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.modelling.arima.diagnostics.AbstractOneStepAheadForecastingTest;
import ec.tstoolkit.sarima.SarimaModel;

public class FastOneStepAheadForecastingTest
extends AbstractOneStepAheadForecastingTest {
    public FastOneStepAheadForecastingTest(int nback) {
        super(nback);
    }

    @Override
    protected DataBlock computeResiduals(RegArimaModel<SarimaModel> regarima) {
        try {
            RegArimaEstimation<SarimaModel> est = this.inSampleEstimate(regarima);
            if (est == null) {
                return null;
            }
            DataBlock res = new DataBlock(regarima.getDModel().getObsCount());
            res.copy(new ReadDataBlock(est.fullResiduals()));
            DataBlock yc = regarima.isMeanCorrection() ? regarima.calcRes(new ReadDataBlock(est.likelihood.getB())) : regarima.getY();
            int nr = res.getLength();
            DataBlock ar = new DataBlock(((SarimaModel)est.model.getArima()).getAR().getWeights());
            DataBlock ma = new DataBlock(((SarimaModel)est.model.getArima()).getMA().getWeights()).drop(0, 1);
            int nc = nr - this.getOutOfSampleLength();
            int ny = yc.getLength() - this.getOutOfSampleLength();
            DataBlock yr = yc.range(ny - ar.getLength() + 1, ny + 1);
            DataBlock er = res.range(nc - ma.getLength(), nc);
            for (int i = nc; i < nr; ++i) {
                double z = yr.dot(ar);
                res.set(i, z -= ma.dot(er));
                yr.move(1);
                er.move(1);
            }
            return res;
        }
        catch (Exception err) {
            return null;
        }
    }
}

