/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.estimation.AbstractRegArimaModel;
import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.SarimaFixedMapping;
import ec.tstoolkit.sarima.estimation.SarimaInitializer;

public class RegArimaEstimator
implements IRegArimaProcessor<SarimaModel> {
    public static final String SCORE = "score";
    public static final String OPTIMIZATION = "optimization";
    public static final double DEF_EPS = 1.0E-7;
    public static final double DEF_INTERNAL_EPS = 1.0E-4;
    protected double eps_ = 1.0E-7;
    protected double feps_;
    protected boolean ml_ = true;
    protected boolean logll_ = false;
    protected boolean fml_;
    protected StartingPoint start_ = StartingPoint.Multiple;
    protected Matrix pcov_;
    protected double[] score_;
    protected final IParametricMapping<SarimaModel> mapping_;
    protected GlsSarimaMonitor monitor_;
    protected IFunctionMinimizer min_ = new ProxyMinimizer(new LevenbergMarquardtMethod());
    private static final double UR_LIMIT = 0.1;

    public boolean isMaximumLikelihood() {
        return this.ml_;
    }

    public boolean isLogLikelihood() {
        return this.logll_;
    }

    public StartingPoint getStartingPoint() {
        return this.start_;
    }

    public void setStartingPoint(StartingPoint start) {
        this.start_ = start;
    }

    public void setMaximumLikelihood(boolean ml) {
        this.ml_ = ml;
    }

    public void setLogLikelihood(boolean logll) {
        this.logll_ = logll;
    }

    public RegArimaEstimator(IParametricMapping<SarimaModel> mapper) {
        this.mapping_ = mapper;
    }

    public void setMinimizer(IFunctionMinimizer min) {
        this.min_ = min;
    }

    public void setMinimizer(ISsqFunctionMinimizer min) {
        this.min_ = new ProxyMinimizer(min);
    }

    public IFunctionMinimizer getMinimizer() {
        return this.min_;
    }

    @Override
    public RegArimaEstimation<SarimaModel> process(RegArimaModel<SarimaModel> regs) {
        SarimaModel start;
        if (this.mapping_.getDim() == 0) {
            return new RegArimaEstimation<SarimaModel>(regs, regs.computeLikelihood());
        }
        if (this.start_ == StartingPoint.HannanRissanen || this.start_ == StartingPoint.Multiple) {
            SarimaInitializer initializer = new SarimaInitializer();
            initializer.useDefaultIfFailed(true);
            SarimaModel starthr = initializer.initialize(regs);
            SarimaSpecification spec = starthr.getSpecification();
            start = starthr;
            if (this.start_ == StartingPoint.Multiple) {
                RegArimaEstimation<SarimaModel> mdef;
                RegArimaEstimation<SarimaModel> mhr = this.estimate(regs, starthr);
                SarimaModel startdef = ((SarimaModel)mhr.model.getArma()).clone();
                if (spec.getP() > 0 && spec.getQ() > 0) {
                    int i;
                    double p = startdef.theta(1) < 0.0 ? 0.9 : -0.9;
                    startdef.setTheta(1, p);
                    for (i = 1; i <= spec.getP(); ++i) {
                        startdef.setPhi(i, 0.0);
                    }
                    for (i = 2; i <= spec.getQ(); ++i) {
                        startdef.setTheta(i, 0.0);
                    }
                }
                if ((mdef = this.estimate(regs, startdef)) != null) {
                    start = mhr.likelihood.getLogLikelihood() < mdef.likelihood.getLogLikelihood() ? (SarimaModel)mdef.model.getArma() : (SarimaModel)mhr.model.getArma();
                }
            }
        } else if (this.start_ == StartingPoint.Default) {
            start = regs.getArma();
            start.setDefault();
        } else {
            start = regs.getArma();
            start.setDefault(0.0, 0.0);
        }
        return this.optimize(regs, start);
    }

    public double getFinalPrecision(double value) {
        return this.feps_;
    }

    public boolean hasUsedMaximumLikelihood() {
        return this.fml_;
    }

    @Override
    public double getPrecision() {
        return this.eps_;
    }

    public Matrix getParametersCovariance() {
        return this.pcov_;
    }

    public double[] getScore() {
        return this.score_;
    }

    @Override
    public RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs) {
        SarimaModel arima = regs.getArima();
        DataBlock p = new DataBlock(this.mapping_.map(arima));
        if (this.mapping_.validate(p) == ParamValidation.Changed) {
            arima = this.mapping_.map(p);
        }
        return this.optimize(regs, (SarimaModel)arima.stationaryTransformation().stationaryModel);
    }

    protected GlsSarimaMonitor createProcessor() {
        return this.createProcessor(this.eps_);
    }

    protected GlsSarimaMonitor createProcessor(double eps) {
        GlsSarimaMonitor monitor = new GlsSarimaMonitor();
        monitor.setMinimizer(this.min_.exemplar());
        monitor.setPrecision(eps);
        monitor.useMaximumLikelihood(this.ml_);
        monitor.useLogLikelihood(this.logll_);
        monitor.setMapping(this.mapping_);
        return monitor;
    }

    protected RegArimaEstimation<SarimaModel> optimize(RegArimaModel<SarimaModel> regs, SarimaModel start) {
        this.monitor_ = null;
        this.score_ = null;
        if (this.mapping_.getDim() == 0) {
            return new RegArimaEstimation<SarimaModel>(regs, regs.computeLikelihood());
        }
        this.fml_ = this.ml_;
        this.feps_ = this.eps_;
        this.monitor_ = this.createProcessor();
        RegArimaEstimation<SarimaModel> rslt = this.monitor_.optimize(regs, start);
        if (rslt != null) {
            return this.finalProcessing(rslt);
        }
        this.fml_ = false;
        this.monitor_.useMaximumLikelihood(false);
        int iter = 0;
        do {
            this.feps_ *= 10.0;
            this.monitor_.setPrecision(this.feps_);
        } while ((rslt = this.monitor_.optimize(regs, (SarimaModel)rslt.model.getArma())) == null && ++iter < 3);
        if (rslt == null) {
            return null;
        }
        return this.finalProcessing(rslt);
    }

    protected RegArimaEstimation<SarimaModel> estimate(RegArimaModel<SarimaModel> regs, SarimaModel start) {
        if (this.mapping_.getDim() == 0) {
            return new RegArimaEstimation<SarimaModel>(regs, regs.computeLikelihood());
        }
        this.fml_ = this.ml_;
        this.feps_ = this.eps_;
        GlsSarimaMonitor monitor = this.createProcessor(1.0E-4);
        monitor.getMinimizer().setMaxIter(10);
        return monitor.optimize(regs, start);
    }

    @Override
    public void setPrecision(double value) {
        this.eps_ = value;
    }

    private RegArimaEstimation<SarimaModel> finalProcessing(RegArimaEstimation<SarimaModel> model) {
        RegArimaEstimation<SarimaModel> nmodel = this.tryUrpCancelling(model);
        RegArimaEstimation<SarimaModel> fmodel = this.tryUrmCancelling(nmodel);
        this.computepvar(this.monitor_, fmodel);
        this.score_ = this.monitor_.getScore();
        return fmodel;
    }

    private RegArimaEstimation<SarimaModel> tryUrpCancelling(RegArimaEstimation<SarimaModel> estimation) {
        double c;
        int i;
        SarimaModel arima = (SarimaModel)estimation.model.getArima();
        SarimaSpecification spec = arima.getSpecification();
        if (spec.getP() == 0 || spec.getQ() == 0 || spec.getDifferenceOrder() == 0) {
            return estimation;
        }
        DataBlock parameters = new DataBlock(arima.getParameters());
        int pstart = 0;
        int pend = spec.getP();
        double p = 0.0;
        for (int i2 = pstart; i2 < pend; ++i2) {
            p += parameters.get(i2);
        }
        if (Math.abs(p + 1.0) > 0.1) {
            return estimation;
        }
        int qstart = pend + spec.getBP();
        int qend = qstart + spec.getQ();
        double q = 0.0;
        for (int i3 = qstart; i3 < qend; ++i3) {
            q += parameters.get(i3);
        }
        if (Math.abs(q + 1.0) > 0.1) {
            return estimation;
        }
        double tmp = 0.0;
        for (i = pend - 1; i >= pstart; --i) {
            c = parameters.get(i);
            parameters.set(i, -tmp);
            tmp += c;
        }
        tmp = 0.0;
        for (i = qend - 1; i >= qstart; --i) {
            c = parameters.get(i);
            parameters.set(i, -tmp);
            tmp += c;
        }
        try {
            GlsSarimaMonitor nmonitor = this.createProcessor();
            AbstractRegArimaModel nmodel = estimation.model.clone();
            ((RegArimaModel)nmodel).setArima(((SarimaModel)((RegArimaModel)nmodel).getArima()).clone());
            this.mapping_.validate(parameters);
            ((SarimaModel)((RegArimaModel)nmodel).getArima()).setParameters(parameters);
            RegArimaEstimation<SarimaModel> nrslts = nmonitor.optimize(nmodel);
            if (nrslts.likelihood.getLogLikelihood() > estimation.likelihood.getLogLikelihood()) {
                this.monitor_ = nmonitor;
                return nrslts;
            }
            return estimation;
        }
        catch (Exception err) {
            return estimation;
        }
    }

    private RegArimaEstimation<SarimaModel> tryUrmCancelling(RegArimaEstimation<SarimaModel> estimation) {
        double c;
        int i;
        SarimaModel arima = (SarimaModel)estimation.model.getArima();
        SarimaSpecification spec = arima.getSpecification();
        if (spec.getP() == 0 || spec.getQ() == 0 || spec.getBD() == 0) {
            return estimation;
        }
        DataBlock parameters = new DataBlock(arima.getParameters());
        int pstart = 0;
        int pend = spec.getP();
        double p = 0.0;
        boolean pos = false;
        for (int i2 = pstart; i2 < pend; ++i2) {
            p += pos ? parameters.get(i2) : -parameters.get(i2);
            pos = !pos;
        }
        if (Math.abs(p + 1.0) > 0.1) {
            return estimation;
        }
        int qstart = pend + spec.getBP();
        int qend = qstart + spec.getQ();
        double q = 0.0;
        pos = false;
        for (int i3 = qstart; i3 < qend; ++i3) {
            q += pos ? parameters.get(i3) : -parameters.get(i3);
            pos = !pos;
        }
        if (Math.abs(q + 1.0) > 0.1) {
            return estimation;
        }
        double tmp = 0.0;
        for (i = pend - 1; i >= pstart; --i) {
            c = parameters.get(i);
            parameters.set(i, tmp);
            tmp = c - tmp;
        }
        tmp = 0.0;
        for (i = qend - 1; i >= qstart; --i) {
            c = parameters.get(i);
            parameters.set(i, tmp);
            tmp = c - tmp;
        }
        try {
            GlsSarimaMonitor nmonitor = this.createProcessor();
            AbstractRegArimaModel nmodel = estimation.model.clone();
            ((RegArimaModel)nmodel).setArima(((SarimaModel)((RegArimaModel)nmodel).getArima()).clone());
            this.mapping_.validate(parameters);
            ((SarimaModel)((RegArimaModel)nmodel).getArima()).setParameters(parameters);
            RegArimaEstimation<SarimaModel> nrslts = nmonitor.optimize(nmodel);
            if (nrslts.likelihood.getLogLikelihood() > estimation.likelihood.getLogLikelihood()) {
                this.monitor_ = nmonitor;
                return nrslts;
            }
            return estimation;
        }
        catch (Exception err) {
            return estimation;
        }
    }

    protected void computepvar(GlsSarimaMonitor monitor, RegArimaEstimation<SarimaModel> rslt) {
        int n = rslt.likelihood.getDegreesOfFreedom(true, this.mapping_.getDim());
        Matrix information = monitor.getObservedInformation(n);
        if (information == null) {
            return;
        }
        this.pcov_ = SymmetricMatrix.inverse(information);
        if (this.pcov_ == null) {
            return;
        }
        if (monitor.getMapping() instanceof SarimaFixedMapping) {
            SarimaFixedMapping mapping = (SarimaFixedMapping)monitor.getMapping();
            this.pcov_ = mapping.expandCovariance(this.pcov_);
        }
    }

    public static enum StartingPoint {
        Zero,
        Default,
        HannanRissanen,
        Multiple;

    }
}

