/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public final class UpperTriangularMatrix {
    public static Matrix inverse(Matrix upper) throws MatrixException {
        int n = upper.ncols_;
        Matrix rslt = Matrix.identity(n);
        DataBlockIterator cols = rslt.columns();
        DataBlock col = cols.getData();
        do {
            UpperTriangularMatrix.rsolve(upper, col);
        } while (cols.next());
        return rslt;
    }

    public static void lmul(Matrix upper, DataBlock left) {
        int nl = left.getLength();
        int n = upper.getRowsCount();
        double[] data = upper.data_;
        int i = nl - 1;
        int idx = i * n;
        while (i >= 0) {
            double t = 0.0;
            int j = 0;
            int idx2 = idx;
            while (j <= i) {
                t += data[idx2] * left.get(j);
                ++j;
                ++idx2;
            }
            left.set(i, t);
            --i;
            idx -= n;
        }
    }

    public static void lmul(Matrix upper, double[] left) {
        UpperTriangularMatrix.lmul(upper, new DataBlock(left));
    }

    public static void lmul(Matrix upper, SubMatrix left) {
        DataBlockIterator rows = left.rows();
        DataBlock row = rows.getData();
        do {
            UpperTriangularMatrix.lmul(upper, row);
        } while (rows.next());
    }

    public static void lsolve(Matrix upper, DataBlock b) throws MatrixException {
        int nb = b.getLength();
        int n = upper.getRowsCount();
        double[] data = upper.data_;
        int i = 0;
        int idx = 0;
        while (i < nb) {
            int idx2 = idx;
            double t = b.get(i);
            int j = 0;
            while (j < i) {
                t -= b.get(j) * data[idx2];
                ++j;
                ++idx2;
            }
            double d = data[idx2];
            if (d == 0.0) {
                throw new MatrixException("m_err_sing");
            }
            b.set(i, t / d);
            ++i;
            idx += n;
        }
    }

    public static void lsolve(Matrix upper, double[] b) throws MatrixException {
        UpperTriangularMatrix.lsolve(upper, new DataBlock(b));
    }

    public static void lsolve(Matrix upper, SubMatrix b) throws MatrixException {
        DataBlockIterator rows = b.rows();
        DataBlock row = rows.getData();
        do {
            UpperTriangularMatrix.lsolve(upper, row);
        } while (rows.next());
    }

    public static void rmul(Matrix upper, DataBlock r) {
        int nr = r.getLength();
        int n = upper.getColumnsCount();
        double[] data = upper.data_;
        int i = 0;
        int idx = 0;
        while (i < nr) {
            double t = 0.0;
            int j = i;
            int idx2 = idx;
            while (j < nr) {
                t += data[idx2] * r.get(j);
                ++j;
                idx2 += n;
            }
            r.set(i, t);
            ++i;
            idx += n + 1;
        }
    }

    public static void rmul(Matrix upper, double[] r) {
        UpperTriangularMatrix.rmul(upper, new DataBlock(r));
    }

    public static void rmul(Matrix upper, SubMatrix rightmatrix) {
        DataBlockIterator cols = rightmatrix.columns();
        DataBlock col = cols.getData();
        do {
            UpperTriangularMatrix.rmul(upper, col);
        } while (cols.next());
    }

    public static void rsolve(Matrix upper, DataBlock b) throws MatrixException {
        int nb = b.getLength();
        int n = upper.getColumnsCount();
        double[] data = upper.data_;
        int i = nb - 1;
        int idx = (n + 1) * (nb - 1);
        while (i >= 0) {
            int idx2 = idx;
            double t = b.get(i);
            int j = nb - 1;
            while (j > i) {
                t -= b.get(j) * data[idx2];
                --j;
                idx2 -= n;
            }
            double d = data[idx2];
            if (d == 0.0) {
                throw new MatrixException("m_err_sing");
            }
            b.set(i, t / d);
            --i;
            --idx;
        }
    }

    public static void rsolve(Matrix upper, double[] b) throws MatrixException {
        UpperTriangularMatrix.rsolve(upper, new DataBlock(b));
    }

    public static void rsolve(Matrix upper, SubMatrix b) throws MatrixException {
        DataBlockIterator cols = b.columns();
        DataBlock col = cols.getData();
        do {
            UpperTriangularMatrix.rsolve(upper, col);
        } while (cols.next());
    }

    private UpperTriangularMatrix() {
    }
}

