/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special.mixedfrequencies;

import ec.tstoolkit.arima.special.RegressionSpec;
import ec.tstoolkit.arima.special.mixedfrequencies.BasicSpec;
import ec.tstoolkit.arima.special.mixedfrequencies.EstimateSpec;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.DefaultArimaSpec;
import ec.tstoolkit.modelling.arima.IRegArimaSpecification;
import java.util.Map;
import java.util.Objects;

public class MixedFrequenciesSpecification
implements IRegArimaSpecification,
Cloneable {
    public static final String BASIC = "basic";
    public static final String ARIMA = "arima";
    public static final String REGRESSION = "regression";
    public static final String ESTIMATE = "estimate";
    private BasicSpec basic_ = new BasicSpec();
    private DefaultArimaSpec arima_ = new DefaultArimaSpec();
    private RegressionSpec regs_ = new RegressionSpec();
    private EstimateSpec estimate_ = new EstimateSpec();

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        BasicSpec.fillDictionary(InformationSet.item(prefix, BASIC), dic);
        DefaultArimaSpec.fillDictionary(InformationSet.item(prefix, ARIMA), dic);
        RegressionSpec.fillDictionary(InformationSet.item(prefix, REGRESSION), dic);
        EstimateSpec.fillDictionary(InformationSet.item(prefix, ESTIMATE), dic);
    }

    public MixedFrequenciesSpecification() {
        this.arima_.airline();
    }

    public BasicSpec getBasic() {
        return this.basic_;
    }

    public void setBasic(BasicSpec spec) {
        this.basic_ = spec;
    }

    public DefaultArimaSpec getArima() {
        return this.arima_;
    }

    public void setArima(DefaultArimaSpec spec) {
        this.arima_ = spec;
    }

    public RegressionSpec getRegression() {
        return this.regs_;
    }

    public void setRegression(RegressionSpec spec) {
        this.regs_ = spec;
    }

    public EstimateSpec getEstimate() {
        return this.estimate_;
    }

    public void setEstimate(EstimateSpec spec) {
        this.estimate_ = spec;
    }

    @Override
    public MixedFrequenciesSpecification clone() {
        try {
            MixedFrequenciesSpecification cl = (MixedFrequenciesSpecification)super.clone();
            cl.basic_ = this.basic_.clone();
            cl.arima_ = this.arima_.clone();
            cl.regs_ = this.regs_.clone();
            cl.estimate_ = this.estimate_.clone();
            return cl;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add(BASIC, this.basic_.write(verbose));
        info.add(ARIMA, this.arima_.write(verbose));
        if (verbose || this.regs_.isUsed()) {
            info.add(REGRESSION, this.regs_.write(verbose));
        }
        info.add(ESTIMATE, this.estimate_.write(verbose));
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        InformationSet cinfo = info.getSubSet(BASIC);
        if (cinfo != null) {
            this.basic_.read(cinfo);
        } else {
            this.basic_.reset();
        }
        cinfo = info.getSubSet(ARIMA);
        if (cinfo != null) {
            this.arima_.read(cinfo);
        } else {
            this.arima_.airline();
        }
        cinfo = info.getSubSet(REGRESSION);
        if (cinfo != null) {
            this.regs_.read(cinfo);
        } else {
            this.regs_.reset();
        }
        cinfo = info.getSubSet(ESTIMATE);
        if (cinfo != null) {
            this.estimate_.read(cinfo);
        } else {
            this.estimate_.reset();
        }
        return true;
    }

    public boolean equals(MixedFrequenciesSpecification other) {
        return Objects.equals(this.basic_, other.basic_) && Objects.equals(this.arima_, other.arima_) && Objects.equals(this.regs_, other.regs_) && Objects.equals(this.estimate_, other.estimate_);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MixedFrequenciesSpecification && this.equals((MixedFrequenciesSpecification)obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.basic_);
        hash = 73 * hash + Objects.hashCode(this.arima_);
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.basic_.getDataType());
        return builder.toString();
    }
}

