/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm.implementation;

import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.design.Singleton;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class TramoProcessingFactory
implements IProcessingFactory<TramoSpecification, TsData, PreprocessingModel> {
    public static final String METHOD = "tramo";
    public static final String FAMILY = "Modelling";
    public static final String VERSION = "0.1.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Modelling", "tramo", "0.1.0.0");
    public static final TramoProcessingFactory instance = new TramoProcessingFactory();

    protected TramoProcessingFactory() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    @Override
    public IProcessing<TsData, PreprocessingModel> generateProcessing(final TramoSpecification specification, final ProcessingContext context) {
        return new IProcessing<TsData, PreprocessingModel>(){
            IPreprocessor preprocessor;
            {
                this.preprocessor = specification.build(context);
            }

            @Override
            public PreprocessingModel process(TsData input) {
                ModellingContext context2 = new ModellingContext();
                return this.preprocessor.process(input, context2);
            }
        };
    }

    public IProcessing<TsData, PreprocessingModel> generateProcessing(TramoSpecification specification) {
        return this.generateProcessing(specification, (ProcessingContext)null);
    }

    @Override
    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof TramoSpecification;
    }

    @Override
    public Map<String, Class> getSpecificationDictionary(Class<TramoSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        TramoSpecification.fillDictionary(null, dic);
        return dic;
    }

    @Override
    public Map<String, Class> getOutputDictionary(boolean compact) {
        return PreprocessingModel.dictionary(compact);
    }
}

