/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import umontreal.iro.lecuyer.hups.DigitalNetBase2;
import umontreal.iro.lecuyer.hups.DigitalNetFromFile;

public class DigitalNetBase2FromFile
extends DigitalNetBase2 {
    private String filename;

    private void readData(Reader reader, int n, int n2) throws IOException, NumberFormatException {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            if (streamTokenizer == null) {
                return;
            }
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.slashSlashComments(true);
            int n3 = streamTokenizer.nextToken();
            if (n3 != -2) {
                throw new NumberFormatException();
            }
            this.b = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.numCols = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.numRows = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.numPoints = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.dim = (int)streamTokenizer.nval;
            if (this.dim < 1) {
                System.err.println("\nDigitalNetBase2FromFile:   dimension dim <= 0");
                throw new IllegalArgumentException("dimension dim <= 0");
            }
            if (n > this.numRows) {
                throw new IllegalArgumentException("DigitalNetBase2FromFile:   One must have   r1 <= Max num rows");
            }
            if (n2 > this.dim) {
                throw new IllegalArgumentException("s1 is too large");
            }
            if (n2 > 0) {
                this.dim = n2;
            }
            if (n > 0) {
                this.numRows = n;
            }
            if (this.b != 2) {
                System.err.println("***** DigitalNetBase2FromFile:    only base 2 allowed");
                throw new IllegalArgumentException("only base 2 allowed");
            }
            this.genMat = new int[this.dim * this.numCols];
            for (n3 = 0; n3 < this.dim; ++n3) {
                for (int i = 0; i < this.numCols; ++i) {
                    streamTokenizer.nextToken();
                    this.genMat[n3 * this.numCols + i] = (int)streamTokenizer.nval;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("   DigitalNetBase2FromFile:   not a number  " + numberFormatException);
            throw numberFormatException;
        }
    }

    private void maskRows(int n, int n2) {
        int n3 = (int)((1L << n) - 1L);
        n3 <<= 31 - n;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n4 = i * this.numCols + j;
                this.genMat[n4] = this.genMat[n4] & n3;
                int n5 = i * this.numCols + j;
                this.genMat[n5] = this.genMat[n5] >> 31 - n2;
            }
        }
    }

    public DigitalNetBase2FromFile(String string, int n, int n2, int n3) throws IOException, MalformedURLException {
        if (n2 < n || n2 > 31) {
            throw new IllegalArgumentException(" Must have numRows <= w <= 31");
        }
        BufferedReader bufferedReader = string.startsWith("http:") || string.startsWith("ftp:") ? DigitalNetFromFile.openURL(string) : DigitalNetFromFile.openFile(string);
        try {
            this.readData(bufferedReader, n, n3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("   DigitalNetBase2FromFile:   cannot read from   " + string);
            throw numberFormatException;
        }
        catch (IOException iOException) {
            System.err.println("   DigitalNetBase2FromFile:  cannot read from  " + string);
            throw iOException;
        }
        bufferedReader.close();
        this.maskRows(this.numRows, n2);
        this.outDigits = n2;
        if (this.numCols >= 31) {
            throw new IllegalArgumentException(" Must have numCols < 31");
        }
        this.filename = string;
        int n4 = 1 << this.numCols;
        if (n4 != this.numPoints) {
            System.out.println("numPoints != 2^k");
            throw new IllegalArgumentException("numPoints != 2^k");
        }
        this.normFactor = 1.0 / (double)(1L << this.outDigits);
    }

    public DigitalNetBase2FromFile(String string, int n) throws IOException, MalformedURLException {
        this(string, -1, 31, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("File:  " + this.filename + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public String toStringDetailed() {
        StringBuffer stringBuffer = new StringBuffer(this.toString() + "\n");
        stringBuffer.append("dim = " + this.dim + "\n");
        for (int i = 0; i < this.dim; ++i) {
            stringBuffer.append("\n// dim = " + (1 + i) + "\n");
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.genMat[i * this.numCols + j] + "\n");
            }
        }
        stringBuffer.append("--------------------------------\n");
        return stringBuffer.toString();
    }

    public static String listDir(String string) throws IOException {
        return DigitalNetFromFile.listDir(string);
    }
}

