/*
 * Decompiled with CFR 0.152.
 */
package ihm.graphique;

import ihm.Analyse;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javalain.math.Calcul;
import javax.swing.JPanel;
import util.GuiUtils;

public class EstimateurNoyau
extends JPanel {
    private final int echelle_fenetre = 100;
    private final int marge = 20;
    private Analyse frAnalyse;
    private double[] donnees_x;
    private double ecart_type;
    private double moyenne;
    private int largeur;
    private int hauteur;
    private int centre_y;
    private double unite_x;
    private double x_min;
    private double x_max;
    private double y_min;
    private double y_max;
    private boolean atypique;
    private int valAtypique;
    private boolean selection = false;
    private boolean en_selection = false;
    private int x_debut;
    private int x_fin;
    public double x0;
    public double x1;
    private static final int NB = 500;
    private double[] donnees_y = new double[500];

    public EstimateurNoyau(int l, int h, boolean atypique, boolean selection_souris, Analyse analyse) {
        this.largeur = l * this.echelle_fenetre + 2 * this.marge;
        this.hauteur = h * this.echelle_fenetre + 2 * this.marge;
        this.setMinimumSize(new Dimension(this.largeur, this.hauteur));
        this.setPreferredSize(new Dimension(this.largeur, this.hauteur));
        this.centre_y = this.hauteur - 1 - this.marge;
        this.atypique = atypique;
        this.frAnalyse = analyse;
        if (selection_souris) {
            ComportementSouris souris = new ComportementSouris();
            this.addMouseListener(souris);
            this.addMouseMotionListener(souris);
        }
    }

    public double getBorneInfSelect() {
        return this.x0;
    }

    public double getBorneSupSelect() {
        return this.x1;
    }

    public boolean isSelection() {
        return this.selection;
    }

    public void setSelection(boolean b, double x0, double x1) {
        this.selection = b;
        this.x0 = x0;
        this.x1 = x1;
        this.x_debut = (int)((x0 - this.x_min) * this.unite_x + 20.0);
        this.x_fin = (int)((x1 - this.x_min) * this.unite_x + 20.0);
    }

    public double[] getDonnees() {
        return this.donnees_x;
    }

    public void setProjection(double[] a) {
        if (this.donnees_x == null || this.donnees_x.length != a.length) {
            this.donnees_x = new double[a.length];
        }
        System.arraycopy(a, 0, this.donnees_x, 0, a.length);
        this.ecart_type = Calcul.ecartType(this.donnees_x);
        this.moyenne = Calcul.moyenne(this.donnees_x);
        this.x_min = Double.POSITIVE_INFINITY;
        this.x_max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.donnees_x.length; ++i) {
            if (this.donnees_x[i] < this.x_min) {
                this.x_min = this.donnees_x[i];
                continue;
            }
            if (!(this.donnees_x[i] > this.x_max)) continue;
            this.x_max = this.donnees_x[i];
        }
        this.unite_x = (float)(this.largeur - 2 * this.marge) / (float)(this.x_max - this.x_min);
        double etendue = this.x_max - this.x_min;
        double fenetre = EstimateurNoyau.Fenetre(etendue);
        this.y_min = Double.POSITIVE_INFINITY;
        this.y_max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 500; ++i) {
            double somme = 0.0;
            this.donnees_y[i] = this.x_min + (double)i * etendue / 499.0;
            for (int j = 0; j < this.donnees_x.length; ++j) {
                somme += EstimateurNoyau.Noyau((this.donnees_y[i] - this.donnees_x[j]) / fenetre);
            }
            this.donnees_y[i] = somme / ((double)this.donnees_x.length * fenetre);
            if (this.donnees_y[i] < this.y_min) {
                this.y_min = this.donnees_y[i];
                continue;
            }
            if (!(this.donnees_y[i] > this.y_max)) continue;
            this.y_max = this.donnees_y[i];
        }
        this.selection = false;
        this.en_selection = false;
    }

    public void setValeurAtypiques(int i) {
        this.valAtypique = i;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(GuiUtils.GRIS_238);
        g.fillRect(0, 0, this.largeur, this.hauteur);
        int axe_x_min = (int)this.x_min + (this.x_min < 0.0 ? 0 : 1);
        int axe_x_max = (int)this.x_max + (this.x_max > 0.0 ? 0 : -1);
        int lg_x = axe_x_max - axe_x_min + 1;
        int decal_x = (int)(Math.abs(this.x_min - (double)axe_x_min) * this.unite_x) + this.marge;
        int pas_x = 1;
        if (lg_x >= 10) {
            pas_x = lg_x >= 20 ? lg_x / 10 : 2;
        }
        g.setFont(GuiUtils.FONT_11);
        g.setColor(Color.GRAY);
        g.drawLine(this.marge, this.centre_y, this.largeur - 1 - this.marge, this.centre_y);
        for (int i = 0; i < lg_x; ++i) {
            if (i % pas_x != 0) continue;
            g.drawLine(decal_x + (int)((double)i * this.unite_x), this.centre_y - 3, decal_x + (int)((double)i * this.unite_x), this.centre_y + 3);
            g.drawString("" + (i + axe_x_min), decal_x + (int)((double)i * this.unite_x), this.centre_y + 15);
        }
        double d0 = this.moyenne + this.ecart_type * (double)this.valAtypique;
        double d1 = this.moyenne - this.ecart_type * (double)this.valAtypique;
        float echelleX = (float)(this.largeur - 2 * this.marge) / 500.0f;
        float echelleY = (float)(this.hauteur - 2 * this.marge) / (float)(this.y_max - this.y_min);
        for (int i = 0; i < 499; ++i) {
            if (this.atypique && ((double)((float)i * echelleX) > (d0 - this.x_min) * this.unite_x || (double)((float)(i + 1) * echelleX) < (d1 - this.x_min) * this.unite_x)) {
                g.setColor(Color.ORANGE);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawLine((int)((float)i * echelleX) + this.marge, this.centre_y - (int)((this.donnees_y[i] - this.y_min) * (double)echelleY), (int)((float)(i + 1) * echelleX) + this.marge, this.centre_y - (int)((this.donnees_y[i + 1] - this.y_min) * (double)echelleY));
        }
        g.setFont(GuiUtils.FONT_11);
        g.setColor(Color.GRAY);
        g.drawString(GuiUtils.DECIMAL_3.format(this.x_min), this.marge, this.hauteur - this.marge - 5);
        g.drawString(GuiUtils.DECIMAL_3.format(this.x_max), this.largeur - 1 - this.marge - 25, this.centre_y - 5);
        if (this.en_selection || this.selection) {
            g.setColor(Color.BLACK);
            g.drawLine(this.x_debut, this.centre_y - 8, this.x_debut, this.centre_y + 8);
            g.drawLine(this.x_fin, this.centre_y - 8, this.x_fin, this.centre_y + 8);
            g.drawRect(this.x_debut - 3, this.centre_y - 3, 6, 6);
            g.drawRect(this.x_fin - 3, this.centre_y - 3, 6, 6);
            g.drawString(GuiUtils.DECIMAL_2.format(this.x0), this.x_debut - 3, this.centre_y - 10);
            g.drawString(GuiUtils.DECIMAL_2.format(this.x1), this.x_fin - 3, this.centre_y - 10);
        }
    }

    private static double Fenetre(double etendue) {
        return etendue * 0.1;
    }

    private static double Noyau(double d) {
        double triweight = 1.09375;
        triweight = d >= -1.0 && d <= 1.0 ? triweight * (1.0 - Calcul.pow2(d)) * Calcul.pow2(1.0 - Calcul.pow2(d)) : 0.0;
        return triweight;
    }

    final class ComportementSouris
    extends MouseAdapter {
        ComportementSouris() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            EstimateurNoyau.this.selection = false;
            EstimateurNoyau.this.en_selection = true;
            EstimateurNoyau.this.x_debut = evt.getX();
            EstimateurNoyau.this.x_fin = EstimateurNoyau.this.x_debut;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            EstimateurNoyau.this.en_selection = false;
            if (EstimateurNoyau.this.x_debut == EstimateurNoyau.this.x_fin) {
                EstimateurNoyau.this.selection = false;
                EstimateurNoyau.this.x_debut = 0;
                EstimateurNoyau.this.x_fin = 0;
                EstimateurNoyau.this.repaint();
                EstimateurNoyau.this.frAnalyse.setEnabledSaveSelection(false);
            } else {
                EstimateurNoyau.this.frAnalyse.setEnabledSaveSelection(true);
            }
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (EstimateurNoyau.this.en_selection) {
                EstimateurNoyau.this.selection = true;
                EstimateurNoyau.this.x_fin = evt.getX();
                EstimateurNoyau.this.x0 = (double)(EstimateurNoyau.this.x_debut - 20) / EstimateurNoyau.this.unite_x + EstimateurNoyau.this.x_min;
                EstimateurNoyau.this.x1 = (double)(EstimateurNoyau.this.x_fin - 20) / EstimateurNoyau.this.unite_x + EstimateurNoyau.this.x_min;
                EstimateurNoyau.this.repaint();
            }
        }
    }
}

