/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.multicast;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;

public class MulticastOutputStream
extends OutputStream {
    public static final int BUFFER_SIZE = 2048;
    private MulticastSocket socket;
    private InetAddress group;
    private int port;
    private byte[] packetBuffer;
    private ByteBuffer writeBuffer;

    public MulticastOutputStream(MulticastSocket socket, int port, InetAddress group) {
        this.socket = socket;
        this.group = group;
        this.port = port;
        this.packetBuffer = new byte[2048];
        this.writeBuffer = ByteBuffer.allocate(2048);
        this.writeBuffer.clear();
    }

    public void flush() {
        this.writeBuffer.flip();
        if (this.writeBuffer.hasRemaining()) {
            try {
                byte[] data = new byte[this.writeBuffer.remaining()];
                this.writeBuffer.get(data);
                this.socket.send(new DatagramPacket(data, data.length, this.group, this.port));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.writeBuffer.clear();
    }

    public void write(byte[] b, int off, int len) {
        this.writeBuffer.put(b, off, len);
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(int b) {
        this.writeBuffer.put((byte)b);
    }
}

