/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.multicast;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.openfast.session.Connection;
import org.openfast.session.multicast.MulticastInputStream;
import org.openfast.session.multicast.MulticastOutputStream;

public class MulticastConnection
implements Connection {
    protected MulticastOutputStream outputStream;
    protected MulticastSocket socket;
    protected int port;
    protected InetAddress group;

    public MulticastConnection(MulticastSocket socket, int port, InetAddress group) {
        this.socket = socket;
        this.port = port;
        this.group = group;
    }

    public void close() {
        try {
            this.socket.leaveGroup(this.group);
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        return new MulticastInputStream(this.socket);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new MulticastOutputStream(this.socket, this.port, this.group);
        }
        return this.outputStream;
    }
}

