/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.tmplexch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.openfast.examples.Assert;
import org.openfast.examples.OpenFastExample;
import org.openfast.examples.tmplexch.TemplateExchangeDefinitionEncoder;

public class EncodeMain
extends OpenFastExample {
    private static Options options = new Options();

    static {
        options.addOption("?", "help", false, "Displays this message");
        options.addOption("e", "error", false, "Show stacktrace information");
        options.addOption("n", "ns", false, "Enables namespace awareness");
        options.addOption("t", "template", true, "Message template definition file");
        options.addOption("o", "output", true, "FAST Encoded output file");
    }

    public static void main(String[] args) {
        CommandLine cl = EncodeMain.parseCommandLine("consumer", args, options);
        if (cl.hasOption("help")) {
            EncodeMain.displayHelp("consumer", options);
        }
        boolean showStacktrace = cl.hasOption("error");
        File templatesFile = null;
        try {
            templatesFile = EncodeMain.getFile(cl, "template");
            Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(templatesFile.canRead(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is not readable.");
        }
        catch (AssertionError e) {
            System.out.println(((Throwable)((Object)e)).getMessage());
            EncodeMain.displayHelp("consumer", options);
        }
        OutputStream out = System.out;
        File outFile = null;
        if (cl.hasOption("output")) {
            try {
                outFile = EncodeMain.getFile(cl, "output");
                if (!outFile.exists()) {
                    outFile.createNewFile();
                }
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                System.out.println("Unable to create output file.");
                System.exit(1);
            }
            catch (IOException e) {
                System.out.println("Unable to create output file.");
                System.exit(1);
            }
        }
        TemplateExchangeDefinitionEncoder tmplExchanger = new TemplateExchangeDefinitionEncoder(templatesFile, cl.hasOption("ns"), out);
        try {
            try {
                tmplExchanger.start();
                if (cl.hasOption("output")) {
                    System.out.println("Templates encoded to file " + outFile.getAbsolutePath() + ".");
                }
            }
            catch (IOException e) {
                if (showStacktrace) {
                    e.printStackTrace();
                }
                System.out.println("An IO error occurred while consuming messages: " + e.getMessage());
                System.exit(1);
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

