/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.decoder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.openfast.Context;
import org.openfast.Global;
import org.openfast.Message;
import org.openfast.MessageBlockReader;
import org.openfast.MessageInputStream;
import org.openfast.error.FastConstants;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class FastMessageDecoder {
    private final TemplateRegistry templateRegistry;
    private final File fastDataFile;
    private final int readOffset;
    private boolean trace;
    private MessageBlockReader blockReader = MessageBlockReader.NULL;

    public FastMessageDecoder(File fastDataFile, File templatesFile, boolean namespaceAware) {
        this(fastDataFile, templatesFile, namespaceAware, 0);
    }

    public FastMessageDecoder(File fastDataFile, File templatesFile, boolean namespaceAware, int readOffset) {
        this.readOffset = readOffset;
        this.fastDataFile = fastDataFile;
        Global.setErrorHandler(FastConstants.BASIC_ERROR_HANDLER);
        XMLMessageTemplateLoader loader = new XMLMessageTemplateLoader(namespaceAware);
        loader.setLoadTemplateIdFromAuxId(true);
        try {
            loader.load(new FileInputStream(templatesFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.templateRegistry = loader.getTemplateRegistry();
    }

    public void start() throws IOException {
        Context context = new Context();
        context.setTraceEnabled(this.trace);
        context.startTrace();
        context.setTemplateRegistry(this.templateRegistry);
        FileInputStream fileIn = null;
        try {
            Message message;
            fileIn = new FileInputStream(this.fastDataFile);
            MessageInputStream messageIn = new MessageInputStream(fileIn, context);
            messageIn.setBlockReader(this.blockReader);
            while ((message = messageIn.readMessage()) != null) {
                System.out.println(message.toString());
            }
        }
        finally {
            if (fileIn != null) {
                ((InputStream)fileIn).close();
            }
        }
    }

    public void setTraceEnabled() {
        this.trace = true;
    }

    public void setBlockReader(MessageBlockReader messageBlockReader) {
        this.blockReader = messageBlockReader;
    }
}

