/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openfast.ByteUtil;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageBlockReader;
import org.openfast.MessageHandler;
import org.openfast.MessageStream;
import org.openfast.codec.FastDecoder;
import org.openfast.logging.FastMessageLogger;
import org.openfast.template.MessageTemplate;
import org.openfast.template.TemplateRegisteredListener;
import org.openfast.template.TemplateRegistry;

public class MessageInputStream
implements MessageStream {
    private final InputStream in;
    private final FastDecoder decoder;
    private final Context context;
    private Map templateHandlers = Collections.EMPTY_MAP;
    private List handlers = Collections.EMPTY_LIST;
    private MessageBlockReader blockReader = MessageBlockReader.NULL;

    public MessageInputStream(InputStream inputStream) {
        this(inputStream, new Context());
    }

    public MessageInputStream(InputStream inputStream, Context context) {
        this.in = inputStream;
        this.context = context;
        this.decoder = new FastDecoder(context, this.in);
    }

    public Message readMessage() {
        boolean keepReading;
        if (this.context.isTraceEnabled()) {
            this.context.startTrace();
        }
        if (!(keepReading = this.blockReader.readBlock(this.in))) {
            return null;
        }
        Message message = this.decoder.readMessage();
        if (message == null) {
            return null;
        }
        this.getContext().getLogger().log(message, ByteUtil.EMPTY, FastMessageLogger.Direction.INBOUND);
        this.blockReader.messageRead(this.in, message);
        if (!this.handlers.isEmpty()) {
            int i = 0;
            while (i < this.handlers.size()) {
                ((MessageHandler)this.handlers.get(i)).handleMessage(message, this.context, this.decoder);
                ++i;
            }
        }
        if (this.templateHandlers.containsKey(message.getTemplate())) {
            MessageHandler handler = (MessageHandler)this.templateHandlers.get(message.getTemplate());
            handler.handleMessage(message, this.context, this.decoder);
            return this.readMessage();
        }
        return message;
    }

    public void registerTemplate(int templateId, MessageTemplate template) {
        this.context.registerTemplate(templateId, template);
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getUnderlyingStream() {
        return this.in;
    }

    public void addMessageHandler(MessageTemplate template, MessageHandler handler) {
        if (this.templateHandlers == Collections.EMPTY_MAP) {
            this.templateHandlers = new HashMap();
        }
        this.templateHandlers.put(template, handler);
    }

    public void addMessageHandler(MessageHandler handler) {
        if (this.handlers == Collections.EMPTY_LIST) {
            this.handlers = new ArrayList(4);
        }
        this.handlers.add(handler);
    }

    public void setTemplateRegistry(TemplateRegistry registry) {
        this.context.setTemplateRegistry(registry);
    }

    public TemplateRegistry getTemplateRegistry() {
        return this.context.getTemplateRegistry();
    }

    public void addTemplateRegisteredListener(TemplateRegisteredListener templateRegisteredListener) {
    }

    public void reset() {
        this.decoder.reset();
    }

    public Context getContext() {
        return this.context;
    }

    public void setBlockReader(MessageBlockReader messageBlockReader) {
        this.blockReader = messageBlockReader;
    }
}

