/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression;

import me.lemire.integercompression.BitPacking;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.IntegerCODEC;
import me.lemire.integercompression.SkippableIntegerCODEC;
import me.lemire.integercompression.Util;

public final class BinaryPacking
implements IntegerCODEC,
SkippableIntegerCODEC {
    static final int BLOCK_SIZE = 32;

    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if ((inlength = Util.greatestMultiple(inlength, 32)) == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        this.headlessCompress(in, inpos, inlength, out, outpos);
    }

    public void headlessCompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        inlength = Util.greatestMultiple(inlength, 32);
        int tmpoutpos = outpos.get();
        int s = inpos.get();
        while (s + 128 - 1 < inpos.get() + inlength) {
            int mbits1 = Util.maxbits(in, s, 32);
            int mbits2 = Util.maxbits(in, s + 32, 32);
            int mbits3 = Util.maxbits(in, s + 64, 32);
            int mbits4 = Util.maxbits(in, s + 96, 32);
            out[tmpoutpos++] = mbits1 << 24 | mbits2 << 16 | mbits3 << 8 | mbits4;
            BitPacking.fastpackwithoutmask(in, s, out, tmpoutpos, mbits1);
            BitPacking.fastpackwithoutmask(in, s + 32, out, tmpoutpos += mbits1, mbits2);
            BitPacking.fastpackwithoutmask(in, s + 64, out, tmpoutpos += mbits2, mbits3);
            BitPacking.fastpackwithoutmask(in, s + 96, out, tmpoutpos += mbits3, mbits4);
            tmpoutpos += mbits4;
            s += 128;
        }
        while (s < inpos.get() + inlength) {
            int mbits = Util.maxbits(in, s, 32);
            out[tmpoutpos++] = mbits;
            BitPacking.fastpackwithoutmask(in, s, out, tmpoutpos, mbits);
            tmpoutpos += mbits;
            s += 32;
        }
        inpos.add(inlength);
        outpos.set(tmpoutpos);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int outlength = in[inpos.get()];
        inpos.increment();
        this.headlessUncompress(in, inpos, inlength, out, outpos, outlength);
    }

    public void headlessUncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos, int num) {
        int outlength = Util.greatestMultiple(num, 32);
        int tmpinpos = inpos.get();
        int s = outpos.get();
        while (s + 128 - 1 < outpos.get() + outlength) {
            int mbits1 = in[tmpinpos] >>> 24;
            int mbits2 = in[tmpinpos] >>> 16 & 0xFF;
            int mbits3 = in[tmpinpos] >>> 8 & 0xFF;
            int mbits4 = in[tmpinpos] & 0xFF;
            BitPacking.fastunpack(in, ++tmpinpos, out, s, mbits1);
            BitPacking.fastunpack(in, tmpinpos += mbits1, out, s + 32, mbits2);
            BitPacking.fastunpack(in, tmpinpos += mbits2, out, s + 64, mbits3);
            BitPacking.fastunpack(in, tmpinpos += mbits3, out, s + 96, mbits4);
            tmpinpos += mbits4;
            s += 128;
        }
        while (s < outpos.get() + outlength) {
            int mbits = in[tmpinpos];
            BitPacking.fastunpack(in, ++tmpinpos, out, s, mbits);
            tmpinpos += mbits;
            s += 32;
        }
        outpos.add(outlength);
        inpos.set(tmpinpos);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

