/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.Position;
import com.portfolioeffect.quant.client.result.LazyMetric;
import com.portfolioeffect.quant.client.util.LazyMetricBuilder;
import com.portfolioeffect.quant.client.util.SimpleLazyMetricBuilder;
import java.lang.reflect.Type;
import java.util.HashMap;

public class LinearForecastBuilder
extends LazyMetricBuilder {
    private String seasonInterval = "";
    private Portfolio portfolio;
    private String forecastModel = "";
    private LazyMetric dependentVariable;

    public LinearForecastBuilder(String jsonStr) {
        this();
        this.setParam(jsonStr);
    }

    public LinearForecastBuilder() {
        this.setParam("metric", "LINEAR_REGRESSION");
        this.setParam("valueType", "forecast");
    }

    public LinearForecastBuilder(LinearForecastBuilder builder) {
        super(builder);
        this.seasonInterval = builder.seasonInterval;
        this.portfolio = builder.portfolio;
        this.forecastModel = builder.forecastModel;
        this.dependentVariable = builder.dependentVariable;
    }

    public LazyMetric build() throws ComputeErrorException {
        this.makeForBuild();
        return super.build(this.portfolio);
    }

    private void makeForBuild() throws ComputeErrorException {
        if (this.forecastModel != null && this.forecastModel.length() > 0) {
            Gson gson = new Gson();
            Type type = new TypeToken<HashMap<String, String>[]>(){}.getType();
            HashMap[] model = (HashMap[])gson.fromJson(this.forecastModel, type);
            if (this.dependentVariable == null) {
                throw new ComputeErrorException("dependent variable is not set");
            }
            LazyMetricBuilder independentVariableBuilder = this.dependentVariable.getLazyMetricBuilder();
            Position position = this.dependentVariable.getPosition();
            for (HashMap e : model) {
                if (e.containsKey("forecastModelParam")) {
                    e.remove("forecastModelParam");
                    this.setParam(e);
                    continue;
                }
                independentVariableBuilder.setParam(e);
                if (position == null) {
                    this.addIndependentVariable(independentVariableBuilder.build(this.portfolio));
                    continue;
                }
                this.addIndependentVariable(independentVariableBuilder.build(position));
            }
            this.forecastModel = "";
        }
        if (this.seasonInterval.length() > 0) {
            SimpleLazyMetricBuilder seasonBuilder = new SimpleLazyMetricBuilder();
            seasonBuilder.setMetricName("SEASONALITY");
            seasonBuilder.setSeasonInterval(this.seasonInterval);
            LazyMetric season = seasonBuilder.build(this.portfolio);
            try {
                this.addIndependentVariable(season);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LazyMetric build(boolean isLeftOffCompute) throws ComputeErrorException {
        this.makeForBuild();
        return super.build(this.portfolio, isLeftOffCompute);
    }

    public String buildStrRequest() throws ComputeErrorException {
        this.makeForBuild();
        return super.buildStrRequest(this.portfolio);
    }

    public LinearForecastBuilder setTransform(String value) {
        this.setParam("transform", value);
        return this;
    }

    public LinearForecastBuilder setRegressionUpdateInterval(String value) {
        this.setParam("regressionUpdateInterval", value);
        return this;
    }

    public LinearForecastBuilder setValueType(String value) {
        this.setParam("valueType", value);
        return this;
    }

    public LinearForecastBuilder setTimeShiftEnable(boolean value) {
        super.setParam("timeShift", "" + value);
        return this;
    }

    public LinearForecastBuilder setRollingWindow(String value) {
        this.setParam("rollingWindow", value);
        return this;
    }

    public LinearForecastBuilder setForecastStep(String value) {
        super.setParam("forecastStep", value);
        return this;
    }

    public LinearForecastBuilder addIndependentVariable(LazyMetric value) throws ComputeErrorException {
        this.addToList("independentVariable", value);
        return this;
    }

    public LinearForecastBuilder setDependentVariable(LazyMetric value) throws ComputeErrorException {
        this.portfolio = value.getPortfolio();
        this.dependentVariable = value;
        this.setParam("dependentVariable", value);
        this.setParam("metricType", value.getLazyMetricBuilder().getParam("metricType"));
        return this;
    }

    public LinearForecastBuilder setSeasonInterval(String value) {
        this.seasonInterval = value;
        return this;
    }

    public LinearForecastBuilder setForecastModel(String modelStr) {
        this.forecastModel = modelStr;
        return this;
    }
}

