## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

library(IFAA)

## ----eval=FALSE---------------------------------------------------------------
#  install.packages("IFAA", repos = "http://cran.us.r-project.org")

## ----eval=FALSE---------------------------------------------------------------
#  require(devtools)
#  devtools::install_github("gitlzg/IFAA")

## -----------------------------------------------------------------------------
library(IFAA)

data(dataM)
dim(dataM)
dataM[1:5, 1:8]

data(dataC)
dim(dataC)
dataC[1:3, ]

## ---- eval=T------------------------------------------------------------------
results <- IFAA(MicrobData = dataM,
                CovData = dataC,
                linkIDname = "id",
                testCov = c("v1"),
                ctrlCov = c("v2","v3"),
                fdrRate = 0.15)

## ----eval=T-------------------------------------------------------------------
results$sig_results

## ----eval=T-------------------------------------------------------------------
results$covariatesData[1:10,]

## -----------------------------------------------------------------------------
data(dataM)
dim(dataM)
dataM[1:5, 1:8]

data(dataC)
dim(dataC)
dataC[1:3, ]

## ---- eval=T------------------------------------------------------------------
results <- MZILN(MicrobData = dataM,
                CovData = dataC,
                 linkIDname = "id",
                 targetTaxa = "rawCount18",
                 refTaxa=c("rawCount11"),
                 allCov=c("v1","v2","v3"),
                 fdrRate=0.15)

## ----eval=T-------------------------------------------------------------------
results$targettaxa_result_list

## ----eval=T-------------------------------------------------------------------
results$sig_results

## ----eval=T-------------------------------------------------------------------
results$covariatesData[1:10,]

