/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;

public class LinearEquations {
    private double[][] rows;
    private Vector[] solutions;

    public LinearEquations(double[][] dArray, double[][] dArray2) throws IllegalDimension {
        int n = dArray.length;
        if (dArray[0].length != n) {
            throw new IllegalDimension("Illegal system: a" + n + " by " + dArray[0].length + " matrix is not a square matrix");
        }
        if (dArray2[0].length != n) {
            throw new IllegalDimension("Illegal system: a " + n + " by " + n + " matrix cannot build a system with a " + dArray2[0].length + "-dimensional vector");
        }
        this.rows = new double[n][n + dArray2.length];
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.rows[i][n2] = dArray[i][n2];
            }
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                this.rows[i][n + n2] = dArray2[n2][i];
            }
        }
    }

    public LinearEquations(double[][] dArray, double[] dArray2) throws IllegalDimension {
        int n = dArray.length;
        if (dArray[0].length != n) {
            throw new IllegalDimension("Illegal system: a" + n + " by " + dArray[0].length + " matrix is not a square matrix");
        }
        if (dArray2.length != n) {
            throw new IllegalDimension("Illegal system: a " + n + " by " + n + " matrix cannot build a system with a " + dArray2.length + "-dimensional vector");
        }
        this.rows = new double[n][n + 1];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.rows[i][j] = dArray[i][j];
            }
            this.rows[i][n] = dArray2[i];
        }
    }

    public LinearEquations(Matrix matrix, Vector vector) throws IllegalDimension {
        this(matrix.components, vector.components);
    }

    private void backSubstitution(int n) throws ArithmeticException {
        int n2 = this.rows.length;
        double[] dArray = new double[n2];
        for (int i = n2 - 1; i >= 0; --i) {
            double d = this.rows[i][n2 + n];
            for (int j = i + 1; j < n2; ++j) {
                d -= dArray[j] * this.rows[i][j];
            }
            dArray[i] = d / this.rows[i][i];
        }
        this.solutions[n] = new Vector(dArray);
    }

    private int largestPivot(int n) {
        double d = Math.abs(this.rows[n][n]);
        int n2 = n;
        for (int i = n + 1; i < this.rows.length; ++i) {
            double d2 = Math.abs(this.rows[i][n]);
            if (!(d2 > d)) continue;
            n2 = i;
            d = d2;
        }
        return n2;
    }

    private void pivot(int n) throws ArithmeticException {
        double d = 1.0 / this.rows[n][n];
        int n2 = this.rows.length;
        int n3 = this.rows[0].length;
        for (int i = n + 1; i < n2; ++i) {
            double d2 = d * this.rows[i][n];
            for (int j = n; j < n3; ++j) {
                double[] dArray = this.rows[i];
                int n4 = j;
                dArray[n4] = dArray[n4] - this.rows[n][j] * d2;
            }
        }
    }

    private void pivotingStep(int n) {
        this.swapRows(n, this.largestPivot(n));
        this.pivot(n);
    }

    public Vector solution() throws ArithmeticException {
        return this.solution(0);
    }

    public Vector solution(int n) throws ArithmeticException {
        if (this.solutions == null) {
            this.solve();
        }
        if (this.solutions[n] == null) {
            this.backSubstitution(n);
        }
        return this.solutions[n];
    }

    private void solve() throws ArithmeticException {
        int n = this.rows.length;
        for (int i = 0; i < n; ++i) {
            this.pivotingStep(i);
        }
        this.solutions = new Vector[this.rows[0].length - n];
    }

    private void swapRows(int n, int n2) {
        if (n != n2) {
            int n3 = this.rows[n].length;
            for (int i = 0; i < n3; ++i) {
                double d = this.rows[n][i];
                this.rows[n][i] = this.rows[n2][i];
                this.rows[n2][i] = d;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'[', ' '};
        int n = this.rows.length;
        int n2 = this.rows[0].length;
        for (int i = 0; i < n; ++i) {
            int n3;
            cArray[0] = 40;
            for (n3 = 0; n3 < n; ++n3) {
                stringBuffer.append(cArray);
                stringBuffer.append(this.rows[i][n3]);
                cArray[0] = 44;
            }
            cArray[0] = 58;
            for (n3 = n; n3 < n2; ++n3) {
                stringBuffer.append(cArray);
                stringBuffer.append(this.rows[i][n3]);
                cArray[0] = 44;
            }
            stringBuffer.append(')');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

