/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.Filter;
import dr.inference.trace.Trace;
import dr.inference.trace.TraceList;

public abstract class FilteredTraceList
implements TraceList {
    protected boolean[] filtered;

    protected void initFlag() {
        if (this.getTrace(0) == null) {
            throw new RuntimeException("Cannot initial filters ! getTrace(0) failed !");
        }
        this.filtered = new boolean[this.getTrace(0).getValueCount()];
    }

    protected void updateFlag() {
        if (this.filtered == null) {
            this.initFlag();
        }
        for (int i = 0; i < this.getTraceCount(); ++i) {
            Trace trace = this.getTrace(i);
            Filter filter = trace.getFilter();
            if (filter == null) continue;
            if (trace.getValueCount() != this.filtered.length) {
                throw new RuntimeException("Invalid value size in Trace " + this.getTraceName(i));
            }
            for (int j = 0; j < trace.getValueCount(); ++j) {
                if (filter.isIn(trace.getValue(j))) continue;
                this.filtered[j] = true;
            }
        }
    }

    public boolean hasAnyFilter() {
        for (int i = 0; i < this.getTraceCount(); ++i) {
            if (this.getTrace(i).getFilter() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasFilter(int n) {
        return this.getTrace(n).getFilter() != null;
    }

    public void setFilter(int n, Filter filter) {
        if (this.filtered == null) {
            this.initFlag();
        }
        this.getTrace(n).setFilter(filter);
        this.refreshStatistics();
    }

    public Filter getFilter(int n) {
        Filter filter = this.getTrace(n).getFilter();
        if (this.filtered == null && filter != null) {
            throw new RuntimeException("The filter applied, but flag filtered[] is null ! " + this.getTraceName(n));
        }
        return filter;
    }

    public void removeFilter(int n) {
        this.getTrace(n).setFilter(null);
        this.refreshStatistics();
    }

    public void removeAllFilters() {
        for (int i = 0; i < this.getTraceCount(); ++i) {
            this.getTrace(i).setFilter(null);
        }
        this.filtered = null;
        this.refreshStatistics();
    }

    protected void refreshStatistics() {
        this.updateFlag();
        for (int i = 0; i < this.getTraceCount(); ++i) {
            this.analyseTrace(i);
        }
    }
}

