/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.datatype.DataType;
import dr.evolution.sequence.Sequence;
import dr.evolution.util.Taxon;
import dr.util.NumberFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class WrappedAlignment
extends Alignment.Abstract {
    protected Alignment alignment = null;

    protected WrappedAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public abstract int getState(int var1, int var2);

    @Override
    public double[] getUncertainState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainState not implemented yet");
    }

    @Override
    public void setDataType(DataType dataType) {
    }

    @Override
    public String getAlignedSequenceString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getSiteCount();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(this.getDataType().getChar(this.getState(n, i)));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getUnalignedSequenceString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getSiteCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getState(n, i);
            if (this.getDataType().isGapState(n3)) continue;
            stringBuffer.append(this.getDataType().getChar(n3));
        }
        return stringBuffer.toString();
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("getUncertainPattern not implemented yet");
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new UnsupportedOperationException("getUncertainPatternState not implemented yet");
    }

    @Override
    public DataType getDataType() {
        return this.alignment.getDataType();
    }

    @Override
    public boolean areUncertain() {
        return false;
    }

    @Override
    public int getSiteCount() {
        return this.alignment.getSiteCount();
    }

    @Override
    public int[] getSitePattern(int n) {
        int n2 = this.getSequenceCount();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.getState(i, n);
        }
        return nArray;
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        throw new UnsupportedOperationException("getUncertainSitePattern not implemented yet");
    }

    @Override
    public int getPatternIndex(int n) {
        return this.alignment.getPatternIndex(n);
    }

    @Override
    public int getSequenceCount() {
        return this.alignment.getSequenceCount();
    }

    @Override
    public Sequence getSequence(int n) {
        return this.alignment.getSequence(n);
    }

    @Override
    public void setSequenceAttribute(int n, String string, Object object) {
        this.alignment.setSequenceAttribute(n, string, object);
    }

    @Override
    public Object getSequenceAttribute(int n, String string) {
        return this.alignment.getSequenceAttribute(n, string);
    }

    @Override
    public int getTaxonCount() {
        return this.alignment.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.alignment.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.alignment.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        return this.alignment.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        return this.alignment.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    public String toString() {
        NumberFormatter numberFormatter = new NumberFormatter(6);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            String string = numberFormatter.formatToFieldWidth(this.getTaxonId(i), 10);
            stringBuffer.append(">").append(string).append("\n");
            stringBuffer.append(this.getAlignedSequenceString(i)).append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < WrappedAlignment.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return WrappedAlignment.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        return this.alignment.getTaxonAttribute(n, string);
    }
}

