/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.SentinelCheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.SequenceNumberValidator;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Comparator;

class CheckpointValueComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final BigInteger TRIM_HORIZON_BIG_INTEGER_VALUE = BigInteger.valueOf(-2L);
    private static final BigInteger LATEST_BIG_INTEGER_VALUE = BigInteger.valueOf(-1L);

    CheckpointValueComparator() {
    }

    @Override
    public int compare(String first, String second) {
        if (!CheckpointValueComparator.isDigitsOrSentinelValue(first) || !CheckpointValueComparator.isDigitsOrSentinelValue(second)) {
            throw new IllegalArgumentException("Expected a sequence number or a sentinel checkpoint value but received: first=" + first + " and second=" + second);
        }
        if (SentinelCheckpoint.SHARD_END.toString().equals(first) && SentinelCheckpoint.SHARD_END.toString().equals(second)) {
            return 0;
        }
        if (SentinelCheckpoint.SHARD_END.toString().equals(second)) {
            return -1;
        }
        if (SentinelCheckpoint.SHARD_END.toString().equals(first)) {
            return 1;
        }
        return CheckpointValueComparator.bigIntegerValue(first).compareTo(CheckpointValueComparator.bigIntegerValue(second));
    }

    private static BigInteger bigIntegerValue(String checkpointValue) {
        if (SequenceNumberValidator.isDigits(checkpointValue)) {
            return new BigInteger(checkpointValue);
        }
        if (SentinelCheckpoint.LATEST.toString().equals(checkpointValue)) {
            return LATEST_BIG_INTEGER_VALUE;
        }
        if (SentinelCheckpoint.TRIM_HORIZON.toString().equals(checkpointValue)) {
            return TRIM_HORIZON_BIG_INTEGER_VALUE;
        }
        throw new IllegalArgumentException("Expected a string of digits, TRIM_HORIZON, or LATEST but received " + checkpointValue);
    }

    private static boolean isDigitsOrSentinelValue(String string) {
        return SequenceNumberValidator.isDigits(string) || CheckpointValueComparator.isSentinelValue(string);
    }

    private static boolean isSentinelValue(String string) {
        try {
            SentinelCheckpoint.valueOf(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

