/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.dataengine.metadata.AJTableMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.dataengine.filters.IFilter;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.jdbc.utils.StringWrapperFilter;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AJTablesMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private AJClient m_client;
    private List<AJTableMetadata> m_tableMetadataList = new ArrayList<AJTableMetadata>();
    private ListIterator<AJTableMetadata> m_tableMetadataIterator;
    private AJTableMetadata m_currentTableMetadata;

    public AJTablesMetadataSource(ILogger iLogger, AJClient aJClient, ArrayList<IFilter> arrayList) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, aJClient);
        this.m_client = aJClient;
        this.m_logger = iLogger;
        StringWrapperFilter stringWrapperFilter = null;
        StringWrapperFilter stringWrapperFilter2 = null;
        StringWrapperFilter stringWrapperFilter3 = null;
        for (IFilter iFilter : arrayList) {
            switch (iFilter.getColumnTag()) {
                case CATALOG_NAME: {
                    stringWrapperFilter = new StringWrapperFilter(iFilter);
                    break;
                }
                case SCHEMA_NAME: {
                    stringWrapperFilter2 = new StringWrapperFilter(iFilter);
                    break;
                }
                case TABLE_NAME: {
                    stringWrapperFilter3 = new StringWrapperFilter(iFilter);
                    break;
                }
            }
        }
        this.initMetadata(stringWrapperFilter, stringWrapperFilter2, stringWrapperFilter3);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_catalogName, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_schemaName, dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_tableName, dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_tableType, dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTableMetadata.m_remarks, dataWrapper, l, l2);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_tableMetadataIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentTableMetadata = this.m_tableMetadataIterator.next();
            return true;
        }
        return false;
    }

    private void initMetadata(StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, StringWrapperFilter stringWrapperFilter3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, stringWrapperFilter, stringWrapperFilter2, stringWrapperFilter3);
        if (stringWrapperFilter.filter("AwsDataCatalog")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.m_client.getSchemas(arrayList);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string : arrayList) {
                if (!stringWrapperFilter2.filter(string)) continue;
                arrayList2.add(string);
            }
            for (String string : arrayList2) {
                ArrayList<AJTableMetadata> arrayList3 = new ArrayList<AJTableMetadata>();
                this.m_client.getTablesMetadata(string, arrayList3);
                for (AJTableMetadata aJTableMetadata : arrayList3) {
                    if (!stringWrapperFilter3.filter(aJTableMetadata.m_tableName)) continue;
                    this.m_tableMetadataList.add(aJTableMetadata);
                }
            }
        }
        this.m_tableMetadataIterator = this.m_tableMetadataList.listIterator(0);
    }
}

