/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import moa.gui.experimentertab.Measure;
import moa.gui.experimentertab.RankingGraph;
import moa.gui.experimentertab.ReadFile;
import moa.gui.experimentertab.Stream;
import moa.gui.experimentertab.statisticaltests.PValuePerTwoAlgorithm;
import moa.gui.experimentertab.statisticaltests.RankPerAlgorithm;
import moa.gui.experimentertab.statisticaltests.StatisticalTest;
import nz.ac.waikato.cms.gui.core.BaseDirectoryChooser;
import org.apache.commons.io.FilenameUtils;

public class AnalyzeTab
extends JPanel {
    private String[] algorithms;
    ArrayList<RankPerAlgorithm> rank = null;
    ArrayList<PValuePerTwoAlgorithm> pvalues = null;
    private DefaultTableModel algoritmModel;
    private DefaultTableModel streamModel;
    private String path = "";
    private LinkedList<String> measures = new LinkedList();
    ReadFile rf;
    private JButton jButtonDelAlgoritm;
    private JButton jButtonDelStream;
    private JButton jButtonImage;
    private JButton jButtonReset;
    private JButton jButtonResults;
    private JButton jButtonTest;
    private JComboBox jComboBoxMeasure;
    private JComboBox jComboBoxTest;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelDirectory;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneAlgorithms;
    private JScrollPane jScrollPaneStreams;
    private JSpinner jSpinnerPvalue;
    private JTable jTableAlgoritms;
    private JTable jTableStreams;
    private JTextArea jTextAreaOut;
    private JTextField jTextFieldResultsPath;

    public AnalyzeTab() {
        this.initComponents();
        this.algoritmModel = (DefaultTableModel)this.jTableAlgoritms.getModel();
        this.streamModel = (DefaultTableModel)this.jTableStreams.getModel();
        this.jTextAreaOut.addMouseListener(new PopClickListener());
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        AnalyzeTab panel = new AnalyzeTab();
        panel.setOpaque(true);
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPaneAlgorithms = new JScrollPane();
        this.jTableAlgoritms = new JTable();
        this.jScrollPaneStreams = new JScrollPane();
        this.jTableStreams = new JTable();
        this.jTextFieldResultsPath = new JTextField();
        this.jButtonResults = new JButton();
        this.jLabelDirectory = new JLabel();
        this.jButtonDelAlgoritm = new JButton();
        this.jButtonDelStream = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxTest = new JComboBox();
        this.jButtonTest = new JButton();
        this.jButtonImage = new JButton();
        this.jLabel3 = new JLabel();
        this.jSpinnerPvalue = new JSpinner();
        this.jButtonReset = new JButton();
        this.jComboBoxMeasure = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaOut = new JTextArea();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.jScrollPaneAlgorithms.setBorder(BorderFactory.createTitledBorder("Algorithm"));
        this.jTableAlgoritms.setBorder(BorderFactory.createTitledBorder(""));
        this.jTableAlgoritms.setModel(new DefaultTableModel(new Object[0][], new String[]{"Algorithm", "Algorithm ID"}));
        this.jScrollPaneAlgorithms.setViewportView(this.jTableAlgoritms);
        this.jScrollPaneStreams.setBorder(BorderFactory.createTitledBorder("Stram"));
        this.jTableStreams.setBorder(BorderFactory.createTitledBorder(""));
        this.jTableStreams.setModel(new DefaultTableModel(new Object[0][], new String[]{"Stream", "Stream ID"}));
        this.jScrollPaneStreams.setViewportView(this.jTableStreams);
        this.jButtonResults.setText("Browse");
        this.jButtonResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyzeTab.this.jButtonResultsActionPerformed(evt);
            }
        });
        this.jLabelDirectory.setHorizontalAlignment(4);
        this.jLabelDirectory.setText("Result  folder");
        this.jButtonDelAlgoritm.setText("Delete Algorithm");
        this.jButtonDelAlgoritm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyzeTab.this.jButtonDelAlgoritmActionPerformed(evt);
            }
        });
        this.jButtonDelStream.setText("Delete Stream");
        this.jButtonDelStream.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyzeTab.this.jButtonDelStreamActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabelDirectory).addGap(18, 18, 18).addComponent(this.jTextFieldResultsPath).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonResults)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDelAlgoritm).addComponent(this.jScrollPaneAlgorithms, -1, 327, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneStreams, -2, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelStream).addGap(0, 216, Short.MAX_VALUE))))).addGap(16, 16, 16)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldResultsPath, -2, 23, -2).addComponent(this.jButtonResults).addComponent(this.jLabelDirectory)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneAlgorithms, -1, 164, Short.MAX_VALUE).addComponent(this.jScrollPaneStreams, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDelStream).addComponent(this.jButtonDelAlgoritm))));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Statistical Test"));
        this.jLabel2.setText("Test");
        this.jComboBoxTest.setModel(new DefaultComboBoxModel<String>(new String[]{"Holm", "Shaffer", "Nemenyi"}));
        this.jButtonTest.setText("Run Test");
        this.jButtonTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyzeTab.this.jButtonTestActionPerformed(evt);
            }
        });
        this.jButtonImage.setText("Image");
        this.jButtonImage.setEnabled(false);
        this.jButtonImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyzeTab.this.jButtonImageActionPerformed(evt);
            }
        });
        this.jLabel3.setText("pValue");
        this.jSpinnerPvalue.setModel(new SpinnerNumberModel((Number)0.05, null, null, (Number)0.001));
        this.jButtonReset.setText("Reset to Default");
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalyzeTab.this.jButtonResetActionPerformed(evt);
            }
        });
        this.jLabel4.setText("measure");
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"Mean", "Last"}));
        this.jLabel1.setText("type");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxTest, 0, -1, Short.MAX_VALUE).addComponent(this.jSpinnerPvalue).addComponent(this.jComboBoxMeasure, 0, -1, Short.MAX_VALUE))).addGroup(jPanel2Layout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jButtonTest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReset).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBoxType, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxTest, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerPvalue, -2, -1, -2).addComponent(this.jLabel3)).addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxMeasure, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxType, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonTest).addComponent(this.jButtonImage).addComponent(this.jButtonReset))));
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Output"));
        this.jTextAreaOut.setColumns(20);
        this.jTextAreaOut.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaOut);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 682, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(289, 289, 289).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 113, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(300, Short.MAX_VALUE))));
    }

    private void jButtonResultsActionPerformed(ActionEvent evt) {
        BaseDirectoryChooser resultsFile = new BaseDirectoryChooser();
        int selection = resultsFile.showOpenDialog((Component)this);
        if (selection == 0) {
            this.path = resultsFile.getSelectedFile().getAbsolutePath();
        }
        if (!this.path.equals("")) {
            this.reset();
            this.jTextFieldResultsPath.setText(this.path);
            this.rf = new ReadFile(this.path);
            String str = this.rf.processFiles();
            if (str.equals("")) {
                String[] measuresNames;
                int i;
                int algSize = this.rf.getAlgShortNames().size();
                int streamSize = this.rf.getStream().size();
                this.measures = this.rf.getMeasures();
                for (i = 0; i < algSize; ++i) {
                    this.algoritmModel.addRow(new Object[]{this.rf.getAlgNames().get(i), this.rf.getAlgShortNames().get(i)});
                }
                for (i = 0; i < streamSize; ++i) {
                    this.streamModel.addRow(new Object[]{this.rf.getStream().get(i), this.rf.getStream().get(i)});
                }
                for (String measuresName : measuresNames = this.measures.getFirst().split(",")) {
                    this.jComboBoxMeasure.addItem(measuresName);
                    if (!measuresName.equals("classifications correct (percent)") && !measuresName.equals("[avg] classifications correct (percent)")) continue;
                    this.jComboBoxMeasure.setSelectedItem(measuresName);
                }
            } else {
                JOptionPane.showMessageDialog(this, str, "Error", 0);
            }
        }
    }

    private void jButtonDelAlgoritmActionPerformed(ActionEvent evt) {
        if (this.jTableAlgoritms.getSelectedRow() != -1) {
            this.algoritmModel.removeRow(this.jTableAlgoritms.getSelectedRow());
            String[] algorithms = new String[this.algoritmModel.getRowCount()];
            for (int i = 0; i < this.algoritmModel.getRowCount(); ++i) {
                algorithms[i] = this.algoritmModel.getValueAt(i, 0).toString();
            }
            if (this.streamModel.getValueAt(0, 0).toString() != null) {
                this.rf.updateMeasures(algorithms, this.streamModel.getValueAt(0, 0).toString());
                this.measures = this.rf.getMeasures();
                String[] measuresNames = this.measures.getFirst().split(",");
                this.jComboBoxMeasure.removeAllItems();
                for (String measuresName : measuresNames) {
                    this.jComboBoxMeasure.addItem(measuresName);
                    if (!measuresName.equals("classifications correct (percent)") && !measuresName.equals("[avg] classifications correct (percent)")) continue;
                    this.jComboBoxMeasure.setSelectedItem(measuresName);
                }
            }
        }
    }

    private void jButtonDelStreamActionPerformed(ActionEvent evt) {
        this.streamModel.removeRow(this.jTableStreams.getSelectedRow());
    }

    private void jButtonTestActionPerformed(ActionEvent evt) {
        if (this.jTextFieldResultsPath.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Directory not found", "Error", 0);
            return;
        }
        ArrayList<Measure> algmeasures = new ArrayList<Measure>();
        ArrayList<Stream> streams = new ArrayList<Stream>();
        ArrayList<String> algPath = new ArrayList<String>();
        ArrayList<String> algShortNames = new ArrayList<String>();
        boolean count = false;
        boolean type = true;
        type = this.jComboBoxType.getSelectedItem().toString().equals("Mean");
        Measure m = new Measure(this.jComboBoxMeasure.getSelectedItem().toString(), this.jComboBoxMeasure.getSelectedItem().toString(), type, 0);
        algmeasures.add(m);
        String path = this.jTextFieldResultsPath.getText();
        for (int i = 0; i < this.streamModel.getRowCount(); ++i) {
            algPath.clear();
            for (int j = 0; j < this.algoritmModel.getRowCount(); ++j) {
                File inputFile = new File(FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0) + "\\" + this.algoritmModel.getValueAt(j, 0))));
                File streamFile = new File(FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0))));
                if (!inputFile.exists()) {
                    JOptionPane.showMessageDialog(this, "File not found: " + inputFile.getAbsolutePath(), "Error", 0);
                    return;
                }
                String algorithmPath = FilenameUtils.separatorsToSystem((String)(path + "\\" + this.streamModel.getValueAt(i, 0).toString() + "\\" + this.algoritmModel.getValueAt(j, 0).toString()));
                algPath.add(algorithmPath);
                if (i != 0) continue;
                algShortNames.add(this.algoritmModel.getValueAt(j, 1).toString());
            }
            Stream s = new Stream(this.streamModel.getValueAt(i, 1).toString(), algPath, algShortNames, algmeasures);
            streams.add(s);
        }
        StatisticalTest test = new StatisticalTest(streams);
        try {
            test.readData();
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(this, "Problem with csv file", "Error", 0);
            return;
        }
        test.avgPerformance();
        this.jTextAreaOut.append("P-values involving all algorithms\n");
        this.jTextAreaOut.append(System.getProperty("line.separator"));
        this.jTextAreaOut.append("P-value computed by Friedman Test: " + test.getFriedmanPValue() + "\n");
        this.jTextAreaOut.append("P-value computed by Iman and Daveport Test: " + test.getImanPValue() + "\n");
        this.rank = test.getRankAlg();
        this.jTextAreaOut.append(System.getProperty("line.separator"));
        this.jTextAreaOut.append("Ranking of the algorithms\n");
        this.jTextAreaOut.append(System.getProperty("line.separator"));
        this.rank.stream().forEach(rank1 -> this.jTextAreaOut.append(rank1.algName + ": " + rank1.rank + "\n"));
        switch (this.jComboBoxTest.getSelectedItem().toString()) {
            case "Holm": {
                this.pvalues = test.holmTest();
                break;
            }
            case "Shaffer": {
                this.pvalues = test.shafferTest();
                break;
            }
            case "Nemenyi": {
                this.pvalues = test.nemenyiTest();
            }
        }
        this.jTextAreaOut.append(System.getProperty("line.separator"));
        this.jTextAreaOut.append("P-values of classifiers against each other\n");
        this.jTextAreaOut.append(System.getProperty("line.separator"));
        this.pvalues.stream().forEach(pvalue -> this.jTextAreaOut.append(pvalue.algName1 + " vs " + pvalue.algName2 + ": " + pvalue.PValue + "\n"));
        this.jButtonImage.setEnabled(true);
    }

    private void jButtonImageActionPerformed(ActionEvent evt) {
        RankingGraph graf = new RankingGraph(this.rank, this.pvalues, this.jTextFieldResultsPath.getText(), Double.parseDouble(this.jSpinnerPvalue.getValue().toString()));
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this.reset();
    }

    public void cleanTables() {
        try {
            int i;
            DefaultTableModel algModel = (DefaultTableModel)this.jTableAlgoritms.getModel();
            DefaultTableModel strModel = (DefaultTableModel)this.jTableStreams.getModel();
            int rows = this.jTableAlgoritms.getRowCount();
            int srow = this.jTableStreams.getRowCount();
            for (i = 0; i < rows; ++i) {
                algModel.removeRow(0);
            }
            for (i = 0; i < srow; ++i) {
                strModel.removeRow(0);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error cleaning the table.");
        }
    }

    private void reset() {
        this.cleanTables();
        this.jTextFieldResultsPath.setText("");
        this.jComboBoxMeasure.removeAllItems();
        this.jComboBoxTest.setSelectedItem("Holm");
        this.jSpinnerPvalue.setValue(0.05);
        this.jButtonTest.setSelected(false);
        this.jButtonImage.setSelected(false);
    }

    public void readData(String path) {
        this.reset();
        this.jTextFieldResultsPath.setText(path);
        this.path = path;
        this.rf = new ReadFile(path);
        String str = this.rf.processFiles();
        if (str.equals("")) {
            String[] measuresNames;
            int i;
            int algSize = this.rf.getAlgShortNames().size();
            int streamSize = this.rf.getStream().size();
            this.measures = this.rf.getMeasures();
            for (i = 0; i < algSize; ++i) {
                this.algoritmModel.addRow(new Object[]{this.rf.getAlgNames().get(i), this.rf.getAlgShortNames().get(i)});
            }
            for (i = 0; i < streamSize; ++i) {
                this.streamModel.addRow(new Object[]{this.rf.getStream().get(i), this.rf.getStream().get(i)});
            }
            for (String measuresName : measuresNames = this.measures.getFirst().split(",")) {
                this.jComboBoxMeasure.addItem(measuresName);
                if (!measuresName.equals("classifications correct (percent)") && !measuresName.equals("[avg] classifications correct (percent)")) continue;
                this.jComboBoxMeasure.setSelectedItem(measuresName);
            }
        } else {
            JOptionPane.showMessageDialog(this, str, "Error", 0);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnalyzeTab.createAndShowGUI();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class PopClickListener
    extends MouseAdapter {
        PopClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        private void doPop(MouseEvent e) {
            PopupMenu menu = new PopupMenu();
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class PopupMenu
    extends JPopupMenu {
        JMenuItem anItem = new JMenuItem("Clear");

        public PopupMenu() {
            this.add(this.anItem);
            ActionListener listener = event -> AnalyzeTab.this.jTextAreaOut.setText("");
            this.anItem.addActionListener(listener);
        }
    }
}

