/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.ruleSet;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.ComplexSet;
import dmLab.classifier.adx.complex.complexLinks.ComplexLink;
import dmLab.classifier.adx.complex.complexLinks.ComplexLinks;
import dmLab.classifier.adx.selector.SelectorList;

public final class RuleSet {
    public ComplexSet[] complexSetArray;
    public ComplexLinks complexLinks = null;
    protected int decValIndex;
    private ADXParams adxParams;
    public boolean verbose = false;

    /*
     * WARNING - void declaration
     */
    public RuleSet(int maxComplexLength, ADXParams adxParams) {
        void var2_2;
        void var1_1;
        this.complexSetArray = new ComplexSet[var1_1];
        this.adxParams = var2_2;
    }

    public final void calcGlobalParams() {
        this.complexLinks.calcGlobalParams$4379dc3a();
    }

    public final boolean createRules(FArray array, SelectorList selectorList, int decisionValIndex) {
        this.decValIndex = decisionValIndex;
        if (this.adxParams.keepMinimalSet && this.adxParams.searchBeam < selectorList.size()) {
            if (this.verbose) {
                System.out.print("Deleting surplus selectors...");
            }
            selectorList.deleteInsignificant(this.adxParams.searchBeam, this.adxParams.qMethod);
            if (this.verbose) {
                System.out.println(" Done. Current selectors base size: " + selectorList.size());
            }
        }
        FArray fArray = array;
        this.complexSetArray[0] = new ComplexSet(selectorList, this.adxParams, fArray.attributes.length);
        for (int currentComplexLength = 1; currentComplexLength < this.complexSetArray.length; ++currentComplexLength) {
            if (this.verbose) {
                System.out.println("Iteration " + currentComplexLength + " of " + (this.complexSetArray.length - 1));
            }
            double minQuality = this.complexSetArray[currentComplexLength - 1].findSignificantQuality();
            int toReproduce = this.complexSetArray[currentComplexLength - 1].selectComplexesToReproduce(minQuality);
            if (this.verbose) {
                System.out.println("Complexes to reproducing: " + toReproduce);
            }
            if (toReproduce == 0) break;
            if (this.verbose) {
                System.out.print("Generating complexes candidates (size=" + currentComplexLength + ")...");
            }
            FArray fArray2 = array;
            this.complexSetArray[currentComplexLength] = new ComplexSet(selectorList, this.complexSetArray[currentComplexLength - 1], this.adxParams, fArray2.attributes.length);
            this.complexSetArray[currentComplexLength].verbose = this.verbose;
            if (this.verbose) {
                System.out.println(this.complexSetArray[currentComplexLength].size() + " Complexes generated.");
            }
            if (this.testStopCriteria(currentComplexLength)) break;
            if (this.verbose) {
                System.out.println("Evaluating complexes candidates...");
            }
            this.complexSetArray[currentComplexLength].evaluate$1594a9c8(array, decisionValIndex);
            if (this.verbose) {
                System.out.println(this.complexSetArray[currentComplexLength].size() + " Complexes evaluated.");
            }
            if (this.verbose) {
                System.out.print("Clenaning candidates...");
            }
            this.complexSetArray[currentComplexLength].cleanCandidatesSet(selectorList, this.adxParams);
            if (this.verbose) {
                System.out.println(" Done. Current complexes (size=" + currentComplexLength + ") number is " + this.complexSetArray[currentComplexLength].size());
            }
            if (this.testStopCriteria(currentComplexLength)) break;
            if (!this.adxParams.keepMinimalSet || this.adxParams.searchBeam >= this.complexSetArray[currentComplexLength].size()) continue;
            double d = this.complexSetArray[currentComplexLength].findSignificantQuality();
            if (this.verbose) {
                System.out.print("Deleting surplus complexes...");
            }
            this.complexSetArray[currentComplexLength].deleteComplexesQLess(d);
            if (!this.verbose) continue;
            System.out.println(" Done. Current complexes (size=" + currentComplexLength + ") number is " + this.complexSetArray[currentComplexLength].size());
        }
        return true;
    }

    private boolean testStopCriteria(int currentComplexLength) {
        if (this.complexSetArray[currentComplexLength].size() == 0) {
            if (this.verbose) {
                System.out.println("Stop criterion has been met.");
            }
            this.complexSetArray[var1_1] = null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(SelectorList selectorsList, FArray array) {
        void var3_3;
        StringBuffer tmp = new StringBuffer();
        tmp.append("#Rules for decision = " + ((Array)array).getDecValuesStr()[this.decValIndex]).append('\n');
        for (int i = 0; i < this.complexSetArray.length; ++i) {
            if (this.complexSetArray[i] == null) continue;
            tmp.append(this.complexSetArray[i].toString(selectorsList, array));
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final double calcScore(SelectorList selectorsList, FArray array, int eventIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.complexLinks.calcScore((SelectorList)var1_1, (FArray)var2_2, (int)var3_3, this.adxParams);
    }

    public final boolean covers(SelectorList selectorsList, FArray array, int eventIndex) {
        for (int i = 0; i < this.complexSetArray.length; ++i) {
            if (this.complexSetArray[i] == null) continue;
            int size = this.complexSetArray[i].size();
            for (int j = 0; j < size; ++j) {
                if (!this.complexSetArray[i].getComplex(j).covers(selectorsList, array, eventIndex)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean createLinks(ADXParams adxParams) {
        RuleSet ruleSet = this;
        int n = 0;
        for (int i = 0; i < ruleSet.complexSetArray.length; ++i) {
            if (ruleSet.complexSetArray[i] == null) continue;
            n += ruleSet.complexSetArray[i].size();
        }
        ComplexLink[] links = new ComplexLink[n];
        int link = 0;
        for (int i = 0; i < this.complexSetArray.length; ++i) {
            if (this.complexSetArray[i] == null) continue;
            int size = this.complexSetArray[i].size();
            for (int j = 0; j < size; ++j) {
                Complex complex = this.complexSetArray[i].getComplex(j);
                links[link++] = new ComplexLink(complex, i, j, this.complexSetArray[i].getComplex(j).calcQuality(adxParams.qMethodFinal));
            }
        }
        this.complexLinks = new ComplexLinks((ComplexLink[])ruleSet);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesPosLessNeg() {
        void var1_1;
        int removed = 0;
        for (int i = 0; i < this.complexSetArray.length; ++i) {
            if (this.complexSetArray[i] != null) {
                removed += this.complexSetArray[i].deleteComplexesPosLessNeg();
            }
            if (this.complexSetArray[i] == null || this.complexSetArray[i].size() != 0) continue;
            this.complexSetArray[i] = null;
        }
        return (int)var1_1;
    }
}

