/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import java.util.BitSet;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.BinRelation;
import org.chocosolver.solver.variables.IntVar;

class CouplesBitSetTable
extends BinRelation {
    private final BitSet[][] table;
    private final int[] offsets;

    public CouplesBitSetTable(Tuples tuples, IntVar var1, IntVar var2) {
        int i;
        this.offsets = new int[]{var1.getLB(), var2.getLB()};
        int range1 = var1.getUB() - this.offsets[0] + 1;
        int range2 = var2.getUB() - this.offsets[1] + 1;
        this.table = new BitSet[2][];
        this.table[0] = new BitSet[range1];
        boolean feasible = tuples.isFeasible();
        for (i = 0; i < range1; ++i) {
            this.table[0][i] = new BitSet(range2);
            if (feasible) continue;
            this.table[0][i].set(0, range2);
        }
        this.table[1] = new BitSet[range2];
        for (i = 0; i < range2; ++i) {
            this.table[1][i] = new BitSet(range1);
            if (feasible) continue;
            this.table[1][i].set(0, range1);
        }
        int nt = tuples.nbTuples();
        for (int i2 = 0; i2 < nt; ++i2) {
            int[] tuple = tuples.get(i2);
            if (!var1.contains(tuple[0]) || !var2.contains(tuple[1])) continue;
            if (feasible) {
                this.table[0][tuple[0] - this.offsets[0]].set(tuple[1] - this.offsets[1]);
                this.table[1][tuple[1] - this.offsets[1]].set(tuple[0] - this.offsets[0]);
                continue;
            }
            this.table[0][tuple[0] - this.offsets[0]].clear(tuple[1] - this.offsets[1]);
            this.table[1][tuple[1] - this.offsets[1]].clear(tuple[0] - this.offsets[0]);
        }
    }

    @Override
    public boolean isConsistent(int x, int y) {
        return this.table[0][x - this.offsets[0]].get(y - this.offsets[1]);
    }

    @Override
    public boolean checkCouple(int x, int y) {
        return this.table[0][x - this.offsets[0]].get(y - this.offsets[1]);
    }

    public boolean checkUnsupportedValue(int var, int val, IntVar v) {
        int UB = v.getUB();
        BitSet _table = this.table[var][val - this.offsets[var]];
        int o = this.offsets[1 - var];
        int i = v.getLB();
        while (i <= UB) {
            if (_table.get(i - o)) {
                return false;
            }
            i = v.nextValue(i);
        }
        return true;
    }

    @Override
    public Tuples convert() {
        Tuples tuples = new Tuples(true);
        for (int i = 0; i < this.table[0].length; ++i) {
            int b = this.table[0][i].nextSetBit(0);
            while (b > -1) {
                tuples.add(i + this.offsets[0], b + this.offsets[1]);
                b = this.table[0][i].nextSetBit(b + 1);
            }
        }
        return tuples;
    }
}

