/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.ArrayList;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.charges.GasteigerPEPEPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class PartialTChargePEOEDescriptor
extends AbstractAtomicDescriptor {
    private static final String[] NAMES = new String[]{"pepeT"};
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private GasteigerPEPEPartialCharges pepe = new GasteigerPEPEPartialCharges();
    private int maxIterations = -1;
    private int maxResonStruc = -1;
    private boolean lpeChecker = true;

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#PartialTChargePEOE", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 3) {
            throw new CDKException("PartialPiChargeDescriptor only expects three parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
        if (params.length > 1 && params[1] != null) {
            if (!(params[1] instanceof Boolean)) {
                throw new CDKException("The parameter must be of type Boolean");
            }
            this.lpeChecker = (Boolean)params[1];
        }
        if (params.length > 2 && params[2] != null) {
            if (!(params[2] instanceof Integer)) {
                throw new CDKException("The parameter must be of type Integer");
            }
            this.maxResonStruc = (Integer)params[2];
        }
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations, this.lpeChecker, this.maxResonStruc};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        Double originalCharge = atom.getCharge();
        String originalAtomtypeName = atom.getAtomTypeName();
        Integer originalNeighborCount = atom.getFormalNeighbourCount();
        Integer originalValency = atom.getValency();
        IAtomType.Hybridization originalHybridization = atom.getHybridization();
        Double originalBondOrderSum = atom.getBondOrderSum();
        IBond.Order originalMaxBondOrder = atom.getMaxBondOrder();
        if (!this.isCachedAtomContainer(ac)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)ac);
            }
            catch (CDKException e) {
                new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, (Exception)((Object)e));
            }
            if (this.lpeChecker) {
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                try {
                    lpcheck.saturate(ac);
                }
                catch (CDKException e) {
                    new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, (Exception)((Object)e));
                }
            }
            if (this.maxIterations != -1) {
                this.pepe.setMaxGasteigerIters(this.maxIterations);
            }
            if (this.maxResonStruc != -1) {
                this.pepe.setMaxResoStruc(this.maxResonStruc);
            }
            try {
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(ac, true);
                ArrayList<Double> peoeAtom = new ArrayList<Double>();
                for (IAtom value : ac.atoms()) {
                    peoeAtom.add(value.getCharge());
                }
                for (IAtom iAtom : ac.atoms()) {
                    iAtom.setCharge(Double.valueOf(0.0));
                }
                this.pepe.assignGasteigerPiPartialCharges(ac, true);
                for (int i = 0; i < ac.getAtomCount(); ++i) {
                    this.cacheDescriptorValue(ac.getAtom(i), ac, (IDescriptorResult)new DoubleResult((Double)peoeAtom.get(i) + ac.getAtom(i).getCharge()));
                }
            }
            catch (Exception e) {
                new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, e);
            }
        }
        atom.setCharge(originalCharge);
        atom.setAtomTypeName(originalAtomtypeName);
        atom.setFormalNeighbourCount(originalNeighborCount);
        atom.setValency(originalValency);
        atom.setHybridization(originalHybridization);
        atom.setMaxBondOrder(originalMaxBondOrder);
        atom.setBondOrderSum(originalBondOrderSum);
        return this.getCachedDescriptorValue(atom) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(atom), NAMES) : null;
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations", "lpeChecker", "maxResonStruc"};
        return params;
    }

    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        if ("lpeChecker".equals(name)) {
            return Boolean.TRUE;
        }
        if ("maxResonStruc".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

