/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RDataOutput;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RVector;

public class RBooleanVector
extends RVector<Boolean> {
    private int[] values = null;
    public static final RBooleanVector EMPTY = new RBooleanVector(new int[0], null);

    public RBooleanVector(Boolean value, RPair attributes) {
        this(Collections.singletonList(value), attributes);
    }

    public RBooleanVector(List<Boolean> values, RPair attributes) {
        super(attributes);
        this.values = values.stream().mapToInt(value -> {
            if (value == null) {
                return Integer.MIN_VALUE;
            }
            return value != false ? 1 : 0;
        }).toArray();
    }

    public RBooleanVector(int[] values, RPair attributes) {
        super(attributes);
        this.values = values;
    }

    @Override
    int type() {
        return 10;
    }

    @Override
    void writeValues(RDataOutput output) throws IOException {
        int[] values = this.values;
        int length = values.length;
        output.writeInt(length);
        for (int i = 0; i < length; ++i) {
            output.writeInt(values[i]);
        }
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Boolean getValue(int index) {
        int value = this.values[index];
        if (value == Integer.MIN_VALUE) {
            return null;
        }
        return value == 1;
    }

    @Override
    public List<Boolean> getValues() {
        Function<Integer, Boolean> function = new Function<Integer, Boolean>(){

            public Boolean apply(Integer value) {
                if (value == Integer.MIN_VALUE) {
                    return null;
                }
                return value == 1;
            }
        };
        return Lists.transform((List)Ints.asList((int[])this.values), (Function)function);
    }
}

