/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.collections;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.jpmml.model.collections.AbstractFixedSizeList;
import org.jpmml.model.collections.DoubletonList;
import org.jpmml.model.collections.SingletonList;

public class TripletonList<E>
extends AbstractFixedSizeList<E>
implements RandomAccess,
Serializable {
    private E first = null;
    private E second = null;
    private E third = null;

    public TripletonList(E first, E second, E third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public E get(int index) {
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E set(int index, E element) {
        switch (index) {
            case 0: {
                E result = this.first;
                this.first = element;
                return result;
            }
            case 1: {
                E result = this.second;
                this.second = element;
                return result;
            }
            case 2: {
                E result = this.third;
                this.third = element;
                return result;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > 3) {
            throw new IndexOutOfBoundsException();
        }
        int length = toIndex - fromIndex;
        switch (length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return new SingletonList<E>(this.get(fromIndex));
            }
            case 2: {
                return new DoubletonList<E>(this.get(fromIndex), this.get(fromIndex + 1));
            }
            case 3: {
                return this;
            }
        }
        throw new IllegalArgumentException();
    }
}

