/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.security;

import com.qarks.util.security.CipherEncryptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;

public abstract class FileEncryptor
extends CipherEncryptor {
    public void encryptFile(File file, File file2) throws FileNotFoundException, InvalidKeyException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.encryptStream(fileInputStream, fileOutputStream);
    }

    public void encryptFile(String string, String string2) throws FileNotFoundException, InvalidKeyException, IOException {
        this.encryptFile(new File(string), new File(string2));
    }

    public byte[] encryptBytes(byte[] byArray) throws InvalidKeyException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encryptStream(byteArrayInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void decryptFile(File file, File file2) throws FileNotFoundException, InvalidKeyException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.decryptStream(fileInputStream, fileOutputStream);
    }

    public void decryptFile(String string, String string2) throws FileNotFoundException, InvalidKeyException, IOException {
        this.decryptFile(new File(string), new File(string2));
    }

    public byte[] decryptBytes(byte[] byArray) throws InvalidKeyException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decryptStream(byteArrayInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public abstract void encryptStream(InputStream var1, OutputStream var2) throws InvalidKeyException, IOException;

    public abstract void decryptStream(InputStream var1, OutputStream var2) throws InvalidKeyException, IOException;
}

