% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_version.R
\name{get_package_version}
\alias{get_package_version}
\title{Query Installed Package Version}
\usage{
get_package_version(x, lib_loc = NULL)
}
\arguments{
\item{x}{A character giving the package name.}

\item{lib_loc}{See argument \code{lib.loc} in
\code{\link{packageDescription}}.}
}
\value{
A character giving the package version.
}
\description{
\code{\link{packageVersion}} converts to class \code{\link{package_version}},
which then again would need to be converted for \code{\link{compareVersion}}.
So this is a modified copy of \code{\link{packageVersion}} skipping the
conversion to \code{\link{package_version}}.
}
\examples{
get_package_version("base")
try(get_package_version("mgcv"))
utils::compareVersion("1000.0.0", get_package_version("base"))
utils::compareVersion("1.0", get_package_version("base"))
# from ?is_version_sufficient:
is_version_sufficient(installed = get_package_version("base"),
                      required = "1.0")
}
\seealso{
Other version functions: 
\code{\link{is_r_package_installed}()},
\code{\link{is_version_sufficient}()}

Other package functions: 
\code{\link{is_r_package_installed}()},
\code{\link{is_version_sufficient}()},
\code{\link{load_internal_functions}()}
}
\concept{package functions}
\concept{version functions}
