## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(chyper)

## -----------------------------------------------------------------------------
dchyper(k = 1, s = 50, n = c(300, 500), m = c(56, 14))

## -----------------------------------------------------------------------------
set.seed(1)
draws <- rchyper(10000, 50, c(300, 500), c(56, 14), verbose = F)
hist(draws, breaks = seq(0,5,1) - 0.5)
print(sum(draws==1)/length(draws))

## -----------------------------------------------------------------------------
pchyper(1, 50, c(300, 500), c(56, 14), F)

## -----------------------------------------------------------------------------
print(sum(draws<=1)/length(draws))

## -----------------------------------------------------------------------------
print(sort(draws)[length(draws)/2])
qchyper(0.5, 50, c(300, 500), c(56, 14), F)

## -----------------------------------------------------------------------------
pvalchyper(1, 50, c(300, 500), c(56, 14), "upper", F)

## -----------------------------------------------------------------------------
mleS(draws, c(300, 500), c(56, 14), F)

## -----------------------------------------------------------------------------
set.seed(1)
draws <- rchyper(10^5, 50, c(300, 500), c(56, 14), F)
mleS(draws, c(300, 500), c(56, 14), F)

## -----------------------------------------------------------------------------
mleM(1, draws, 50, c(300, 500), c(0, 14), F)

## -----------------------------------------------------------------------------
mleN(1, draws, 50, c(0, 500), c(56, 14), F)

