/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.IVectorTransformation;

public class HouseholderReflection
implements IVectorTransformation {
    private double beta_;
    private double mu_;
    private DataBlock v_;

    public static HouseholderReflection from(DataBlock v) {
        HouseholderReflection reflection = new HouseholderReflection();
        reflection.householder(v);
        return reflection;
    }

    public static HouseholderReflection inPlace(DataBlock v) {
        HouseholderReflection reflection = new HouseholderReflection();
        reflection.v_ = v.clone();
        reflection.inPlaceHouseholder();
        return reflection;
    }

    public DataBlock getHouseholderVector() {
        return this.v_;
    }

    public double getNrm2() {
        return this.mu_;
    }

    public double getBeta() {
        return this.beta_;
    }

    private void householder(DataBlock x) {
        int n = x.getLength();
        if (n == 1) {
            x.set(0, Math.abs(x.get(0)));
            return;
        }
        this.v_ = x.deepClone();
        this.inPlaceHouseholder();
        x.set(0.0);
        x.set(0, this.mu_);
    }

    private void inPlaceHouseholder() {
        int n = this.v_.getLength();
        if (n == 1) {
            return;
        }
        double[] v = this.v_.getData();
        int beg = this.v_.getStartPosition();
        int end = this.v_.getEndPosition();
        int inc = this.v_.getIncrement();
        double sig = 0.0;
        for (int i = beg + inc; i != end; i += inc) {
            sig += v[i] * v[i];
        }
        double x0 = v[beg];
        if (sig < 1.0E-17) {
            this.mu_ = Math.abs(x0);
            return;
        }
        this.mu_ = Math.sqrt(sig + x0 * x0);
        double v0 = x0 <= 0.0 ? x0 - this.mu_ : -sig / (x0 + this.mu_);
        this.beta_ = 2.0 / (sig + v0 * v0);
        v[beg] = v0;
    }

    @Override
    public void transform(DataBlock y) {
        if (this.beta_ == 0.0) {
            return;
        }
        double vy = y.dot(this.v_);
        y.addAY(-this.beta_ * vy, this.v_);
    }
}

