/*
 * Decompiled with CFR 0.152.
 */
package PairwiseMatchingExperimentalDesign;

import ExperimentalDesign.MultipleSearchExperimentalDesigns;
import java.util.Arrays;
import java.util.HashMap;

public class PairwiseMatchingExperimentalDesign
extends MultipleSearchExperimentalDesigns {
    private int[][] binary_pairs;
    private HashMap<Integer, int[]> unique_allocations;

    @Override
    public void beginSearch() {
        super.beginSearch();
        this.unique_allocations = new HashMap(this.max_designs);
        for (int i = 0; i < this.max_designs; ++i) {
            this.search_thread_pool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (PairwiseMatchingExperimentalDesign.this.search_stopped.get()) {
                        return;
                    }
                    while (true) {
                        int[] nArray = PairwiseMatchingExperimentalDesign.this.generateAllocation();
                        Integer n = Arrays.hashCode(nArray);
                        HashMap hashMap = PairwiseMatchingExperimentalDesign.this.unique_allocations;
                        synchronized (hashMap) {
                            if (PairwiseMatchingExperimentalDesign.this.unique_allocations.get(n) == null) {
                                PairwiseMatchingExperimentalDesign.this.unique_allocations.put(n, nArray);
                                break;
                            }
                        }
                    }
                    PairwiseMatchingExperimentalDesign.this.num_completed.getAndIncrement();
                }
            });
        }
        this.afterBeginSearch();
    }

    @Override
    protected void afterBeginSearch() {
        super.afterBeginSearch();
        Object[] objectArray = this.unique_allocations.values().toArray();
        for (int i = 0; i < this.max_designs; ++i) {
            this.ending_indicTs[i] = (int[])objectArray[i];
        }
    }

    protected int[] generateAllocation() {
        int[] nArray = new int[this.n];
        for (int i = 0; i < this.n / 2; ++i) {
            int[] nArray2 = this.binary_pairs[i];
            if (this.rand_obj.nextBoolean()) {
                nArray[nArray2[0]] = 1;
                nArray[nArray2[1]] = 0;
                continue;
            }
            nArray[nArray2[1]] = 1;
            nArray[nArray2[0]] = 0;
        }
        return nArray;
    }

    public void setMatchPairIndicies(int n, int[] nArray) {
        if (this.binary_pairs == null) {
            this.binary_pairs = new int[this.n / 2][];
        }
        this.binary_pairs[n] = nArray;
    }
}

