/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.data.Matrix;
import org.ejml.data.ReshapeMatrix;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.linsol.LinearSolver;

public class LinearSolverSafe<T extends ReshapeMatrix>
implements LinearSolver<T> {
    private LinearSolver<T> alg;
    private T A;
    private T B;

    public LinearSolverSafe(LinearSolver<T> alg) {
        this.alg = alg;
    }

    @Override
    public boolean setA(T A) {
        if (this.alg.modifiesA()) {
            if (this.A == null) {
                this.A = (ReshapeMatrix)A.copy();
            } else {
                if (this.A.getNumRows() != A.getNumRows() || this.A.getNumCols() != A.getNumCols()) {
                    this.A.reshape(A.getNumRows(), A.getNumCols());
                }
                this.A.set((Matrix)A);
            }
            return this.alg.setA(this.A);
        }
        return this.alg.setA(A);
    }

    @Override
    public double quality() {
        return this.alg.quality();
    }

    @Override
    public void solve(T B, T X) {
        if (this.alg.modifiesB()) {
            if (this.B == null) {
                this.B = (ReshapeMatrix)B.copy();
            } else {
                if (this.B.getNumRows() != B.getNumRows() || this.B.getNumCols() != B.getNumCols()) {
                    this.B.reshape(this.A.getNumRows(), B.getNumCols());
                }
                this.B.set((Matrix)B);
            }
            B = this.B;
        }
        this.alg.solve(B, X);
    }

    @Override
    public void invert(T A_inv) {
        this.alg.invert(A_inv);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public <D extends DecompositionInterface> D getDecomposition() {
        return this.alg.getDecomposition();
    }
}

