/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.epidemiology.SIRepidemic;
import dr.evomodel.epidemiology.SIRepidemicModelParser;
import dr.inference.model.Parameter;

public class SIRepidemicModel
extends DemographicModel {
    Parameter N0Parameter = null;
    Parameter growthRateParameter = null;
    Parameter tpeakParameter = null;
    Parameter gammaParameter = null;
    SIRepidemic sirepi = null;
    boolean usingGrowthRate = true;
    double minPrevalence = 0.0;

    public SIRepidemicModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type, boolean bl, double d) {
        this(SIRepidemicModelParser.SIREPI_MODEL, parameter, parameter2, parameter3, parameter4, type, bl, d);
    }

    public SIRepidemicModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type, boolean bl, double d) {
        super(string);
        this.sirepi = new SIRepidemic(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.tpeakParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.gammaParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.usingGrowthRate = bl;
        this.minPrevalence = d;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        double d;
        double d2;
        if (this.usingGrowthRate) {
            d2 = this.growthRateParameter.getParameterValue(0);
        } else {
            d = this.growthRateParameter.getParameterValue(0);
            d2 = Math.log(2.0) / d;
        }
        d = this.tpeakParameter.getParameterValue(0);
        double d3 = this.gammaParameter.getParameterValue(0);
        double d4 = 1.0 + d2 / d3;
        this.sirepi.setR0(d4);
        double d5 = this.sirepi.getsmin(d4);
        double d6 = this.sirepi.s_to_u(1.0 / d4, d5);
        this.sirepi.setN0(1.0);
        this.sirepi.setu0(d6);
        this.sirepi.unsetIntegrateIntensity();
        if (d >= 0.0) {
            this.sirepi.setGrowthRate(-d2);
            d6 = this.sirepi.getTransformedSusceptibles(d);
        } else {
            this.sirepi.setGrowthRate(d2);
            d6 = this.sirepi.getTransformedSusceptibles(-d);
        }
        boolean bl = this.sirepi.RKfail;
        double d7 = this.sirepi.u_to_i(d6, d5, d4);
        if (d7 < this.minPrevalence) {
            bl = true;
        }
        this.sirepi.setIntegrateIntensity();
        this.sirepi.setN0(this.N0Parameter.getParameterValue(0));
        this.sirepi.setGrowthRate(d2);
        this.sirepi.setu0(d6);
        this.sirepi.RKfail = bl;
        return this.sirepi;
    }
}

