% Generated by roxygen2: do not edit by hand
\name{arrows}
\alias{arrows}
\title{Draw Arrows on a Plot}
\arguments{
  \item{x0,y0}{starting coordinates of arrow(s)}
  \item{x1,y1}{ending coordinates of arrow(s)}
  \item{angle}{numeric; angle of arrow heads in degrees (def 30)}
  \item{length}{numeric; length of the arrow heads in inches (def 0.25)}
  \item{code}{integer; arrow head placement: 1 (start), 2 (end), 3 (both)}
  \item{...}{\{.help [graphical parameters](graphics::par)\}, e.g. `col`, `lty`, and`lwd`
}
}

\details{
Draw a simple arrow(s) from point A(s) to B(s)
\code{
plot(-10:10, -10:10, type = "n")
arrows(2, 2, 8, 8)
arrows(c(0,0), c(0,0), c(10,0), c(0,10))
}

Draw arrows with customized styles
\code{
arrows(8, -5, -5, 8, lwd = 2, col = "red")
}

Make error bars with \{.fun arrows\}
\code{
arrows(-2, -6, -8, 2, angle = 90, code = 3, length = .1)
}}

