/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui;

import javax.swing.SwingUtilities;

public class EventQueueSynchroniser {
    private static EventQueueSynchroniser instance = null;
    private boolean running = false;

    private EventQueueSynchroniser() {
    }

    public static synchronized EventQueueSynchroniser getInstance() {
        if (instance == null) {
            instance = new EventQueueSynchroniser();
        }
        return instance;
    }

    public void invoke(final Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRun(runnable);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventQueueSynchroniser.this.doRun(runnable);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun(Runnable runnable) {
        try {
            this.running = true;
            runnable.run();
        }
        finally {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

